VideoQuizApp = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,

    // Set initial options here
    options: {

    },
    originalOptions:null,
		firstTry:true,
		firstTryCorrect:false,
		answered:0,
		correctAnswered:0,
		selectedVid:null,
		currentCorrectVid:null,
		currentSegment:0,
		selectedOrder:new Array(),
    // initialize - widget initialization
    initialize: function(options) {
    	this.parent(options);
      
      var _this = this;
      _this.originalOptions = new Array();
      if(this.options.data!=null){
      	Array.each(_this.options.data,function(e,i){
      		_this.options.data[i].id = i;
      		
      		_this.originalOptions.push({
	      		id:i,
	      		label:e.label,
	      		video:e.video
      		})
      	});
      }
      
      this.submitEl = this.container.getElement(".submit");
      this.submitEl.addEvent(this.clickEvent,this.submit.bind(this));
      
      this.resetEl = this.container.getElement(".reset");
      this.resetEl.addEvent(this.clickEvent,this.reset.bind(this));
      
      this.render();
    },
    // Add any helper methods here
    reset:function(){
	    var _this = this;
	    _this.firstTry = true;
	    _this.firstTryCorrect=false;
	    _this.selectedVid=null;
			_this.currentCorrectVid=null;
			_this.currentSegment=0;
			_this.selectedOrder = new Array();
			_this.currentCorrectVid = _this.originalOptions[_this.currentSegment].id;
			_this.container.getElements(".answers-sections div").removeClass("answered");
			_this.container.getElements(".answers-sections div").removeClass("state-2");
			_this.container.getElements(".answers-sections div").removeClass("state-3");
			_this.container.getElements(".answers-sections div").removeClass("state-4");
			_this.container.getElements(".draggable").removeClass("dropped");
			$$(".answers-sections > div .label").show();
			$$(".answers-sections > div .message").hide();
			$$(".answers-sections > div .message").set("html","");
			$$(".answers-sections > div .message").removeClass("incorrect");
			$$(".answers-sections > div .message").removeClass("correct");
			$$(".answers-sections > div").removeClass("answered");
			//$$(".video-sections button")[0].focus();
			for(var i = 1; i <= this.options.data.length ; i++){
				_this.container.getElement(".answers-sections").removeClass("current-section-"+i);
			}
			
    },

    submit:function(){

    	var _this = this;
    	$$(".answers-sections > div .message").removeClass("incorrect");
			$$(".answers-sections > div .message").removeClass("correct");
    	$$(".answers-sections > div .message").set("html","");
    	//$$(".answers-sections > div .message").setStyle("display","table-cell");
      //$$(".answers-sections > div .label").setStyle("display","none");
    	var allOk = true;



			Array.each(_this.selectedOrder,function(target_index,button_vid){

        if(target_index===null){
          return;
        }

				var target_vid = _this.container.getElements(".answers-sections .answer")[target_index].getProperty("data-vid");

        if(_this.container.getElements(".answers-sections .answer")[target_index].hasClass("checked")){
          return;
        }

        _this.container.getElements(".answers-sections .answer")[target_index].getElement(".label").hide();
        _this.container.getElements(".answers-sections .answer")[target_index].getElement(".message").setStyle("display","table-cell");

        if(target_vid == button_vid){
						_this.container.getElements(".answers-sections .answer")[target_index].getElement(".message").set("html","Correct!");
			    	_this.container.getElements(".answers-sections .answer")[target_index].getElement(".message").addClass("correct");
						
						setTimeout(function(){
              _this.container.getElements(".answers-sections .answer")[target_index].getElement(".message").hide();
              _this.container.getElements(".answers-sections .answer")[target_index].getElement(".label").setStyle("display","table-cell");
              _this.container.getElements(".answers-sections .answer")[target_index].getElement(".label").addClass("correct");
              _this.container.getElement(".video-sections .button-container > button[data-vid='"+button_vid+"']").setStyle("position","static");
              _this.container.getElement(".video-sections .button-container > button[data-vid='"+button_vid+"']").addClass("checked");
              _this.container.getElements(".answers-sections .answer")[target_index].addClass("checked");
              _this.container.getElements(".answers-sections .answer")[target_index].addClass("answered");
							/*console.log(answers[button_vid]);
							
							var prev_to_change = answers[button_vid - 1];
							
							console.log(answers[button_vid]);
							console.log(prev_to_change);

							
							if(prev_to_change!=null && prev_to_change.hasClass("state-4") && !prev_to_change.hasClass("answered")){
								 prev_to_change.addClass("state-4");
							}
							if(prev_to_change!=null && prev_to_change.hasClass("state-3") && prev_to_change.hasClass("answered")){
								 prev_to_change.removeClass("state-3");
								 prev_to_change.addClass("state-2");
							}
							//answers[button_vid].removeClass("answered");
							
							//answers[button_vid].set("related-button",null);
							
							if(answers[button_vid].hasClass("state-3")){
								//answers[button_vid].removeClass("state-3");
								//answers[button_vid].addClass("state-4");
							}*/
							
							
							
						}, 1000);
						
						
							
								
						
						
				}
				else{
					allOk = false;
					_this.container.getElements(".answers-sections .answer")[target_index].getElement(".message").set("html","Incorrect!");
			    _this.container.getElements(".answers-sections .answer")[target_index].getElement(".message").addClass("incorrect");
          _this.container.getElements(".answers-sections .answer")[target_index].getElement(".label").set("html",_this.originalOptions[target_index].label);
          //_this.selectedOrder[target_index]=null;

          var timerid = setTimeout(function(){
            _this.container.getElements(".answers-sections .answer")[target_index].getElement(".message").hide();
            _this.container.getElements(".answers-sections .answer")[target_index].getElement(".label").setStyle("display","table-cell");
            _this.container.getElements(".answers-sections .answer")[target_index].removeClass("answered");
            _this.container.getElements(".answers-sections .answer")[target_index].removeClass("state-3");
            _this.container.getElements(".answers-sections .answer")[target_index].removeClass("state-4");



            if(_this.container.getElements(".answers-sections .answer")[target_index].getPrevious()!=null){
              var prev_element = _this.container.getElements(".answers-sections .answer")[target_index].getPrevious();
              if(!prev_element.hasClass("checked")){
                prev_element.removeClass("state-4");
                prev_element.removeClass("state-3");
              }
              else{
                prev_element.removeClass("state-4");
                prev_element.removeClass("state-3");
                prev_element.addClass("state-2");
              }
            }

            if(_this.container.getElements(".answers-sections .answer")[target_index].getNext()!=null){
              var next_element = _this.container.getElements(".answers-sections .answer")[target_index].getNext();
              if(!next_element.hasClass("checked")){
                _this.container.getElements(".answers-sections .answer")[target_index].removeClass("state-4");
                _this.container.getElements(".answers-sections .answer")[target_index].removeClass("state-3");
              }
              else{
                _this.container.getElements(".answers-sections .answer")[target_index].removeClass("state-2");
                _this.container.getElements(".answers-sections .answer")[target_index].removeClass("state-3");
                _this.container.getElements(".answers-sections .answer")[target_index].addClass("state-4");
              }
            }


          }, 1000);


				}
			});

      _this.selectedOrder = new Array();
   
    },
		clickVideoButton:function(i,e){
			
			$$(".video-wrapper .video").hide();
			$$(i.getProperty("data-video")).show();
			$$(".button-wrapper").removeClass("current");
			i.getParent(".button-wrapper").addClass("current");
			
		},
		finishQuiz:function(){
			$$(".answers-sections > div").addClass("answered");
	    $$(".answers-sections > div .message").set("html","");
			$$(".answers-sections > div .message").removeClass("incorrect");
			$$(".answers-sections > div .message").removeClass("correct");
			$$(".answers-sections > div .label").show();
			$$(".answers-sections > div .message").hide();
			
			_this.container.getElement(".answers-sections").addClass("current-section-"+(this.options.data.length-1));
    },
    // render - updates the widget display
    render: function() {
    	this.parent();
    	
    	var _this = this;
      
      if(this.options.data!=null){
      	
		  Array.each(_this.options.data,function(e,i){
      		_this.options.data[i].id = i;
      	});
				
        if(_this.options.order==null || _this.options.order.length==0){
            _this.options.data = _this.options.data.sort(function(){
                return 0.5 - Math.random();
            });
        }
        else{
            var datasorted = new Array();
            Array.each(_this.options.order,function(e,i){
                datasorted.push(_this.options.data[e]);
            });

            _this.options.data = datasorted;
        }

        var container_buttons = this.container.getElement(".video-sections");
      	container_buttons.empty();
      	var c = 0;
	      Array.each(_this.options.data,function(e,i){
	      	
	      	var w = new Element("div.button-wrapper.button-"+c);
	      	w.inject(container_buttons);
	      	
	      	var arrow_left = new Element("div.arrow-left");
		      arrow_left.inject(w);
		      
		      var button_wrapper = new Element("div.button-container");
		      button_wrapper.inject(w);
	      	
		      var button = new Element("button.draggable");
		      button.set("html","Segment  #" + (i+1) );
		      button.set("data-vid",e.id);
		      button.set("data-video",e.video);
		      button.set("tabindex",0);
		      button.inject(button_wrapper);
		      
		      
		      
		      var arrow_right = new Element("div.arrow-right");
		      arrow_right.inject(w);
		      
		      button.addEvent("click",function(e){
			      _this.clickVideoButton(this,e);
		      });
		      
		      c++;
		      
	      });
	      
	      
	      
	      var container_labels = this.container.getElement(".answers-sections");
	      Array.each(_this.originalOptions,function(e,i){
		      var button = new Element("div.answer.droppable");
		      button.set("html","<div class='label'>"+e.label+"</div><div class='note message'></div>" );
		      button.set("data-vid",e.id);
		      button.set("tabindex",0);
		      button.inject(container_labels);
	      });
	      
	      _this.currentCorrectVid = _this.originalOptions[_this.currentSegment].id;
	      $$(".video-sections button")[0].fireEvent("click");
	      //$$(".video-sections button")[0].focus();
	      
	      _this.container.getElement(".answers-sections").addClass("current-section-"+_this.currentSegment);
	      
	      $$(".draggable").forEach(function (el) {
      		el.setAttribute('data-position',el.getPosition($$('.button-container')[0]).x +  " " + el.getPosition($$('.button-container')[0]).y );
	      });
	      
	      $$(".draggable").makeDraggable({
		    	droppables: _this.container.getElements('.droppable'),

		    	onDrag:function(draggable){
			    	draggable.addClass("draggin");
		    	},
	        onDrop: function(draggable, droppable) {

            if(draggable.hasClass("checked")){
              return;
            }
	          var pos = { x:draggable.dataset.position.split(" ")[0], y:draggable.dataset.position.split(" ")[1] }; 
	          if (droppable) {
	            draggable.removeClass("draggin");
	            draggable.addClass("dropped");
	            
	            var d = draggable.getParent(".button-wrapper");
	            var dragindex = _this.container.getElements(".video-sections .button-wrapper").indexOf(d);
	            droppable.set("related-button",dragindex);
	            
	            
	            var currentvid = draggable.getProperty("data-vid");
	            draggable.setStyles({
		            //position:"static",
		            left:"auto",
		            top:"auto"
	            });
	            
	            if(_this.selectedOrder[currentvid]!=null){
	            	var prev_to_change = _this.container.getElements(".answers-sections > div")[_this.selectedOrder[currentvid]].getPrevious();
	            	if(prev_to_change!=null && prev_to_change.hasClass("state-4") && !prev_to_change.hasClass("answered")){
		            	prev_to_change.removeClass("state-4");
	            	}
	            	if(prev_to_change!=null && prev_to_change.hasClass("state-3") && prev_to_change.hasClass("answered")){
		            	prev_to_change.removeClass("state-3");
		            	prev_to_change.addClass("state-2");
	            	}
		            _this.container.getElements(".answers-sections > div")[_this.selectedOrder[currentvid]].removeClass("answered");
		            
		            _this.container.getElements(".answers-sections > div")[_this.selectedOrder[currentvid]].set("related-button",null);
		            
		            if(_this.container.getElements(".answers-sections > div")[_this.selectedOrder[currentvid]].hasClass("state-3")){
			            _this.container.getElements(".answers-sections > div")[_this.selectedOrder[currentvid]].removeClass("state-3");
			            _this.container.getElements(".answers-sections > div")[_this.selectedOrder[currentvid]].addClass("state-4");
		            }
		            
		            _this.container.getElements(".answers-sections > div")[_this.selectedOrder[currentvid]].getElement(".label").set("html",_this.originalOptions[_this.selectedOrder[currentvid]].label);
		            	
	            }
	            
	            var target_index = _this.container.getElements(".answers-sections > div").indexOf(droppable);;
	            _this.selectedOrder[currentvid] = target_index;
	            _this.container.getElements(".answers-sections > div")[target_index].getElement(".label").set("html",_this.originalOptions[target_index].label + "<br/><span class='original-segment'>"+draggable.get("text")+"</span>  ");
	            
	            droppable.addClass("answered");
	            
	            if(droppable.hasClass("state-4")){
	            	droppable.removeClass("state-4");
		            droppable.addClass("state-3");
	            }
	            
	            var prev = droppable.getPrevious();
	            if(prev!=null && prev.hasClass("answered")){
		            prev.addClass("state-3");
	            }
	            
	            if(prev!=null && !prev.hasClass("answered")){
		            prev.addClass("state-4");
	            }
	            
	            
	          } else {
					draggable.morph({
				        top: 0,
				        left: 20
				    });
			  }
	        }

	    	});
	    	
	    	
      }
      
      
    }
});