/**
 * Created by germanmontes on 30/09/14.
 */
var ua = window.navigator.userAgent;
var iOS = !!ua.match(/iPhone/i);
var webkit = !!ua.match(/WebKit/i);
var iOSSafari = iOS && webkit && !ua.match(/CriOS/i);
var Android = !!ua.match(/Android/i);

var TextMap =  new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    options: {
        container: null,
        data: [],
        texts: {}
    },
    xmlType: '',
    timeEntries:[],
    two_columns_mode: false,
    media:null,
    showCaptionMode: "click",

    initialize: function(options) {
        var that = this
        document.widgetType = 'textMap'

        this.options.extra = [
            'data-layout',
            'data-assessment'
        ];

        this.parent(options);

        if (options.container.get("data-caption-showon-mode") != null && options.container.get("data-caption-showon-mode") != ""){
            this.showCaptionMode = options.container.get("data-caption-showon-mode");
        }

        if (this.container.get("data-layout") == "horizontal"){
            this.layout_horizontal_mod = true;
        } else {
            this.layout_horizontal_mod = false;
        }

        if (this.container.get("data-assessment") == null || this.container.get("data-assessment") == "false"){
            this.container.addClass("no-quiz-mode");
        }

        if (this.container.get("data-xml-type") != "default"){
            this.container.addClass("two-column-mode");
            this.two_columns_mode = true;
        }

        if (parent != window){
            parent.postMessage({method:"widget-ready", edit_mode:this.isEditMode},"*");
        }

        $$('body')[0].grab(new Element('#instructions-tooltip.visually-hidden', {
            text: "Select an option from the list, and submit your answer."
        }))

        this.updateContainerHeight();
        
        if ($('intro-line')) {
            $('intro-line').addEvent('input', function (e) {
                that.updateContainerHeight();            
            })    
        }

        this.options.hasNotDefaultText = options.hasNotDefaultText;

        if (!this.options.hasNotDefaultText) {
            // set default texts for legacy widget
            this.options.texts = {
                presentationInstruction: 'Click each type of supporting material to learn more about it, then click “Check Your Understanding” to review.',
                challengeInstruction: 'Drag the circle to connect the text below to the principle that it describes.'
            };
        }

        if (window.options && window.options.texts) {
            if (window.options.texts.presentationInstruction) {
                this.options.texts.presentationInstruction = window.options.texts.presentationInstruction;
            }
            if (window.options.texts.challengeInstruction) {
                this.options.texts.challengeInstruction = window.options.texts.challengeInstruction;
            }
        }

        this.enableInstructionText();
        this.shouldHidePresentationInstruction();
    },

    enableInstructionText: function () {
        var self = this;

        // clear boilerplate texts
        document.querySelector('.header-no-quiz-mode').set('html', '');
        document.querySelector('.header-quiz-mode').set('html', '');

        if (this.isEditMode) {
            var presentationInputsHtml = '<div ' +
                    'id="presentation-instruction-text" ' + 
                    'data-placeholder="Edit Presentation Mode Instruction Text" ' + 
                    'placeholder="Edit Presentation Mode Instruction Text" ' + 
                    'data-md-editable="md-content-editable"' + 
                    'contenteditable="true"' + 
                    'spellcheck="false"' + 
                '><div></div></div>' + 
                '<div ' + 
                    'id="challenge-instruction-text" ' + 
                    'data-placeholder="Edit Challenge Mode Instruction Text" ' + 
                    'placeholder="Edit Challenge Mode Instruction Text" ' + 
                    'data-md-editable="md-content-editable"' + 
                    'contenteditable="true"' + 
                    'spellcheck="false"' + 
                '><div></div></div>'
                
            document.querySelector('.widget-header').insertAdjacentHTML('beforeend', presentationInputsHtml)

            var presentationTextEl = document.querySelector('#presentation-instruction-text');
            var challengeTextEl = document.querySelector('#challenge-instruction-text');
            var introLineEL = document.querySelector('#intro-line');

            if (introLineEL) {
                introLineEL
                    // .set('data-placeholder', 'Edit Introductory Line Text')
                    // .set('placeholder', 'Edit Introductory Line Text')
                    .set('contenteditable', 'true')
                    .set('spellcheck', 'false')
                    .set('data-md-editable', 'md-content-editable');
            }
            
            if (
                this.container.get('data-assessment') == null || 
                this.container.get('data-assessment') == 'false'
            ) {
                $$(challengeTextEl).hide()
            }

            loadScript('../_framework/_base_external/tinymce_4.4.3/tinymce.min.js', this.initTinyMCE.bind(this));

            // fill inputs
            presentationTextEl.querySelector('div').set('html', this.options.texts.presentationInstruction);
            challengeTextEl.querySelector('div').set('html', this.options.texts.challengeInstruction);

            // save texts on input
            presentationTextEl.addEvent('input', debounce(updateOptionsTexts, 250));
            challengeTextEl.addEvent('input', debounce(updateOptionsTexts, 250));
        } else {
            // fill texts
            document.querySelector('.header-no-quiz-mode').set('html', this.options.texts.presentationInstruction);
            document.querySelector('.header-quiz-mode').set('html', this.options.texts.challengeInstruction);
        }

        function updateOptionsTexts (e) {
            if (e.target.id === 'presentation-instruction-text') {
                self.options.texts.presentationInstruction = e.target.querySelector('div').get('html');
            } else if (e.target.id === 'challenge-instruction-text') {
                self.options.texts.challengeInstruction = e.target.querySelector('div').get('html');
            }

            self.saveOptions();
        }

        // source: https://gist.github.com/nmsdvid/8807205#file-new_gist_file-js-L6
        function debounce (func, wait, immediate) {
            var timeout;

            return function() {
                var context = this, args = arguments;
                clearTimeout(timeout);
                timeout = setTimeout(function() {
                    timeout = null;
                    if (!immediate) func.apply(context, args);
                }, wait);
                if (immediate && !timeout) func.apply(context, args);
            };
        }
        
        function loadScript (src, callback) {
            var script = document.createElement('script');
            var hasLoaded;

            script.src = src;
            script.onreadystatechange = script.onload = function () {
                if (!hasLoaded) callback();
                hasLoaded = true;
            }

            document.getElementsByTagName('head')[0].appendChild(script);
        }
    },

    initTinyMCE: function () {
        tinymce.remove();
        tinymce.init({
            selector: "[contenteditable='true'], [data-md-editable='md-content-editable']",
            inline: true,
            plugins: "charmap bdesk_photo codeTag codesample stixFormat placeholder advlist positionfix",
            toolbar: 'undo redo | bold italic superscript subscript codeTag stixFormat bullist numlist | charmap codesample indent outdent | alignleft aligncenter alignright',
            menubar: false,
            forced_root_block: 'div',
            formats: {
                StixFormat: {
                    inline: 'ins',
                    classes: 'stix-format'
                }
            },
            setup: function (editor) {
                editor.on('change', function (e) {
                    var target = this.getElement();
                    $(target).fireEvent('input', [{target: target}, target]);
                });
            }
        });
    },

    saveOptions: function () {
        var request = {
            method: 'mdDataByID',
            selector: '#md-widget-data-options',
            variable_name: 'options',
            path: '',
            options: {
                json: this.options
            }
        };

        // write options in html file
        this.saveRequest(request);
    },

    shouldHidePresentationInstruction: function () {
        // support for legacy widgets
        // when introductory line is enabled
        // presentation instruction is hidden
        if (
            this.container.getElement('#intro-line') &&
            !this.hasNotDefaultText &&
            this.options.texts.presentationInstruction === 'Click each type of supporting material to learn more about it, then click “Check Your Understanding” to review.'
        ) {
            this.container.getElement(".widget-header .header-no-quiz-mode").hide();
        }
    },

    updateContainerHeight: function(){
        console.log('Update Height!')
        $$('.widget-body')[0].setStyle('height', 'calc( 100vh - '+( $$('.widget-header')[0].getHeight() + $$('.widget-footer')[0].getHeight())+'px)');
    },

    customPostMessages:function(message,path) {
        var _this = this;

        switch(message.data.method){
            case "retrieve-image-accessibility-list":
                break;

            case "data-change":
                _this.options.data = message.data.data;
                _this.render();
                break;
            case "toggleHTML":
            case "show-media-popup":
            case "view-mode-switch":
                break;
        }

    },

    render: function() {
        var _this = this;

        if (_this.options.data != null){
            var initial_entries_wrapper = null;

            if(_this.container.getElement(".entries-wrapper")==null){
                initial_entries_wrapper = new Element("div.entries-wrapper");
                _this.container.getElement(".initial").adopt(initial_entries_wrapper);
            } else {
                initial_entries_wrapper = _this.container.getElement(".entries-wrapper");
            }

            initial_entries_wrapper.getElements(".entry-element").dispose();
            _this.container.getElement(".options-entrys").getElements(".entry-element").dispose();

            _this.options.data.each(function(entry){
                var entry_element = new Element("div.entry-element",{
                    html:entry.Term
                });

                initial_entries_wrapper.adopt(entry_element.clone());

                var entry_element_quiz = new Element("div.entry-element",{
                    html:"<div>"+entry.Term+"</div>"
                });

                _this.container.getElement(".options-entrys").adopt(entry_element_quiz);
            });

            //caption wrapper
            if (_this.container.getElement(".caption-wrapper")==null){
                var caption_wrapper = new Element("div.caption-wrapper.non-active");
                var caption_wrapper_triangle = new Element("div.caption-wrapper-triangle");
                var caption_wrapper_content = new Element("div.caption-wrapper-content");

                caption_wrapper.adopt(caption_wrapper_triangle);
                caption_wrapper.adopt(caption_wrapper_content);

                _this.container.getElement(".initial").adopt(caption_wrapper);
            }

            _this.container.getElement('.feedback').set('id','footer-feedback');

            if(this.container.getElement('#intro-line')){
                this.container.getElement('#intro-line').show();
            }

            this.container.getElement(".widget-header .header-no-quiz-mode").show();

            _this.bindEventsEntries();
            _this.bindEventsQuizModeEntries();
            _this.bindEventsButtons();
            _this.bindHideInformativeLines();
        }

        setTimeout(function(){
            _this.updateContainerHeight();
        }, 500)
    },

    bindHideInformativeLines: function(){
        if($('intro-line')){
          $('intro-line').set('tabindex', 0);
        }

        $$('.header-quiz-mode').set('tabindex', 0);
        this.container.getElement(".widget-header .header-challenge-result").set('tabindex', 0);
    },

    bindEventsButtons:function(){
        this.container.getElement(".start").addEvent("click", this.startQuizMode.bind(this));
        this.container.getElement(".exit").addEvent("click", this.showInformativeMode.bind(this));
        this.container.getElement(".repeat").addEvent("click", this.startQuizMode.bind(this));
    },

    showInformativeMode: function(e){
        var _this = this;

        if(this.container.getElement('#intro-line')){
            this.container.getElement('#intro-line').show();
        }

        this.container.getElement(".widget-header .header-no-quiz-mode").show();

        this.shouldHidePresentationInstruction();

        if(_this.timer!=null) clearInterval(_this.timer);

        _this.container.getElement(".start").removeClass("hidden");
        _this.container.getElement(".exit").addClass("hidden");
        _this.container.getElement(".repeat").addClass("hidden");
        _this.container.getElements(".widget-header > strong").hide();
        _this.container.getElement(".widget-header .header-no-quiz-mode").show();
        _this.bindHideInformativeLines();

        _this.container.getElement(".widget-footer .feedback").set("html","");
        _this.container.getElement(".initial").show();
        _this.container.getElement(".quiz-mode").hide();

        this.updateContainerHeight();
    },

    convertToHTML: function(content) {
        var pattern, re;
        //replace html to safe text for input
        pattern = '&quot;';
        re = new RegExp(pattern, "g");
        content = content.replace(re, '"');

        pattern = '&amp;';
        re = new RegExp(pattern, "g");
        content = content.replace(re, '&');

        pattern = "&#039;";
        re = new RegExp(pattern, "g");
        content = content.replace(re, "'");

        pattern = '&lt;';
        re = new RegExp(pattern, "g");
        content = content.replace(re, '<');

        pattern = '&gt;';
        re = new RegExp(pattern, "g");
        content = content.replace(re, '>');

        return content;
    },

    startQuizMode:function(e){

        var _this = this;

        if($('intro-line')){            
            $('intro-line').hide();
        }

        this.container.getElement(".widget-header .header-no-quiz-mode").hide();

        //set base elements
        if(_this.container.getElement(".quiz-mode .options-description .description-wrapper")==null){
            var description_wrapper = new Element("div.description-wrapper",{
                'aria-describedby': "draggable-instructions"
            });
            description_wrapper.addEvent('keypress', function(e){
                var wasEnterPressed = e.code == 13 || e.which == 13 || e.keyCode == 13;
                var wasSpacePressed = e.code == 32 || e.which == 32 || e.keyCode == 32;
                if (wasEnterPressed || wasSpacePressed) {
                    _this.container.getElement('.quiz-mode .entry-element').focus();
                }
            })

            _this.container.getElement(".quiz-mode .options-description").adopt(description_wrapper);
        }

        _this.container.getElement(".options-entrys").show();
        _this.container.getElements(".widget-header > strong").hide();
        _this.container.getElement(".widget-header .header-quiz-mode").show();
        _this.bindHideInformativeLines();

        var initial_size = _this.container.getElement(".initial").getSize();

        if(_this.container.getElement(".quiz-mode canvas")==null){

            _this.container.getElement(".quiz-mode").setStyles({
                width: initial_size.x,
                height: initial_size.y
            });


            setTimeout(function(){
                try{
                    document.dispatchEvent(document.resizeWidget)
                }
                catch(e){
                    console.log('no iphone')
                }

            },0)


            var canvas_wrapper = new Element("canvas.canvas-wrapper");

            canvas_wrapper.setProperties({ //setStyles({
                width: initial_size.x,
                height: initial_size.y
            });

            _this.container.getElement(".quiz-mode").adopt(canvas_wrapper);
            _this.canvas = _this.container.getElement('canvas');
            _this.ctx = _this.canvas.getContext('2d');
            _this.canvas_width = 0;
        }

        _this.correct_on_first_attemp = 0;

        _this.container.getElement(".description-wrapper").set('tabindex', 0);
        //_this.container.getElement(".description-wrapper").set('role', 0);

        if(this.container.getElement(".draggable.grab"))
            this.container.getElement(".draggable.grab").dispose();

        var draggable_element = new Element("div.draggable.grab", {
            // tabindex: 0,
            'aria-labelledby' : 'footer-feedback'
        });

        if(!_this.container.getElement(".options-entrys .drag-result")){
            new Element('div.drag-result[tabindex="-1"]',{
              'aria-live':'assertive'
            }).inject(_this.container.getElement(".options-entrys"),'top');
        }

        _this.draggable = draggable_element;
        //_this.container.getElement(".quiz-mode").adopt(draggable_element);
        draggable_element.inject(_this.container.getElement(".options-description"), 'after');

        _this.makeElementDraggable();

        if(_this.timer!=null) clearInterval(_this.timer);

        _this.timer = setInterval(function() {
            _this.renderLine();
        }, 20);
        _this.renderLine();

        _this.avaible_entries_quiz_mode = _this.options.data.clone();

        _this.avaible_entries_quiz_mode.each(function(entry,ind){
            _this.avaible_entries_quiz_mode[ind].id = ind;
        });

        //set initial description
        _this.nextEntryChallange(Number.floor(Math.random()*_this.avaible_entries_quiz_mode.length), false);

        _this.container.getElement(".start").addClass("hidden");
        _this.container.getElement(".exit").removeClass("hidden");
        _this.container.getElement(".repeat").addClass("hidden");

        _this.container.getElement(".initial").hide();
        _this.container.getElement(".quiz-mode").removeClass("quiz-end");
        _this.container.getElement(".quiz-mode").show();

        this.setDraggablePosition();
        _this.renderLine();

        function hideAssessableMenu(descriptionWrapper){

                var children = descriptionWrapper.getParent().getChildren('button,select')
                children.addClass('visually-hidden')
                children.set('tabindex', -1)
                $$('.description-wrapper').floatingTipsHide()
        }

        if(!$$('.assessable-controls').length){
            function SetHideAssessableMenu(e){
                var wrapper;
                wrapper = $(e.target)
                if(e.target.tagName == 'P') wrapper = $(e.target.parentNode)
                hideAssessableMenu(wrapper)
            }
            $$('.description-wrapper').addEvent('click', SetHideAssessableMenu)
            $$('.description-wrapper').addEvent('contextmenu', SetHideAssessableMenu)

            $$('*').addEvent('focusin',function(e){
                e.stopPropagation()

                var wasByKeyboard = window.lastClick < window.lastKey;
                if (!wasByKeyboard) {
                    $$('.description-wrapper').floatingTipsHide();
                    return;
                }

                var target = $(e.target)
                var parent = target.getParent()
                if(parent.hasClass('options-description')){

                    if (!target.hasClass('description-wrapper')) {
                        if (document.previousFocused == 'not-allowed') {
                            return
                        } else {
                            if (target.tagName == 'button') document.previousFocused = 'button'
                            if (target.tagName == 'select') document.previousFocused = 'select'
                        }

                    } else {
                        document.previousFocused = 'description'
                        parent.getChildren().set('tabindex', 0)
                    }
                    parent.getChildren().removeClass('visually-hidden')
                }else{

                    $$('.description-wrapper')[0].getSiblings('button, select').set('tabindex',-1)
                    $$('.description-wrapper')[0].getSiblings('button, select').addClass('visually-hidden')
                    document.previousFocused = 'not-allowed'
                }

            })
            $$('*').addEvent('focusout',function(e){
                e.stopPropagation()
                var target = $(e.target)
                var parent = target.getParent()
                if(parent.hasClass('options-description')){

                    setTimeout(function(){

                        if(document.activeElement.tagName != 'SELECT' &&
                          document.activeElement.tagName != 'BUTTON' &&
                          document.activeElement.tagName != 'DIV'){
                            $$('.description-wrapper')[0].getSiblings('button, select').set('tabindex',-1)
                            $$('.description-wrapper')[0].getSiblings('button, select').addClass('visually-hidden')
                        }
                    },0)

                    if(target.hasClass('description-wrapper')){
                        if(document.previousFocused != 'button') return
                    }
                    else if(target.tagName =='button'){
                        if(document.previousFocused != 'description' && document.previousFocused != 'select')
                            return
                    }
                    else if(target.tagName == 'select') {
                        if(document.previousFocused != 'button') return
                    }

                    //
                }

            })
            //NEW
            var descriptionWrapper = $$('.description-wrapper')[0];


            var menuOptions = _this.avaible_entries_quiz_mode.map(function(entry,index){
                var description =  entry.Term.replace(/<[^>]+>/g, "")
                return '<option data-id="' + entry.id + '">'+ description + '</option>';
            })


            var menu = new Element('select.visually-hidden.assessable-controls', {
                'aria-label':  'Make a selection to associate this theory with the theorist',
                html: menuOptions,
                'tabindex': -1
            })
            var menuSubmitButton = new Element('button.assessable-controls.visually-hidden', {
                'aria-label':  'Submit answer',
                html: "Submit answer",
                'tabindex': -1
            })

            descriptionWrapper
              .getParent()
              .adopt(menu)
              .adopt(menuSubmitButton)

            menu.set('selected-index', 0)
            menuSubmitButton.addEventListener('click', function(){
                // $$('.entry-element')
                var entry = $$('.entry-element div').filter(function(entry){
                    return menu.value == entry.textContent
                })[0].getParent()

                if (_this.checkAnswer(entry)) {

                    _this.avaible_entries_quiz_mode.erase(_this.quiz_mode_current_item_object);

                    if(_this.first_try)
                        _this.correct_on_first_attemp++;

                    entry.addClass("correct");

                    _this.container.getElement(".options-entrys .drag-result").set('text', 'Correct');
                    _this.container.getElement(".options-entrys .drag-result").set('aria-label', 'Correct');
                    _this.container.getElement(".options-entrys .drag-result").focus();
                    setTimeout(function() {
                        entry.removeClass("correct");
                        _this.container.getElement(".options-entrys .drag-result").set('text', '');
                        _this.nextEntryChallange(Number.floor(Math.random()*_this.avaible_entries_quiz_mode.length),true);
                    }, 1200);



                    correct = true;
                } else {
                    _this.first_try = false;
                    entry.addClass("incorrect");
                    _this.container.getElement(".options-entrys .drag-result").set('text', 'Incorrect');
                    _this.container.getElement(".options-entrys .drag-result").set('aria-label', 'Incorrect');
                    // _this.container.getElement(".options-entrys .drag-result").focus();
                    setTimeout(function() {
                        entry.removeClass("incorrect");
                        _this.container.getElement(".options-entrys .drag-result").set('text', '');
                        $$('.description-wrapper')[0].focus()
                    }, 1200);

                }


            })
        }




        //_this.container.getElement('div.draggable.grab').focus();

        // setTimeout(function(){
        //     _this.container.getElement('.header-quiz-mode').focus();
        // }, 750);

        var x = e.event.x || e.event.pageX || e.page.x
        var y = e.event.y || e.event.pageY || e.page.y


        if (!(x && y)) $$('.description-wrapper')[0].focus()
        $$('.description-wrapper').floatingTips({
            position: 'bottom',
            showOn: 'focus',
            hideOn: 'focusout',
            content: function() { return $('instructions-tooltip'); },
            html: true,
        })

        this.updateContainerHeight();

    },

    getInitialPositionDraggable: function(){
        var _this = this;

        var content_wrapper_description = _this.container.getElement(".quiz-mode .quiz-mode-content-wrapper .options-description .description-wrapper");
        var content_wrapper_description_position = content_wrapper_description.getPosition();
        var content_wrapper_description_dimension = content_wrapper_description.getSize();

        var x_pos = _this.canvas_width = (content_wrapper_description_position.x + content_wrapper_description_dimension.x + 10);
        var y_pos = ((content_wrapper_description_dimension.y - 30 )/2);

        return {
            x: x_pos,
            y: y_pos
        }
    },

    setDraggablePosition: function() {
        var original_pos = this.getInitialPositionDraggable();

        this.draggable.setStyle('left', original_pos.x + 'px');
        this.draggable.setStyle('top', original_pos.y + 'px');
    },

    makeElementDraggable: function(){
        var _this = this;

        this.setDraggablePosition();

        // this.draggable.addEvent("keypress", function (e) {
        //     if (e.key == 'enter' || e.key == 'space') {
        //         _this.container.getElement('.quiz-mode .entry-element').focus();
        //     }
        // });

        this.draggable.makeDraggable({
            droppables: $$('.quiz-mode .options-entrys .entry-element'),
            onSnap: function(el) {
                /*
                if ($$('.droppable.selected')[0])
                    $$('.droppable.selected')[0].removeClass('selected');
                if ($$('.message.correct')[0])
                    $$('.message.correct')[0].removeClass('correct').setStyle('opacity', 0);
                if ($$('.message.incorrect')[0])
                    $$('.message.incorrect')[0].removeClass('incorrect').setStyle('opacity', 0);
                */
            },
            onEnter: function(draggable, droppable) {

            },
            onLeave: function(draggable, droppable) {

            },
            onDrop: function(draggable, droppable) {

                var correct = false;
                var original_pos = _this.getInitialPositionDraggable();

                if (droppable) {


                    var draggable_element = new Element("div.draggable.grab", {
                        tabindex: 0
                    });

                    if (_this.checkAnswer(droppable)) {

                        _this.avaible_entries_quiz_mode.erase(_this.quiz_mode_current_item_object);

                        if(_this.first_try)
                            _this.correct_on_first_attemp++;

                        droppable.addClass("correct");
                        _this.container.getElement(".options-entrys .drag-result").set('text', 'Correct');
                        _this.container.getElement(".options-entrys .drag-result").set('aria-label', 'Correct');
                        // _this.container.getElement(".options-entrys .drag-result").focus();
                        setTimeout(function() {
                            droppable.removeClass("correct");
                            _this.nextEntryChallange(Number.floor(Math.random()*_this.avaible_entries_quiz_mode.length), false);
                        }, 1800);

                        correct = true;
                    } else {
                        _this.first_try = false;
                        droppable.addClass("incorrect");

                        _this.container.getElement(".options-entrys .drag-result").set('text', 'Incorrect');
                        _this.container.getElement(".options-entrys .drag-result").set('aria-label', 'Incorrect');
                        // _this.container.getElement(".options-entrys .drag-result").focus();
                        setTimeout(function() {
                            droppable.removeClass("incorrect");
                            _this.container.getElement(".options-entrys .drag-result").set('text', '');
                        }, 2000);
                    }

                    draggable.morph({
                        left: original_pos.x + 'px',
                        top: original_pos.y + 'px'
                    });
                }
                if (!correct) {
                    draggable.morph({
                        left: original_pos.x + 'px',
                        top: original_pos.y + 'px'
                    });
                }
            },
            onComplete: function(el) {
                //$$('.column-left .item.no-description').removeClass('no-description');
            }
        });
    },

    checkAnswer: function(selected_item) {
        var selected_item_index = this.container.getElements(".quiz-mode .options-entrys .entry-element").indexOf(selected_item);

        if(this.quiz_mode_current_id == selected_item_index){
            return true;
        }
        else {
            return false;
        }

    },

    renderLine: function() {
        var wrapper_size = this.container.getElement(".quiz-mode").getSize();
        var original_pos = this.getInitialPositionDraggable();
        var draggable_position = this.draggable.getPosition();
        var draggable_size = this.draggable.getSize();
        var wrapper_quiz_mode_position = this.container.getElement(".quiz-mode").getPosition();

        var move_to_position = {
            x: (original_pos.x - draggable_size.x - 12),
            y: original_pos.y + draggable_size.y/2
        }

        var line_to_position = {
            x: draggable_position.x + 25 - draggable_size.x - 2,
            y: draggable_position.y - wrapper_quiz_mode_position.y  + draggable_size.y/2
        }


        if(window._current_scale !== null && typeof window._current_scale !== 'undefined' && window._current_scale < 1 && !is_iPad){

            line_to_position.x = (draggable_position.x - draggable_size.x + 30)/window._current_scale ;
            line_to_position.y = (draggable_position.y - wrapper_quiz_mode_position.y)/window._current_scale  + draggable_size.y/2 ;


            if(iOSSafari || Android){ //CHECK in Android
                line_to_position.x = draggable_position.x - draggable_size.x +30
                line_to_position.y = draggable_position.y - wrapper_quiz_mode_position.y + draggable_size.y/2
            }

        }

        this.ctx.clearRect(0, 0, wrapper_size.x, wrapper_size.y);
        this.ctx.beginPath();
        this.ctx.setLineDash([3, 2]);
        this.ctx.moveTo(move_to_position.x, move_to_position.y);
        this.ctx.lineTo(line_to_position.x, line_to_position.y);
        this.ctx.strokeStyle = '#C3C3C3';
        this.ctx.lineWidth = 2;
        this.ctx.stroke();
    },

    nextEntryChallange: function(index, shouldFocus){
        var _this = this;

        _this.first_try = true;

        if (_this.avaible_entries_quiz_mode.length == 0){
            _this.endQuizMode();
            return;
        }

        _this.container.getElement(".widget-footer .feedback").set("html","Question "+(_this.options.data.length - _this.avaible_entries_quiz_mode.length + 1)+" of "+ _this.options.data.length);
        _this.container.getElement(".widget-footer .feedback").set('aria-label', _this.container.getElement(".widget-footer .feedback").get('text'));
        var current_entry = _this.avaible_entries_quiz_mode[index];

        _this.container.getElement(".quiz-mode .options-description .description-wrapper").set("html", _this.convertToHTML(current_entry.Description));
        // _this.container.getElement('div.draggable.grab').setAttribute('aria-label', current_entry.Description);
        if(typeof shouldFocus === 'undefined' || shouldFocus){
            _this.container.getElement('.description-wrapper').focus();
        }
        _this.quiz_mode_current_id = current_entry.id;
        _this.quiz_mode_current_item_object = current_entry;

        _this.setDraggablePosition();
    },

    endQuizMode: function(){
        var _this = this;
        _this.container.getElement(".options-entrys").hide();
        _this.container.getElement(".quiz-mode").addClass("quiz-end");
        _this.container.getElement(".repeat").removeClass("hidden");
        _this.container.getElement(".widget-header .header-challenge-result").set("html","Good job! You completed the challenge. You got "+_this.correct_on_first_attemp+" out of "+_this.options.data.length+" correct on the first try.");
        _this.container.getElements(".widget-header > strong").hide();
        _this.container.getElement(".widget-header .header-challenge-result").show();
        _this.container.getElement(".widget-header .header-challenge-result").focus();
        _this.updateContainerHeight();
    },

    // bindEventsEntries:function(){
    //     var _this = this;

    //     _this.container.getElements(".initial .entry-element").addEvent("mouseover",_this.entryElementOverEvent.bind(_this));
    //     _this.container.getElements(".caption-wrapper").addEvent("mouseover",function(e) { e.stopPropagation() });
    //     _this.container.addEvent("mouseover",_this.entryElementOutEvent.bind(_this));
    // },

    bindEventsEntries:function(){
        var _this = this;

        switch(_this.showCaptionMode){
            case "click":
                //
                _this.container.getElements(".initial .entry-element").addEvent("click",_this.entryElementOverEvent.bind(_this));
                _this.container.getElements(".caption-wrapper").addEvent("click",function(e) { e.stopPropagation() });
                break;
            case "hover":
            default:
                //
                _this.container.getElements(".initial .entry-element").addEvent("mouseover",_this.entryElementOverEvent.bind(_this));
                _this.container.getElements(".caption-wrapper").addEvent("mouseover",function(e) { e.stopPropagation() });
                _this.container.addEvent("mouseover",_this.entryElementOutEvent.bind(_this));
                break;
        }
        _this.container.getElements(".initial .entry-element").each(function (entry){
            entry.setAttribute('role', 'button');
            entry.setAttribute('tabindex', 0);
            entry.setAttribute('aria-describedby', 'entry-instructions');
        });

        // _this.container.adopt(new Element('#entry-instructions.visually-hidden',{
        //     text: "Press enter to expand definition."
        // }))
        _this.container.adopt(new Element('#entry-instructions.visually-hidden',{
            text: "Press enter to expand definition."
        }))
        _this.container.adopt(new Element('#draggable-instructions.visually-hidden',{
            text: "Press tab to select an option from the list and submit your answer."
        }))
        _this.container.adopt(new Element('#principle-instructions.visually-hidden',{
            text: "Press Enter to match with this principle. "
        }))

        _this.container.getElements(".initial .entry-element").addEvent("keypress", function (e){

            if(e.key == "enter" || e.key == "space"){
                e.target.click();
            }
        });
    },

    entryElementOverEvent: function(e){
        e.stopPropagation();

        var _this = this;
        var current_entry = e.target;
        var current_entry_index = _this.container.getElements(".initial .entry-element").indexOf(current_entry);

        if(_this.options.data[current_entry_index].Description){
            var current_entry_position = current_entry.getPosition();
            var container_position = _this.container.getElement(".initial").getPosition();
            var container_dimension = _this.container.getElement(".initial").getSize();

            _this.container.getElement(".caption-wrapper .caption-wrapper-content").set("html", _this.convertToHTML(_this.options.data[current_entry_index].Description));

            var caption_clone = _this.container.getElement(".caption-wrapper").clone();
            caption_clone.getElement(".caption-wrapper-triangle").setStyle("margin-top",0);
            caption_clone.addClass("measure");
            _this.container.getElement(".initial").adopt(caption_clone);
            var caption_clone_dimension = caption_clone.getSize();
            var caption_clone_content_wrapper_dimension  = caption_clone.getElement(".caption-wrapper-content").getSize();
            caption_clone.dispose();

            _this.container.getElement(".caption-wrapper").removeClass("non-active");

            var top_diff = (current_entry_position.y - container_position.y);

            if(window._current_scale !== null && typeof window._current_scale !== 'undefined' && window._current_scale < 1 && !iOSSafari){
                top_diff /= window._current_scale;
            }

            if (caption_clone_dimension.y + top_diff < container_dimension.y ) {
                _this.container.getElement(".caption-wrapper .caption-wrapper-triangle").removeAttribute("style");
                _this.container.getElement(".caption-wrapper").setStyle("margin-top",top_diff+"px");
            } else {
                if(caption_clone_content_wrapper_dimension.y + top_diff > container_dimension.y) {
                    top_diff = container_dimension.y - caption_clone_content_wrapper_dimension.y;
                }
                if(top_diff >= 0){
                    var triangle_diff = current_entry_position.y - container_position.y - top_diff;

                    _this.container.getElement(".caption-wrapper .caption-wrapper-triangle").setStyle("margin-top",triangle_diff+"px");
                    _this.container.getElement(".caption-wrapper").addClass("bottom-align");
                    _this.container.getElement(".caption-wrapper").setStyle("margin-top",top_diff+"px");
                } else {
                    var top_diff = (current_entry_position.y - container_position.y);
                    _this.container.getElement(".caption-wrapper").setStyle("margin-top","0px");
                    _this.container.getElement(".caption-wrapper .caption-wrapper-triangle").setStyle("margin-top",top_diff+"px");
                }
            }
            _this.container.getElement(".caption-wrapper").setAttribute('aria-live', 'assertive');
        }
    },

    bindEventsQuizModeEntries: function(){
        var _this = this;

        //accessibility
        _this.container.getElements(".quiz-mode .entry-element").each(function (entry){
            entry.setAttribute('role', 'button');
            entry.setAttribute('tabindex', 0);
            entry.setAttribute('aria-describedby', 'principle-instructions')
            // entry.setAttribute('aria-live', 'polite');

            entry.addEvent("keypress", function (e){
                if(e.key == "enter" || e.key == "space"){
                    droppable = this;

                    if (_this.checkAnswer(droppable)) {

                        _this.avaible_entries_quiz_mode.erase(_this.quiz_mode_current_item_object);

                        if(_this.first_try)
                            _this.correct_on_first_attemp++;

                        droppable.addClass("correct");

                        _this.container.getElement(".options-entrys .drag-result").set('text', 'Correct');
                        _this.container.getElement(".options-entrys .drag-result").set('aria-label', 'Correct');
                        _this.container.getElement(".options-entrys .drag-result").focus();
                        setTimeout(function() {
                            droppable.removeClass("correct");
                            _this.container.getElement(".options-entrys .drag-result").set('text', '');
                            _this.nextEntryChallange(Number.floor(Math.random()*_this.avaible_entries_quiz_mode.length),true);
                        }, 1200);



                        correct = true;
                    } else {
                        _this.first_try = false;
                        droppable.addClass("incorrect");
                        _this.container.getElement(".options-entrys .drag-result").set('text', 'Incorrect');
                        _this.container.getElement(".options-entrys .drag-result").set('aria-label', 'Incorrect');
                        // _this.container.getElement(".options-entrys .drag-result").focus();
                        setTimeout(function() {
                            droppable.removeClass("incorrect");
                            _this.container.getElement(".options-entrys .drag-result").set('text', '');
                            $$('.description-wrapper')[0].focus()
                        }, 1200);

                    }
                }
            })
        });
    },

    entryElementOutEvent: function(e){
        this.container.getElement(".caption-wrapper").addClass("non-active");
        this.container.getElement(".caption-wrapper").removeClass("bottom-align");
    }
});


/*
 ---
 description: Class for creating floating balloon tips that nicely appears when hovering an element.

 license: MIT-style

 authors:
 - Lorenzo Stanco

 requires:
 - core/1.3: '*'

 provides: [FloatingTips]

 ...
 */

var FloatingTips = new Class({

    Implements: [Options, Events],

    options: {
        position: 'top',
        fixed: false,
        center: true,
        content: 'title',
        html: false,
        balloon: true,
        arrowSize: 6,
        arrowOffset: 6,
        distance: 3,
        motion: 6,
        motionOnShow: true,
        motionOnHide: true,
        showOn: 'mouseenter',
        hideOn: 'mouseleave',
        hideOnTipOutsideClick: false,
        discrete: false,
        showDelay: 0,
        hideDelay: 0,
        className: 'floating-tip',
        identifier: '',
        offset: { x: 0, y: 0 },
        fx: { 'duration': 'short' }
    },

    /**
     * Array containing the elements which have a Tip applied by this instance
     */
    networkMembers: [],

    initialize: function(elements, options) {
        this.setOptions(options);
        var s = this;
        this.boundShow = (function() {
            var element = this;
            s.show(element);
            if (s.options.discrete) s.networkMembers.filter(function(item) {
                return item !== element;
            }).invoke('floatingTipsHide');
        });
        this.boundHide = (function() { s.hide(this); });
        if (!['top', 'right', 'bottom', 'left', 'inside'].contains(this.options.position)) this.options.position = 'top';
        if (elements) this.attach(elements);
        return this;
    },

    attach: function(elements) {
        var s = this;
        $$(elements).each(function(e) {
            s.networkMembers.include(e);
            if (e.retrieve('floatingtip_hasevents')) { return; }
            var evs = { };
            s.options.showOn && (evs[s.options.showOn] = s.boundShow);
            s.options.hideOn && (evs[s.options.hideOn] = s.boundHide);
            e.addEvents(evs);
            e.store('floatingtip_hasevents', true);
            e.store('floatingtip_object', s);
        });
        return this;
    },

    detach: function(elements) {
        var s = this;
        var evs = { };
        evs[this.options.showOn] = this.boundShow;
        evs[this.options.hideOn] = this.boundHide;
        $$(elements).each(function(e) {
            s.networkMembers.erase(e);
            s.hide(e);
            e.removeEvents(evs);
            e.eliminate('floatingtip_hasevents');
            e.eliminate('floatingtip_object');
        });
        return this;
    },

    show: function(element) {
        var old = element.retrieve('floatingtip');
        if (old) if (old.getStyle('opacity') != 0) { clearTimeout(old.retrieve('timeout')); return this; }
        var tip = this._create(element);
        if (tip == null) return this;
        element.store('floatingtip', tip);
        this._animate(tip, 'in');
        element.store('floatingtip_visible', true);
        this.fireEvent('show', [tip, element]);
        return this;
    },

    hide: function(element) {
        var tip = element.retrieve('floatingtip');
        if (!tip) return this;
        this._animate(tip, 'out');
        element.store('floatingtip_visible', false);
        this.fireEvent('hide', [tip, element]);
        return this;
    },

    toggle: function(element) {
        if (element.retrieve('floatingtip_visible')) return this.hide(element);
        else return this.show(element);
    },

    _create: function(elem) {
        var o = this.options;
        var oc = o.content;
        var opos = o.position;

        if (oc == 'title') {
            oc = 'floatingtitle';
            if (!elem.get('floatingtitle')) elem.setProperty('floatingtitle', elem.get('title'));
            elem.set('title', '');
        }

        var cnt = (typeof(oc) == 'string' ? elem.get(oc) : oc(elem));
        var cwr = new Element('div').addClass(o.className).setStyle('margin', 0);
        var tip = new Element('div')
          .addClass(o.className + '-wrapper')
          .addClass('position-' + this.options.position)
          .setStyles({ 'margin': 0, 'padding': 0 })
          .adopt(cwr);
        if (o.identifier.length > 0) {
            tip.addClass(o.identifier);
        }

        if (cnt) {
            if (o.html) {
                if (o.html_adopt) cwr.adopt(cnt);
                else cwr.set('html', typeof(cnt) == 'string' ? cnt : cnt.get('html'));
            } else {
                cwr.set('text', cnt);
            }
        } else {
            return null;
        }

        var body = document.id(document.body);
        tip.setStyles({ 'position': (o.fixed ? 'fixed' : 'absolute'), 'opacity': 0, 'top': 0, 'left': 0 }).inject(body);

        // Z-index "copied" after tip injecting, because of webkit bug: https://bugs.webkit.org/show_bug.cgi?id=15562
        cwr.setStyle('position', 'relative'); // Position
        tip.setStyles({ 'z-index': cwr.getStyle('z-index') });
        cwr.setStyle('position', null); // Reset position

        if (o.balloon && !Browser.ie6) {

            var trg = new Element('div').addClass(o.className + '-triangle').setStyles({ 'margin': 0, 'padding': 0 });
            var trgSt = { 'border-color': cwr.getStyle('background-color'), 'border-width': o.arrowSize, 'border-style': 'solid','width': 0, 'height': 0 };

            switch (opos) {
                case 'inside':
                case 'top'   : trgSt['border-bottom-width'] = 0; break;
                case 'right' : trgSt['border-left-width'  ] = 0; trgSt['float'] = 'left'; cwr.setStyle('margin-left', o.arrowSize); break;
                case 'bottom': trgSt['border-top-width'   ] = 0; break;
                case 'left'  : trgSt['border-right-width' ] = 0;
                    if (Browser.ie7) { trgSt['position'] = 'absolute'; trgSt['right'] = 0; } else { trgSt['float'] = 'right'; }
                    cwr.setStyle('margin-right', o.arrowSize); break;
            }

            switch (opos) {
                case 'inside': case 'top': case 'bottom':
                trgSt['border-left-color'] = trgSt['border-right-color'] = 'transparent';
                trgSt['margin-left'] = o.center ? tip.getSize().x / 2 - o.arrowSize : o.arrowOffset; break;
                case 'left': case 'right':
                trgSt['border-top-color'] = trgSt['border-bottom-color'] = 'transparent';
                trgSt['margin-top'] = o.center ?  tip.getSize().y / 2 - o.arrowSize : o.arrowOffset; break;
            }

            // Firefox triangle pixelation fix (https://brettstrikesback.com/de-pixelating-the-css-triangle/)
            if (Browser.firefox || Browser.name == 'firefox') {
                trgSt['-moz-transform'] = 'scale(1.01)';
                trgSt['transform'] = 'scale(1.01)';
            }

            trg.setStyles(trgSt).inject(tip, (opos == 'top' || opos == 'inside') ? 'bottom' : 'top');

        }

        var tipSz = tip.getSize(), trgC = elem.getCoordinates();
        var offsetOption = ('function' === typeof(o.offset) ? Object.merge({ x: 0, y: 0 }, o.offset(elem)) : o.offset);
        var pos = { x: trgC.left + offsetOption.x, y: trgC.top + offsetOption.y };

        if (opos == 'inside') {
            tip.setStyles({ 'width': tip.getStyle('width'), 'height': tip.getStyle('height') });
            elem.setStyle('position', 'relative').adopt(tip);
            pos = { x: o.offset.x, y: o.offset.y };
        } else {
            switch (opos) {
                case 'top'   :  pos.y -= tipSz.y + o.distance; break;
                case 'right' :  pos.x += trgC.width + o.distance; break;
                case 'bottom':  pos.y += trgC.height + o.distance; break;
                case 'left'  :  pos.x -= tipSz.x + o.distance; break;
            }
        }

        if (o.center) {
            switch (opos) {
                case 'top' : case 'bottom': pos.x += (trgC.width / 2 - tipSz.x / 2); break;
                case 'left': case 'right' : pos.y += (trgC.height / 2 - tipSz.y / 2); break;
                case 'inside':
                    pos.x += (trgC.width / 2 - tipSz.x / 2);
                    pos.y += (trgC.height / 2 - tipSz.y / 2); break;
            }
        }

        tip.set('morph', o.fx).store('position', pos);
        tip.setStyles({ 'top': pos.y, 'left': pos.x });

        if (o.hideOnTipOutsideClick) {
            var documentClickHandler = null;
            documentClickHandler = function(event) {
                var eventTarget = document.id(event.target);
                if (elem && elem !== eventTarget && !elem.contains(eventTarget)) {
                    this.hide(elem);
                } else if (!elem) {
                    document.removeEvent('click', documentClickHandler);
                }
            }.bind(this);
            document.addEvent('click', documentClickHandler);
            tip.addEvent('click', function(event) { event.stopPropagation(); });
        }

        return tip;
    },

    _animate: function(tip, d) {

        clearTimeout(tip.retrieve('timeout'));
        tip.store('timeout', (function(t) {

            var o = this.options, din = (d == 'in');
            var m = { 'opacity': din ? 1 : 0 };

            if ((o.motionOnShow && din) || (o.motionOnHide && !din)) {
                var pos = t.retrieve('position');
                if (!pos) return;
                switch (o.position) {
                    case 'inside':
                    case 'top'   : m['top']  = din ? [pos.y - o.motion, pos.y] : pos.y - o.motion; break;
                    case 'right' : m['left'] = din ? [pos.x + o.motion, pos.x] : pos.x + o.motion; break;
                    case 'bottom': m['top']  = din ? [pos.y + o.motion, pos.y] : pos.y + o.motion; break;
                    case 'left'  : m['left'] = din ? [pos.x - o.motion, pos.x] : pos.x - o.motion; break;
                }
            }

            t.morph(m);
            if (!din) t.get('morph').chain(function() { this.dispose(); }.bind(t));

        }).delay((d == 'in') ? this.options.showDelay : this.options.hideDelay, this, tip));

        return this;

    }

});

Elements.implement({

    floatingTips: function(options) {
        new FloatingTips(this, options);
        return this;
    }

});

Element.implement({

    floatingTips: function(options) {
        new FloatingTips($$(this), options);
        return this;
    },

    floatingTipsShow: function() {
        var tip = this.retrieve('floatingtip_object');
        if (tip) tip.show(this);
        return this;
    },

    floatingTipsHide: function() {
        var tip = this.retrieve('floatingtip_object');
        if (tip) tip.hide(this);
        return this;
    },

    floatingTipsToggle: function() {
        var tip = this.retrieve('floatingtip_object');
        if (tip) tip.toggle(this);
        return this;
    }

});

Element.Properties.floatingTips = {

    get: function(){
        return this.retrieve('floatingtip_object');
    }

};

