Timeline = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    options: {
        container: '',
        data: [],
        date_ranges: false,
        begin: 1990,
        end: 2000,
        starting_year: 1995,
        column_width: 70,
        column_height: 458,
        screen_width: 700,
        enabled_footer: true,
        footer: {
                begin: 1990,
                end: 2010
            },
        background_color: '',
        line_color: ''
    },

    footer: '',

    years: [],

    years_lines: [],

    main_timeline_position: {
        left: 0,
        right: 0
    },

    initialize: function(initialOptions) {
        var year,
            _this = this;
        
        //read data- options
        xmlType = $(initialOptions.container).get('data-xml-type');
        if (xmlType == 'date-ranges') {
            this.options.date_ranges = true;
        }

        this.options.begin = parseInt($(initialOptions.container).get('data-timeline-begin'));
        this.options.end = parseInt($(initialOptions.container).get('data-timeline-end'));
        this.options.starting_year = parseInt($(initialOptions.container).get('data-timeline-starting-year'));
        this.options.footer.begin = this.options.begin;
        this.options.footer.end = this.options.end;
        this.options.column_width = parseInt($(initialOptions.container).get('data-timeline-column-width'));
        this.options.enabled_footer = $(initialOptions.container).get('data-timeline-years-links');
        this.options.background_color = $(initialOptions.container).get('data-timeline-background-color');
        this.options.line_color = $(initialOptions.container).get('data-timeline-line-color');
        this.options.container = initialOptions.container;
        this.options.data = initialOptions.data;

        if (this.options.enabled_footer == 'false') {
            this.options.column_height = 524;
        }

        this.options.extra = [
            'data-timeline-years-links',
            'data-timeline-begin',
            'data-timeline-end',
            'data-timeline-starting-year',
            'data-timeline-column-width',
            'data-timeline-background-color',
            'data-timeline-line-color'
        ];
        this.setOptions(initialOptions);

        // Call parent MetrodigiWidget
        this.parent(this.options);
    },

    renderEdit: function() {
        introLine = this.options.container.getElementById('intro-line')

        if (introLine != null) {
            introLine = '<div id="intro-line" contenteditable="true" data-md-editable="md-content-editable">' + introLine.get('html') + '</div>'
        } else {
            introLine = ''
        }

        widgetContent = this.options.container.getElements('.widget-content')[0]
        widgetContent.set('html', '')
        widgetContent.appendHTML('<nav class="widget-slider"><div class="widget-slider-dots"></div></nav><nav class="widget-nav" role="navigation" aria-label="date"><ul class="year-links"></ul></nav><section class="widget-body grab"><div class="content-blocks-wrapper"><ul class="year-list year-list-ranges"></ul><ul class="year-list year-list-main-lines"></ul><ul class="year-list year-list-main"></ul></div></section>');

        this.years = [];
        this.years_lines = [];

        this.createDOM();
        this.render();

        this.autoLayout();
    },

    createDOM: function() {
        var _this = this;

        this.container = this.options.container;
        this.timeline_blocks_wrapper = this.container.getElement('.content-blocks-wrapper');
        this.timeline = this.container.getElement('.widget-body');
        this.year_list = this.container.getElement('.year-list-main');
        this.year_list_lines = this.container.getElement('.year-list-main-lines');
        this.year_list_special_block = this.container.getElement('.year-list-special-block');
        this.footer = this.container.getElement('.widget-nav');
        this.year_links = this.container.getElement('.year-links');
        this.dots = this.container.getElement('.widget-slider-dots');
        this.ranges = this.container.getElement('.year-list-ranges');

        border_left = "1px solid rgba(" + this.options.line_color + ", 0.3)";

        for (var i = this.options.begin; i <= this.options.end; i++) {
            year = new Timeline_Year({
                year: i,
                end_year: 0,
                date_ranges: this.options.date_ranges,
                width: this.options.column_width,
                height: this.options.column_height,
                border_left: border_left
            });
            year_line = new Timeline_Year_Lines({
                year:i,
                width: this.options.column_width,
                height: this.options.column_height,
                border_left: border_left 
            });
            this.getEvents(year);
            this.sliderGetEvents(year);
            this.years.push(year);
            this.years_lines.push(year_line);
        };

        this.timeline.addEvent('scroll', function(e, i) {
            _this.setActive(Math.round( ((_this.timeline.scrollLeft - _this.main_timeline_position.left) / _this.options.column_width) / 10 ) * 10);
        });

        new Drag.Scroll(this.timeline, {
            axis: {x: true, y: false},
            onDrag: function(el) {
                var elSize = el.getSize();
                var elPosition = el.getPosition();
                var cushion = 5;
                var x = this.drag.mouse.now.x - elPosition.x;
                
                _this.year_list.addClass("grabbing");
                if (x <= cushion || x >= elSize.x-cushion)
                {
                    this.drag.stop();
                }
            },
            onComplete: function(el) {
                _this.year_list.removeClass("grabbing");
            },
            onCancel: function(el){
                _this.year_list.removeClass("grabbing");
            }
        });

        this.container.ontouchmove = function() {event.preventDefault();}
    },

    getEvents: function(year) {
        for (var i = 0; i < this.options.data.length; i++) {
            if (this.options.data[i].Year == year.year) {
                if (this.options.date_ranges == true) {
                    year.end_year = this.options.data[i]["End Year"];    
                }
                
                year.events.push({
                    "event": this.options.data[i].Event,
                    "image": this.options.data[i]["Image"].path
                });
            }
        };
    },

    setActive: function(index) {
        var footer_element, year;

        if (this.year_list.children[index]) {
            year = this.year_list.children[index].get('data-year');
            this.year_list.getElements('.year').removeClass('active');
            this.year_list.children[index].addClass('active');
        }
        else {  
            // this is just a workaround for the special block, getting the first available year value
            year = this.timeline.getElement('.year').get('data-year')
        }
    },

    scrollToYear: function(year, animate, no_focus) {
        var _this = this;
        
        if (! this.timeline_blocks_wrapper.getElement('li[data-year="' + year + '"]')) {
            return;
        }

        if (this.timeline_blocks_wrapper.getElement('li[data-year="' + year + '"]').getElement("li")) {
            
            this.timeline_blocks_wrapper.getElement('li[data-year="' + year + '"]').getElement("li");
            if (!no_focus) {
                setTimeout(function() {
                    _this.timeline_blocks_wrapper.getElement('li[data-year="' + year + '"]').getElement("li").focus();
                }, 200);
            }
        } else {
            var nextyear = parseInt(year) + 1;

            if (this.timeline_blocks_wrapper.getElement('li[data-year="' + year + '"]').getElement("li")) {

                while (!this.timeline_blocks_wrapper.getElement('li[data-year="' + nextyear + '"]').getElement("li")) {
                    nextyear = nextyear + 1;
                }
                this.timeline_blocks_wrapper.getElement('li[data-year="' + nextyear + '"]').getElement("li");
                if (!no_focus) {
                    setTimeout(function() {
                        _this.timeline_blocks_wrapper.getElement('li[data-year="' + nextyear + '"]').getElement("li").focus();
                    }, 200);
                }
            }
        }
        var scroll_pos = this.timeline_blocks_wrapper.getElement('li[data-year="' + year + '"]').offsetLeft;
        if (year >= this.options.begin) {
            scroll_pos += this.main_timeline_position.left;
        }
        if (animate) {
            new Fx.Scroll(this.timeline).start(scroll_pos, 0);
        }
        else {
            this.timeline.scrollLeft = scroll_pos;
        }
    },

    render: function() {
        var _this = this,
             wrapper_width = 0,
             main_height = 480;
        
        contentWidth = (this.options.column_width * this.years.length) + (this.years.length+1);

        if (this.options.enabled_footer == 'false') {
            main_height = 490;
        }

        // Main timeline
        this.year_list
            .set('html', '')
            .setStyle('width', contentWidth)
            .setStyle('top', -700)
            .setStyle('height', main_height);

        //Timeline Lines
        this.year_list_lines
            .set('html', '')
            .setStyle('width', contentWidth);

        //Timeline Ranges
        this.ranges
            .set('html', '')
            .setStyle('width', contentWidth);

        for (var i = 0; i < this.years.length; i++) {
            this.years[i].render().inject(this.year_list);
            this.years_lines[i].render().inject(this.year_list_lines);
        }
        
        this.scrollToYear(this.options.starting_year, false, true);

        // Timeline footer
        if (this.options.enabled_footer == 'true') {

            this.year_links.set('html', '');

            for (var i = this.options.footer.begin; i < this.options.footer.end; i += 10) {
                new Element('li.year-link', {
                    html: i,
                    'data-year': i,
                    'tabindex': 1,
                    'role': 'link'
                }).addEvent('click', function() {
                    _this.scrollToYear(this.get('data-year'), true, true);
                    //slider
                    $('range').set('value', this.get('data-year'));
                }).addEvent('keyup', function(e) {
                    if (e.which == 13 || e.code == 13) {
                        _this.scrollToYear(this.get('data-year'), true, true);
                    }
                }).inject(this.year_links);
            };
        } else {
            //add styles to hide footer div
            this.footer.setStyle('display', 'none');
            this.timeline.setStyle('height', 535);
        }

        // calculate timeline blocks wrapper width for appropriate float
        for (var i = 0; i < this.timeline_blocks_wrapper.children.length; i++) {
            wrapper_width += this.timeline_blocks_wrapper.children[i].getDimensions().x;
        };
        this.timeline_blocks_wrapper.setStyle('width', (wrapper_width / 3));

        //set background and border line colors for years
        background_color = this.options.background_color.split(',');
        this.timeline_blocks_wrapper.setStyle('background-color', 'rgb(' + background_color[0] + ', ' + background_color[1] + ', ' + background_color[2] + ')');

        //Set Slider
        this.slider();

        window.addEvent('load', function() {
            window.widget_instance.autoLayout();
        });
    },

    slider: function() {
        html = '<input id="range" type="range" min="' + this.options.begin + '" max="' + this.options.end + '" value="' + this.options.starting_year + '"/></div>';
        $$('.widget-slider').appendHTML(html);

        this.sliderSlide();
        this.sliderPlaceDots();
    },

    sliderSlide: function() {
        $('range').addEvent('input', function () {
            var index = this.get('value');
            
            _this.scrollToYear(index, true, true);
        });
    },

    sliderPlaceDots: function() {
        for (var i = this.options.begin; i <= this.options.end; i++) {
            this.sliderGetEvents(year);
        };

        this.sliderDotsEvents();
    },

    sliderGetEvents: function(year) {
        interval = parseInt(this.options.end) - parseInt(this.options.begin);
        pxPerYear = 673 / interval;

        for (var i = 0; i < this.options.data.length; i++) {
            if (this.options.data[i].Year == year.year) {
                x = parseInt(year.year) - parseInt(this.options.begin);
                
                leftPosition = (pxPerYear * x) - pxPerYear;
                leftPosition = leftPosition < 0 ? 0 : leftPosition;

                new Element('div.dot', {
                    'data-year': year.year,
                    styles: {
                        left: leftPosition
                    }
                }).inject(this.dots);
            }
        }
    },

    sliderDotsEvents: function() {
        $$('.dot').addEvent('click', function() {
            _this.scrollToYear(this.get('data-year'), true, true);
            $('range').set('value', this.get('data-year'));
        }); 
    },

    //receive postmessage event
    customPostMessages:function(message,path) {
        this.parent(message, path);

        var that = this;

        switch(message.data.method){
            case "data-change":
                this.options.data = message.data.data;
                this.renderEdit()
                break;

            case "setting-change":
                switch(message.data.setting.attribute) {
                    case "data-timeline-column-width":
                        this.options.column_width = parseInt(message.data.setting.value);
                        break;

                    case "data-timeline-begin":
                        this.options.begin = parseInt(message.data.setting.value);
                        this.options.footer.begin = this.options.begin;
                        break;

                    case "data-timeline-end":
                        this.options.end = parseInt(message.data.setting.value);
                        this.options.footer.end = this.options.end;
                        break;

                    case "data-timeline-starting-year":
                        this.options.starting_year = parseInt(message.data.setting.value);
                        break;

                    case "data-timeline-years-links":
                        this.options.enabled_footer = message.data.setting.value;

                        if (this.options.enabled_footer == 'false') {
                            this.options.column_height = 524;
                        } else {
                            this.options.column_height = 458;
                        }
                        break;

                    case "data-timeline-background-color":
                        this.options.background_color = message.data.setting.value;
                        break;

                    case "data-timeline-line-color":
                        this.options.line_color = message.data.setting.value;
                        break;
                    case "data-xml-type":
                        location.reload();
                        break;
                }

                this.renderEdit()
                break;
                
            case "new-json":
                this.options.cards = message.data.json;

                _this.saveRequest({
                    method: 'mdData',
                    options: {'json': message.data.json}
                }, function(data){
                  
                },true);

                break;
            case "show-media-popup":
                var imagepath,
                    filepath, 
                    multimediaTypeFormat, 
                    multimediaType,
                    caption = "",
                    defaultImage = false,
                    copyFile = false;

                filepath = 'images/' + message.data.data.source_value;
                imagepath = "https://cdn3.iconfinder.com/data/icons/linecons-free-vector-icons-pack/32/video-128.png";
                multimediaType = multimediaTypeFormat =  message.data.data.source_type;

                if (multimediaType == "internet") {
                    multimediaType = "iframe";
                    filepath = imagepath = message.data.data.source_value;
                }

                if (multimediaType == "computer") {

                    if (message.data.data.source_ext.indexOf("image/")!= -1) {
                        multimediaType = "image";
                        multimediaTypeFormat = message.data.data.source_ext;
                        imagepath = filepath = message.data.data.source_value;
                    }

                    copyFile = true;

                }
                var containerSelector = '[data-md-editable="md-portal-media-list"]';

                that.saveRequest({
                    path: undefined,
                    method: 'appendMultimediaHTML5',
                    element: containerSelector,
                    type: 'md-portal-media-list-element',
                    content: imagepath,
                    filePath: filepath,
                    multimediaType: multimediaType,
                    multimediaTypeFormat: multimediaTypeFormat,
                    mustCopyTheFile: true,
                    caption: '',
                    defaultImage: false,
                    id: null
                },function(){});

                break;
        }
    },

    autoLayout: function() {
        for (var i = 0; i < this.years.length; i++) {
            if (
                    (
                     this.years[i - 1] && this.years[i - 1].padding_top > 230 ||
                     (this.years[i - 1] && this.years[i - 1].events.length == 0 && this.years[i - 2] && this.years[i - 2].padding_top > 230)
                    )
                    ||
                    (
                     this.years[i - 1] && this.years[i - 1].padding_top > 190 &&
                     this.years[i + 1] && this.years[i + 1].events.length == 0 &&
                     this.years[i + 2] && this.years[i + 2].events.length == 0
                    )
                ) {
                this.years[i].setPaddingTop(0);
            }
            
            if (this.years[i].events.length > 0 && this.options.column_width < 220) {
                if (this.years[i + 1] && this.years[i + 1].events.length > 0) {
                    this.years[i + 1].setPaddingTop(this.years[i].getElementsHeight());
                }
                if (this.years[i + 2] && this.years[i + 2].events.length > 0) {
                    this.years[i + 2].setPaddingTop(this.years[i].getElementsHeight());
                }
            }
        };
    }
});

Timeline_Year_Lines = new Class({
    Implements: [Options, Events],
    options: {
    },
    el: null,
    year: 0,
    padding_top: 0,
    events: [],

    initialize: function(options) {
        this.setOptions(options);
        if (this.options.padding_top) {
            this.padding_top = this.options.padding_top;
        }

        this.year = this.options.year;

        this.event_elements = [];
    },

    render: function() {
        this.el = new Element('li.year', {
            'data-year': this.year
        })
        if (this.options.width) {
            this.el.setStyles({
                width: this.options.width,
                height: this.options.height,
                'border-left': this.options.border_left
            });
        }

        new Element('strong.year-name', {
            html: this.getYearString(this.year),
            tabindex: -1,
            role: "heading",
            'aria-level': 2
        }).inject(this.el);
        if (this.events.length > 0) {
            this.event_list = new Element('ul.event-list').inject(this.el);
            this.populateEventList();
        }

        return this.el;
    },
    getYearString: function(year) {
        year = +year;
        if (year < 0) {
            return Math.abs(year) + ' B.C.E.';
        }
        return year;
    }
})

Timeline_Year = new Class({
    Implements: [Options, Events],

    options: {
        date_ranges: false
    },

    el: null,
    year: 0,
    end_year: 0,
    padding_top: 0,
    events: [],

    initialize: function(options) {
        this.setOptions(options);
        if (this.options.padding_top) {
            this.padding_top = this.options.padding_top;
        }

        this.year = this.options.year;

        this.event_elements = [];
    },

    render: function() {
        this.el = new Element('li.year', {
            'data-year': this.year
        })
        if (this.options.width) {
            this.el.setStyles({
                width: this.options.width,
                height: this.options.height,
            });
        }

        if (this.events.length > 0) {
            this.event_list = new Element('ul.event-list').inject(this.el);
            this.populateEventList();
        }

        return this.el;
    },

    getElementsHeight: function() {
        var height = 0;

        for (var i = 0; i < this.event_elements.length; i++) {
            height += this.event_elements[i].getSize().y;
        };

        return height + this.padding_top;
    },

    setPaddingTop: function(padding) {
        this.padding_top = padding;

        if (this.event_list) {
            this.event_list.setStyle('margin-top', padding);
        }
    },

    populateEventList: function() {
        var event_element;

        for (var i = 0; i < this.events.length; i++) {
            if (this.events[i]["event"] == 'SPACER') {
                event_element = new Element('li.event.spacer', {
                    html: '&nbsp;',
                    'tabindex': -1
                }).inject(this.event_list);
            }
            else {
                year_value = this.getYearString(this.year);

                if ((this.options.date_ranges == true) && (this.end_year) && (this.end_year.trim() != "")) {
                    if (isNaN(this.end_year.trim()) == false) {
                        end_year_value = this.getYearString(this.end_year);
                        year_value = year_value + ' - ' + end_year_value;        
                    }
                }

                event_element = new Element('li.event', {
                    html: '<span class="bullet"></span><strong>' + year_value + '</strong>&nbsp;' + this.events[i]["event"],
                    'tabindex': 2
                }).inject(this.event_list);
            }
            if (this.events[i]["image"]) {
                new Element('img', {
                    src: this.events[i]["image"],
                    alt: this.events[i]["event"]
                }).inject(event_element);
            }
            this.event_elements.push(event_element);
        };
    },

    getYearString: function(year) {
        year = +year;
        if (year < 0) {
            return Math.abs(year) + ' B.C.E.';
        }
        return year;
    }
})