Timeline = new Class({
    Implements: [Options, Events],

    options: {
        sections: 2,
        column_width: 70,
        years_per_column: 1,
        screen_width: 700
    },

    years: [],
    group_years: [],

    main_timeline_position: {
        left: 0,
        right: 0
    },

    initialize: function(options) {
        var year,
            _this = this;
    	this.setOptions(options);

        this.container = this.options.container;
        this.timeline = this.container.getElement('.timeline-body');

        this.timeline_blocks_wrapper = this.container.getElements('.timeline-blocks-wrapper');
        this.year_list = this.container.getElements('.year-list-main');

        this.footer = this.container.getElement('.timeline-footer');
        this.year_links = this.container.getElement('.year-links');

        for (var section = 0; section < this.options.sections; section++) {
            this.years[section] = [];
            for (var i = this.options.begin; i <= this.options.end; i += this.options.years_per_column) {
                year = new Timeline_Year({
                    year: i,
                    width: this.options.column_width
                });
                this.getEvents(year);
                this.years[section].push(year);
            };
        }

        if (this.options.data.groups.length > 0) {
            this.main_timeline_position.left = 0;
            for (var i = 0; i < this.options.data.groups.length; i++) {
                if (this.options.data.groups[i].type == 'single_block') {
                    this.renderBlock(this.options.data.groups[i]);
                    this.main_timeline_position.left += this.options.data.groups[i].element.getDimensions().x;
                }
            };
        }

        this.timeline.addEvent('scroll', function(e, i) {
            _this.setActive(Math.round( ((_this.timeline.scrollLeft - _this.main_timeline_position.left) / _this.options.column_width) / 10 ) * 10);
        });

        this.render();

        this.drag_scroll = new Drag.Scroll(this.timeline, {
            axis: {x: true, y: false}    
        });
    },

    getEvents: function(year) {
        var from = year.year,
            to = year.year + this.options.years_per_column;
        for (var i = 0; i < this.options.data.years.length; i++) {
            // console.log(this.options.data.years[i].Year);
            if (this.options.data.years[i].Year >= from && this.options.data.years[i].Year < to) {
                year.events.push({
                    "section": this.options.data.years[i].Section,
                    "year": +this.options.data.years[i].Year,
                    "year_end": this.options.data.years[i].RangeEnd,
                    "event": this.options.data.years[i].Event,
                    "image": this.options.data.years[i]["Image"]
                });
            }
        };
    },

    setActive: function(index) {
        var footer_element, year;

        if (this.year_list[0].children[index]) {
            year = this.year_list[0].children[index].get('data-year');
            this.year_list[0].getElements('.year').removeClass('active');
            this.year_list[0].children[index].addClass('active');
        }
        else {  // this is just a workaround for the special block, getting the first available year value
            year = this.timeline.getElement('.year').get('data-year')
        }
        
        // ACTIVE FOOTER LINK HIGLIGHT -- Uncomment to enable
        // this.year_links.getElements('.year-link').removeClass('active');
        // footer_element = this.year_links.getElement('.year-link[data-year="' + year + '"]');
        // if (footer_element) {
        //     footer_element.addClass('active');
        // }
        // else {
        //     for (var i = 0; i < this.options.data.groups.length; i++) {
        //         if (year >= this.options.data.groups[i].begin && year <= this.options.data.groups[i].end) {
        //             footer_element = this.year_links.getElement('.year-link[data-year="' + this.options.data.groups[i].begin + '"]').addClass('active');
        //         }
        //     };
        // }
    },

    scrollToYear: function(year, animate) {
        var scroll_pos = this.timeline_blocks_wrapper[0].getElement('li[data-year="' + year + '"]').offsetLeft;
        // scroll to the middle of timeline area
        scroll_pos -= this.timeline.getDimensions().x / 2 - this.options.column_width / 2;

        if (year >= this.options.begin) {
            scroll_pos += this.main_timeline_position.left;     // this position is set manually in options.main_timeline_position
        }
        if (animate) {
            new Fx.Scroll(this.timeline).start(scroll_pos, 0);
        }
        else {
            this.timeline.scrollLeft = scroll_pos;
        }
    },

    render: function() {
        var _this = this,
            wrapper_width = 0;

        // Timeline contents
        for (var section = 0; section < this.year_list.length; section++) {
            this.year_list[section]
                .set('html', '')
                .setStyle('width', this.options.column_width * this.years[section].length);

            for (var j = 0; j < this.years[section].length; j++) {
                this.years[section][j].render(section).inject(this.year_list[section]);
            }
        }

        this.scrollToYear(this.options.starting_year, false);

        // Timeline footer
        this.year_links.set('html', '');
        for (var i = 0; i < this.options.data.groups.length; i++) {
            new Element('li.year-link', {
                html: this.options.data.groups[i].label,
                'tabindex': 0,
                'data-year': this.options.data.groups[i].begin
            }).addEvents(
                    {
                        'click': function() {
                            _this.scrollToYear(this.get('data-year'), true);
                        },
                        'keypress': function(e) {
                            if (e.code === 13 || e.code === 32)
                                this.fireEvent("click");
                        }
                        
                    }).inject(this.year_links);
        }
        ;
        //console.log(this.options)
        for (var i = this.options.footer.begin; i < this.options.footer.end; i += this.options.footer.increment) {
            var label = '';
            this.options.data.years.each(function (el, index){                
                label = (index === 0) ? 'From ' + i + ' to ' + (i + parseInt(_this.options.footer.increment - 1)) + '. ' : label;
                if(parseInt(el.Year) >= i && parseInt(el.Year) < i + parseInt(_this.options.footer.increment)){                    
                    label = label + el.Year + ((el.RangeEnd) ? '-' + el.RangeEnd + ', ' : ', ') + el.Event + '. ' ;       
                    label = label.replace(/<\/?[^>]+(>|$)/g, "");
                    label = label.replace(/&#160;/g, " ");
                }
            });
            new Element('li.year-link', {
                html: i,
                'aria-label': label,
                'tabindex': 0,
                'data-year': i
            }).addEvents(
                    {
                        'click': function() {
                            _this.scrollToYear(this.get('data-year'), true);
                        },
                        'keypress': function(e) {
                            if (e.code === 13 || e.code === 32)
                                this.fireEvent("click");
                        }
                    }).inject(this.year_links);
        };

        // calculate timeline blocks wrapper width for appropriate float
        wrapper_width = [];
        for (var i = 0; i < this.timeline_blocks_wrapper.length; i++) {
            wrapper_width[i] = 0;
            for (var j = 0; j < this.timeline_blocks_wrapper[i].children.length; j++) {
                wrapper_width[i] += this.timeline_blocks_wrapper[i].children[j].getDimensions().x;
            }; 
        };
        wrapper_width.sort();
        for (var i = 0; i < this.timeline_blocks_wrapper.length; i++) {
            this.timeline_blocks_wrapper[i].setStyle('width', wrapper_width[0]);
        }

        setTimeout(function() {
            _this.autoLayout(0);
            _this.autoLayout(1);
        }, 50); // delay introduced to allow the web font to render before calculating sizes
    },

    renderBlock: function(group) {
        var year;

        for (var i = 0; i < this.options.data.years.length; i++) {
            if (this.options.data.years[i].Year >= group.begin && this.options.data.years[i].Year <= group.end) {
                year = new Timeline_Year({
                    year: this.options.data.years[i].Year,
                    width: this.options.screen_width / 5
                });
                this.getEvents(year);
                year.render().inject(group.element);
                this.group_years.push(year);
            }
        };
    },

    autoLayout: function(section) {
        var years_array = this.group_years.concat(this.years[section]);
        
        for (var i = 0; i < years_array.length; i++) {
            // if (section == 0 && years_array[i - 1]) console.log(years_array[i].year, years_array[i - 1].padding_top);
            if (
                    (
                     years_array[i - 1] && years_array[i - 1].padding_top > 115 ||
                     (years_array[i - 1] && years_array[i - 1].events.length == 0 && years_array[i - 2] && years_array[i - 2].padding_top > 115)
                    )
                    ||
                    (
                     years_array[i - 1] && years_array[i - 1].padding_top > 80 && 
                     years_array[i + 1] && years_array[i + 1].events.length == 0 &&
                     years_array[i + 2] && years_array[i + 2].events.length == 0
                    )
                ) {
                if (years_array[i - 2] && years_array[i - 2].events.length > 0 && years_array[i - 2].padding_top < 115) {

                }
                else {
                    years_array[i].setPaddingTop(0);
                }
            }
            if (years_array[i].events.length > 0) {
                if (years_array[i].padding_top > 200) {
                    years_array[i].setPaddingTop(0);
                }
                if (years_array[i + 1] && years_array[i + 1].events.length > 0) {
                    years_array[i + 1].setPaddingTop(years_array[i].getElementsHeight());
                }
                if (years_array[i + 2] && years_array[i + 2].events.length > 0) {
                    years_array[i + 2].setPaddingTop(years_array[i].getElementsHeight());
                }
            }
        };
    }
});

Timeline_Year = new Class({
    Implements: [Options, Events],

    options: {
    },

    el: null,
    year: 0,
    padding_top: 0,
    events: [],

    initialize: function(options) {
        this.setOptions(options);
        if (this.options.padding_top) {
            this.padding_top = this.options.padding_top;
        }

        this.year = this.options.year;

        this.event_elements = [];
    },

    render: function(section) {
        this.el = new Element('li.year', {
            'data-year': this.year
        })
        if (this.options.width) {
            this.el.setStyles({
                width: this.options.width
            });
        }

        new Element('strong.year-name', {
            html: this.year
        }).inject(this.el);
        if (this.events.length > 0) {
            this.event_list = new Element('ul.event-list').inject(this.el);
            this.populateEventList(section);
        }

        return this.el;
    },

    getElementsHeight: function() {
        var height = 0;

        for (var i = 0; i < this.event_elements.length; i++) {
            height += this.event_elements[i].getSize().y;
        };

        return height + this.padding_top;
    },

    setPaddingTop: function(padding) {
        this.padding_top = padding;

        if (this.event_list) {
            this.event_list.setStyle('margin-top', padding);
        }
    },

    populateEventList: function(section) {
        var event_element, year_string;

        for (var i = 0; i < this.events.length; i++) {
            if (this.events[i].section != section) {    // only add events of the current section
                continue;
            }

            year_string = this.events[i]["year"];
            if (this.events[i]["year_end"]) {
                year_string += "&#8212;" + this.events[i]["year_end"];
            }
            event_element = new Element('li.event.year-'+year_string, {
                html: '<span class="bullet"></span><strong>' + year_string + '</strong>&#160;' + this.events[i]["event"]
            }).inject(this.event_list);
            if (this.events[i]["image"]) {
                new Element('img', {
                    alt: this.events[i]["year"] + ', ' + this.events[i]["event"],
                    src: this.events[i]["image"]
                }).inject(event_element);
            }
            this.event_elements.push(event_element);
        };
    }
})