Timeline = new Class({
    Implements: [Options, Events],

    options: {
        column_width: 70,
        screen_width: 700
    },

    years: [],
    group_years: [],

    main_timeline_position: {
        left: 700,
        right: 0
    },

    initialize: function(options) {
        window.addEvent("mousemove",function(){
          document.getElement("body").addClass("remove-outline");
        })
        .addEvent("keyup",function(e){
            if(e.key=="tab"){
                document.getElement("body").removeClass("remove-outline");
            }
        });
        var year,
            _this = this;
    	this.setOptions(options);

        this.container = this.options.container;
        this.timeline_blocks_wrapper = this.container.getElement('.content-blocks-wrapper');
        this.timeline = this.container.getElement('.widget-body');
        this.year_list = this.container.getElement('.year-list-main');
        this.year_list_special_block = this.container.getElement('.year-list-special-block');
        this.footer = this.container.getElement('.widget-nav');
        this.year_links = this.container.getElement('.year-links');

        for (var i = this.options.begin; i <= this.options.end; i++) {
            var w = this.options.column_width;

            var grouped_date = false;
            var grouped_date_is_init = false;
            var grouped_date_is_last = false;
            

            if(this.options.data.group_ranges!=null){
                for(var h in this.options.data.group_ranges){
                    var group_range = this.options.data.group_ranges[h];
                    if(i>=group_range.begin && i<=group_range.end){
                        if(i==group_range.begin){
                            grouped_date_is_init = true;
                        }
                        if(i==group_range.end){
                            grouped_date_is_last = true;
                        }
                        grouped_date = true;
                        w = w/5;
                        if(this.options.group_ranges_width){
                            w=this.options.group_ranges_width;
                        }
                    }
                }
            }

            year = new Timeline_Year({
                year: i,
                width: w
            });

            
            this.getEvents(year);

            if(grouped_date){
                year.grouped = true;
            }
            if(grouped_date_is_init){
                year.grouped_init_date = true;
            }
            if(grouped_date_is_last){
                year.grouped_last_date = true;
            }

            this.years.push(year);
        };

        if (this.options.data.groups.length > 0) {
            this.main_timeline_position.left = 0;
            for (var i = 0; i < this.options.data.groups.length; i++) {
                if (this.options.data.groups[i].type == 'single_block') {
                    this.renderBlock(this.options.data.groups[i]);
                    this.main_timeline_position.left += this.options.data.groups[i].element.getDimensions().x;
                }
            };
        }

        this.timeline.addEvent('scroll', function(e, i) {
            _this.setActive(Math.round( ((_this.timeline.scrollLeft - _this.main_timeline_position.left) / _this.options.column_width) / 10 ) * 10);
        });

        this.render();

        new Drag.Scroll(this.timeline, {
            axis: {x: true, y: false},
            onDrag: function(el, e) {
                var elSize = el.getSize();
                var elPosition = el.getPosition();
                var cushion = 5;
                var x = this.drag.mouse.now.x - elPosition.x;
                
                if (x <= cushion || x >= elSize.x-cushion)
                {
                    this.drag.stop();
                }
            },
        });
        this.container.ontouchmove = function() {event.preventDefault();}
    },

    getEvents: function(year) {
        for (var i = 0; i < this.options.data.years.length; i++) {
            if (this.options.data.years[i].Year == year.year) {
                year.events.push({
                    "event": this.options.data.years[i].Event,
                    "image": this.options.data.years[i]["Image"]
                });
            }
        };
    },

    setActive: function(index) {
        var footer_element, year;

        if (this.year_list.children[index]) {
            year = this.year_list.children[index].get('data-year');
            this.year_list.getElements('.year').removeClass('active');
            this.year_list.children[index].addClass('active');
        }
        else {  // this is just a workaround for the special block, getting the first available year value
            year = this.timeline.getElement('.year').get('data-year')
        }
    },

    scrollToYear: function(year, animate, no_focus) {
        var nextyear = parseInt(year);
        if(nextyear != nextyear == this.options.footer.begin)
            nextyear--;
        while (!this.timeline_blocks_wrapper.getElement('li[data-year="' + nextyear + '"]').getElement("li")) {
            nextyear++;
            if(nextyear == this.options.footer.end)
              break;
        }
        
        var scroll_pos = this.timeline_blocks_wrapper.getElement('li[data-year="' + (nextyear - 1) + '"]').offsetLeft;        
        new Fx.Scroll(this.timeline).start(scroll_pos, 0);        
    },

    render: function() {
        var _this = this,
            wrapper_width = 0;

        // Main timeline
        this.year_list
            .set('html', '')
            .setStyle('width', this.options.column_width * this.years.length);

        for (var i = 0; i < this.years.length; i++) {
            this.years[i].render().inject(this.year_list);
        }

        this.scrollToYear(this.options.starting_year, false, true);

        // Timeline footer
        this.year_links.set('html', '');
        for (var i = 0; i < this.options.data.groups.length; i++) {
            new Element('li.year-link', {
                html: this.options.data.groups[i].label,
                'data-year': this.options.data.groups[i].begin,
                'tabindex': 1,
                'role': 'link'
            }).addEvent('click', function() {
                _this.scrollToYear(this.get('data-year'), true);
            }).addEvent('keyup', function(e) {
                if (e.which == 13 || e.code == 13) {
                    _this.scrollToYear(this.get('data-year'), true);
                }
            }).inject(this.year_links);
        };
        for (var i = this.options.footer.begin; i < this.options.footer.end; i += this.options.footer.interval) {
            
            var nextyear = i, insertyear = true;
            if(nextyear != nextyear == this.options.footer.begin)
                nextyear--;
            while (!this.timeline_blocks_wrapper.getElement('li[data-year="' + nextyear + '"]').getElement("li")) {
                nextyear++;
                if(nextyear == (i + this.options.footer.interval)){
                    insertyear = false;
                    break;
                }                    
                  
            }
            
            if(insertyear){
                new Element('li.year-link', {
                    html: i,
                    'data-year': i,
                    'tabindex': 1,
                    'role': 'link'
                }).addEvent('click', function() {
                    _this.scrollToYear(this.get('data-year'), true);
                }).addEvent('keyup', function(e) {
                    if (e.which == 13 || e.code == 13) {
                        _this.scrollToYear(this.get('data-year'), true);
                    }
                }).inject(this.year_links);
            }
        };

        // calculate timeline blocks wrapper width for appropriate float
        for (var i = 0; i < this.timeline_blocks_wrapper.children.length; i++) {
            wrapper_width += this.timeline_blocks_wrapper.children[i].getDimensions().x;
        };
        this.timeline_blocks_wrapper.setStyle('width', wrapper_width);

        window.addEvent('load', function() {
            window.widget_instance.autoLayout();
        });
    },

    renderBlock: function(group) {
        var year;

        for (var i = 0; i < this.options.data.years.length; i++) {
            if (this.options.data.years[i].Year >= group.begin && this.options.data.years[i].Year <= group.end) {
                year = new Timeline_Year({
                    year: this.options.data.years[i].Year,
                    width: this.options.screen_width / 5
                });
                this.getEvents(year);
                year.render().inject(group.element);
                this.group_years.push(year);
            }
        };
    },

    autoLayout: function() {
        var years_array = this.group_years.concat(this.years);

        for (var i = 0; i < years_array.length; i++) {
            // console.log(years_array[i].year, years_array[i - 1] && years_array[i - 1].padding_top);
            if (
                    (
                     years_array[i - 1] && years_array[i - 1].padding_top > 230 ||
                     (years_array[i - 1] && years_array[i - 1].events.length == 0 && years_array[i - 2] && years_array[i - 2].padding_top > 230)
                    )
                    ||
                    (
                     years_array[i - 1] && years_array[i - 1].padding_top > 190 &&
                     years_array[i + 1] && years_array[i + 1].events.length == 0 &&
                     years_array[i + 2] && years_array[i + 2].events.length == 0
                    )
                ) {
                years_array[i].setPaddingTop(0);
            }
            if (years_array[i].events.length > 0) {
                if (years_array[i + 1] && years_array[i + 1].events.length > 0) {
                    years_array[i + 1].setPaddingTop(years_array[i].getElementsHeight());
                }
                if (years_array[i + 2] && years_array[i + 2].events.length > 0) {
                    years_array[i + 2].setPaddingTop(years_array[i].getElementsHeight());
                }
            }
        };
    }
});

Timeline_Year = new Class({
    Implements: [Options, Events],

    options: {
    },

    el: null,
    year: 0,
    padding_top: 0,
    events: [],

    initialize: function(options) {
        this.setOptions(options);
        if (this.options.padding_top) {
            this.padding_top = this.options.padding_top;
        }

        this.year = this.options.year;

        this.event_elements = [];
    },

    render: function() {
        
        this.el = new Element('li.year', {
            'data-year': this.year
        })
        if (this.options.width) {
            this.el.setStyles({
                width: this.options.width
            });
        }
        if(this.grouped!=null && this.grouped){
            this.el.addClass("grouped-date")
        }
        if(this.grouped_init_date!=null && this.grouped_init_date){
            this.el.addClass("grouped-init-date")
        }
        if(this.grouped_last_date!=null && this.grouped_last_date){
            this.el.addClass("grouped-last-date")
        }

        

        new Element('strong.year-name', {
            html: this.getYearString(this.year),
            tabindex: -1,
            role: "heading",
            'aria-level': 2
        }).inject(this.el);
        if (this.events.length > 0) {
            this.event_list = new Element('ul.event-list').inject(this.el);
            this.populateEventList();
        }

        return this.el;
    },

    getElementsHeight: function() {
        var height = 0;

        for (var i = 0; i < this.event_elements.length; i++) {
            height += this.event_elements[i].getSize().y;
        };

        return height + this.padding_top;
    },

    setPaddingTop: function(padding) {
        this.padding_top = padding;

        if (this.event_list) {
            this.event_list.setStyle('margin-top', padding);
        }
    },

    populateEventList: function() {
        var event_element;

        for (var i = 0; i < this.events.length; i++) {
            if (this.events[i]["event"] == 'SPACER') {
                event_element = new Element('li.event.spacer', {
                    html: ' ',
                    'tabindex': -1
                }).inject(this.event_list);
            }
            else {
                event_element = new Element('li.event', {
                    html: '<span class="bullet"></span><strong>' + this.getYearString(this.year) + '</strong> ' + this.events[i]["event"],
                    'tabindex': 2
                }).inject(this.event_list);
            }
            if (this.events[i]["image"]) {
                new Element('img', {
                    src: this.events[i]["image"],
                    alt: this.events[i]["event"]
                }).inject(event_element);
            }
            this.event_elements.push(event_element);
        };
    },

    getYearString: function(year) {
        year = +year;
        if (year < 0) {
            return Math.abs(year) + ' B.C.E.';
        }
        return year;
    }
})