Timeline = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    options: {
        canvas: $$('#widget-canvas')[0],
        start: 1900,
        end: 2000,
        border: 1,
        singleMap: true,
        displaySlider: true,
        date_ranges: false
    },
    stepArray: [1, 5, 10, 20, 25, 50, 75, 100, 250, 500, 750, 1000, 2500, 5000, 10000],
    stepArrayLong: [5, 50, 75, 100, 250, 500, 750, 1000, 2500, 5000, 10000],
    rangeStart: null,
    rangeEnd: null,
    startDateCalculated:0,
    endDateCalculated:0,

    initialize: function(initialOptions) {
        var that = this;
        document.widgetType = 'timeline';
        this.options.extra = [
            'data-timeline-start',
            'data-timeline-end',
            'data-display-second-timeline',
            'data-display-year-slider'
        ];

        this.setOptions(initialOptions);
        this.options.start = parseInt($(initialOptions.container).get('data-timeline-start'));
        this.options.end = parseInt($(initialOptions.container).get('data-timeline-end'));
        this.options.singleMap = $(initialOptions.container).get('data-display-second-timeline') == "false";
        this.options.displaySlider = $(initialOptions.container).get('data-display-year-slider') == "true";
        this.options.date_ranges = $(initialOptions.container).get('data-xml-type') == 'date-ranges';

        // Calculate the sliderStep depending on window
        this.yearCount = this.options.end - this.options.start;

        // Call parent MetrodigiWidget
        this.parent(initialOptions);

        // Render on resize
        window.addEvent('resize', function(e){
            if(!this.Slider) {
                that.render();
            } else {
                that.render(true);
            }
        });

        // Accessibility data
        if(this.options.data) {
            this.options.data.each(function(data_array){
                if(data_array){
                    for (var i = 0 ; i < data_array.length; i++) {
                        if(data_array[i].Popup){
                            var hidden_element = new Element('div', {html: that.convertToHTML(that.convertToHTML(data_array[i].Popup))});
                            $$("#MetrodigiWidget").adopt(hidden_element);
                            hidden_element.hide();
                        }
                    };
                }
            });
        }
        that.accessibilityAltSearch();
        $$('.widget-nav')[0].remove();

    },

    /*
     *  customPostMessages - Receive postmessage event
     */
    customPostMessages:function(message,path) {
        this.parent(message, path);

        var that = this;

        switch(message.data.method){
            case "setting-change":
                switch(message.data.setting.attribute) {
                    case 'data-timeline-start':
                        this.options.start = parseInt(message.data.setting.value);
                        // Calculate the sliderStep depending on window
                        this.options.container.set('data-timeline-start', message.data.setting.value);
                        break;
                    case 'data-timeline-end':
                        this.options.end = parseInt(message.data.setting.value);
                        // Calculate the sliderStep depending on window
                        this.options.container.set('data-timeline-end', message.data.setting.value);
                        break;
                    case 'data-display-second-timeline':
                        this.options.singleMap = message.data.setting.value == "false";
                        this.options.container.set('data-display-second-timeline', message.data.setting.value);
                        break;
                    case 'data-display-year-slider':
                        this.options.displaySlider = message.data.setting.value == "true";
                        this.options.container.set('data-display-year-slider', message.data.setting.value);
                        break;
                    case 'data-xml-type':
                        this.options.date_ranges = message.data.setting.value == 'date-ranges';
                        this.container.set('data-xml-type', this.options.date_ranges? 'date-ranges' : 'default' );
                        this.sendWidgetOptions(this.options.extra);
                        break;
                }
                this.yearCount = this.options.end - this.options.start;
                this.createDOM();
                this.render(true);
                break;
            case "data-change":
                this.options.data = message.data.data;
                this.yearCount = this.options.end - this.options.start;
                this.createDOM();
                this.render(true);
                break;
            case "view-mode-switch":
                this.yearCount = this.options.end - this.options.start;
                this.createDOM();
                this.render(true);
                break;
        }
    },

    /*
     *  createDOM - Creates the basic dom structure
     */
    createDOM: function() {
        var that = this;

        this.body.empty();

        // Create Timeline Container
        this.timelineContainer = new Element('div', {
            'class': this.options.displaySlider?'timeline-container':'timeline-container full',
            'id': 'timeline-container',
            'events': {
                mousemove: function(e) {
                    if(that.scrolling) {
                        // calculate responsive ratio
                        var windowWidth = (window.innerWidth > 0) ? window.innerWidth : screen.width;
                        var responsiveRatio = windowWidth / window._breakpoint_width;
                        if (responsiveRatio > 1 || windowWidth >= window._breakpoint_width) {
                            responsiveRatio = 1;
                        }
                        var scrollTo = (that.scroll_x-e.page.x)-that.scroll_left+this.getCoordinates().left;
                        // apply css transform scale to scrollTo
                        scrollTo = scrollTo / responsiveRatio;
                        if(scrollTo > 0 && scrollTo < (that.timelineWidth - this.getSize().x)) {
                            that.previous_left = that.scroll_left;
                            var latestScrollPosition = that.timeline1Scroll.element.scrollTop;
                            that.timeline1Scroll.set(scrollTo, latestScrollPosition);
                            if(! that.options.singleMap) {
                                that.timeline2Scroll.set(scrollTo, 0);
                            }
                            that.ScaleScroll.set(scrollTo, 0);

                            var visibleYears = that.rangeEnd - that.rangeStart;

                            that.rangeStart = Math.floor(that.startDateCalculated + scrollTo*that.timelineStep/that.yearWidth);
                            that.rangeEnd = that.rangeStart + visibleYears;

                            if (that.slider) {
                                that.slider.setKnobs(that.rangeStart, that.rangeEnd);
                            }
                        }
                    }
                },
                touchmove: function(e) {
                    if(that.scrolling) {
                        // calculate responsive ratio
                        var windowWidth = (window.innerWidth > 0) ? window.innerWidth : screen.width;
                        var responsiveRatio = windowWidth / window._breakpoint_width;
                        if (responsiveRatio > 1 || windowWidth >= window._breakpoint_width) {
                            responsiveRatio = 1;
                        }
                        var scrollTo = (that.scroll_x-e.page.x)-that.scroll_left+this.getCoordinates().left;
                        // apply css transform scale to scrollTo
                        scrollTo = scrollTo / responsiveRatio;
                        if(scrollTo > 0 && scrollTo < (that.timelineWidth - this.getSize().x)) {
                            that.previous_left = that.scroll_left;
                            var latestScrollPosition = that.timeline1Scroll.element.scrollTop;
                            that.timeline1Scroll.set(scrollTo, latestScrollPosition);
                            if(! that.options.singleMap) {
                                that.timeline2Scroll.set(scrollTo, 0);
                            }
                            that.ScaleScroll.set(scrollTo, 0);

                            var visibleYears = that.rangeEnd - that.rangeStart;

                            that.rangeStart = Math.floor(that.startDateCalculated + scrollTo*that.timelineStep/that.yearWidth);
                            that.rangeEnd = that.rangeStart + visibleYears;

                            that.slider.setKnobs(that.rangeStart, that.rangeEnd);
                        }
                    }
                },
                mouseup: function() {
                    that.scrolling = false;
                },
                touchend: function() {
                    that.scrolling = false;
                },
                mouseleave: function() {
                    that.scrolling = false;
                }
            }
        }).inject(this.body);


        // Create the scale container
        this.scaleContainer = new Element('div', {
            'class': 'year-scale-container',
            'id': 'year-scale-container',
        }).inject(this.timelineContainer);

        this.ScaleScroll = new Fx.Scroll('year-scale-container');

        // Create first timeline
        var timeline_class = 'timeline';
        if(! this.options.singleMap) timeline_class += ' half';

        this.timeline1 = new Element('div', {
            'class': timeline_class,
            'id': 'timeline-1'
        }).inject(this.timelineContainer);

        touchScroll('timeline-1')

        this.timeline1Scroll = new Fx.Scroll('timeline-1');

        // If data for second timeline, create second timeline
        if(! this.options.singleMap) {
            this.divider = new Element('div', {
                'class': 'divider',
            }).inject(this.timelineContainer);

            var myDrag = new MDrag(this.divider, {
                snap: 0,
                modifiers: {'x': '', 'y': ''},
                onDrag: function(el, e){
                    var height = e.client.y - that.timelineContainer.getPosition().y;

                    if(height > 15 && height < (that.timelineContainer.getSize().y - 60)) {
                        that.timeline1.setStyle('height', height);
                        that.timeline2.setStyle('height', 'calc(100% - '+height+'px)');
                    }
                }
            });

            this.timeline2 = new Element('div', {
                'class': timeline_class,
                'id': 'timeline-2',
            }).inject(this.timelineContainer);

            this.timeline2Scroll = new Fx.Scroll('timeline-2');
        }

        // Create Year Slider Container
        if(this.options.displaySlider) {
            this.sliderContainer = new Element('div', {
                'class': 'year-slider-container',
                'events': {
                    touchstart: function(){
                        that.scrolling = true;
                    },
                    touchend: function() {
                        that.scrolling = false;
                    }
                }
            }).inject(this.body);
        }

        // Create popup container
        this.windowDiv = new Element('div.event-popup', {
            role: 'dialog',

            'aria-label': "Event",
            styles: { 'display': 'none', 'position': 'absolute' },
            events: {
                // click: function(e) {
                //     e.stopPropagation();
                // },
                // touchstart: function(e){
                //     e.stopPropagation()
                // }
            }
        });
        this.windowDiv.inject(that.timelineContainer);

        // this.body.addEvent('click', function() {
        //     that.windowDiv.hide();
        //
        // },false);
        //   this.body.addEvent('touchstart', function(e) {
        //     that.windowDiv.hide();
        //   },false);

        window.addEventListener("keydown", function(e){
          var wasEscapePressed = e.code == 27 || e.which == 27 || e.keyCode == 27;
          var popup = $$('.event-popup')[0];
          if(wasEscapePressed && popup.isVisible()){
            popup.hide();
            that.hidePopup();
          }
        });
    },

    render: function(force_reload) {
        // Calculate the slider step
        for(var i=0; i<this.stepArray.length; i++) {
            this.sliderStep = this.stepArray[i];
            if(Math.floor(this.body.getSize().x/Math.round(this.yearCount/this.sliderStep + 1)) >= 100)
                break;
        }

        // Recalculate start date
        this.startDateCalculated = Math.floor(this.options.start/this.sliderStep) * this.sliderStep;
        // this.startDateCalculated = this.options.start;

        // Recalculate end date
        this.endDateCalculated = Math.ceil(this.options.end/this.sliderStep) * this.sliderStep;
        // this.endDateCalculated = this.options.end;

        // Recalculate year count
        this.yearCount = this.endDateCalculated - this.startDateCalculated;
        if(this.options.displaySlider) {
            // Create the Slider
            this.rangeStart = this.startDateCalculated;
            this.rangeEnd = this.endDateCalculated;
            this.renderYearSlider(force_reload);
        } else {
            // Create the Timelines
            this.rangeStart = this.startDateCalculated;
            this.rangeEnd = this.endDateCalculated;
            this.renderTimelines(force_reload);
        }
    },

    /*
     *  createScale - Creates the timeline year scale
     */
    createScale: function(force_reload) {
        //Get The years to be displayed on the window
        var visibleYears = this.rangeEnd - this.rangeStart;
        this.previousTimelineStep = this.timelineStep;

        if(visibleYears < 1) visibleYears = 1;
        //console.log("resize?");

        // Calculate the steps depending on window
        var was_exact = false;
        if(this.yearCount > 3000){
            var stepArrays = this.stepArrayLong;
        }else{
            var stepArrays = this.stepArray;
        }
        for(var i=0; i<stepArrays.length; i++) {
            this.timelineStep = stepArrays[i];
            this.yearWidth = Math.floor(this.scaleContainer.getSize().x/Math.round(visibleYears/this.timelineStep + 1));
            //console.log(this.yearWidth, this.endDateCalculated%this.timelineStep);
            if(this.yearWidth >= 100 && this.endDateCalculated%this.timelineStep == 0){
                was_exact = true;
                break;
            }

        }

        var calculates = [];
        var exact_part = false;
        if(!was_exact){
            for(var i=0; i<stepArrays.length; i++) {
                this.timelineStep = stepArrays[i];
                this.yearWidth = Math.floor(this.scaleContainer.getSize().x/Math.round(visibleYears/this.timelineStep + 1));
                calculates.push({
                    yw: this.yearWidth,
                    ts: this.timelineStep,
                    p1: this.scaleContainer.getSize().x,
                    p2: (visibleYears/this.timelineStep + 1)
                });
                //console.log(this.yearWidth, this.endDateCalculated%this.timelineStep);
                //if(this.yearWidth >= 100 && this.endDateCalculated%this.timelineStep == 0) break;
                if(this.yearWidth >= 100){
                    if(this.endDateCalculated%this.timelineStep == 0){
                        exact_part = true;
                    }
                    break;
                 }
            }
        }

        //this.yearWidth = 139;
        //this.timelineStep = 75;
        //console.log(this.yearWidth);
        /*console.log(
            "calculates",
            calculates,
            "this.yearWidth",
            this.yearWidth,
            "this.scaleContainer.getSize().x",
            this.scaleContainer.getSize().x,
            "this.endDateCalculated",
            this.endDateCalculated,
            "this.timelineStep",
            this.timelineStep,
            "this.stepArray",
            this.stepArray,
            "this.rangeEnd",
            this.rangeEnd,
            "this.rangeStart",
            this.rangeStart,
            "this.scaleContainer.getSize().x",
            this.scaleContainer.getSize().x,
            "visibleYears",
            visibleYears,
            "this.timelineStep",
            this.timelineStep,
            "Math.round(visibleYears/this.timelineStep + 1)",
            Math.round(visibleYears/this.timelineStep + 1),
            "this.startDateCalculated",
            this.startDateCalculated,
            "this.endDateCalculated",
            this.endDateCalculated ,
            "exact_part",
            exact_part,
            "this.previousTimelineStep",
            this.previousTimelineStep,
            "force_reload",
            force_reload);

        */
        var totalDivisions = Math.ceil(this.yearCount/this.timelineStep+2); // Get the timeline year width
        this.timelineWidth = this.yearWidth * totalDivisions; // Get the timeline width

        if(this.timelineWidth < this.scaleContainer.getSize().x)
            this.timelineWidth = this.scaleContainer.getSize().x;

        // If timelineStep steps change, refactor the scale
        // Otherwise just update the widths
        if(false && this.previousTimelineStep == this.timelineStep && !force_reload) {
            // Update scaleContainer width
            $$('.year-scale').setStyle('width', this.timelineWidth);

             // Update scaleContainer width
            $$('.year-scale-item').setStyle('width', this.yearWidth);

        } else {
            this.scaleContainer.empty();

            // console.log("------------VCK DEBUG-------------------");
            // console.log("yearWidth: " + this.yearWidth);
            // console.log("totalDivisions: " + totalDivisions);
            // console.log("timelineWidth: " + this.timelineWidth);
            // console.log("timelineStep: " + this.timelineStep);
            // console.log("yearCount: " + this.yearCount);
            // console.log("startDateCalculated: " + this.startDateCalculated);
            // console.log("-------------END---------------");

            var scaleElement = new Element('div', {
                'class': 'year-scale',
            }).inject(this.scaleContainer);

            // Update scaleContainer width
            scaleElement.setStyle('width', this.timelineWidth);

            // Create the elements
            for(var i=this.startDateCalculated; i<this.endDateCalculated; i+=this.timelineStep) {
                var label = Math.abs(i);

                if(this.startDateCalculated < 0) {
                    if(i == this.startDateCalculated) label += " BCE";
                    if(i == 0) label = "BCE <> CE";
                }

                new Element('div', {
                    'class': 'year-scale-item',
                    html: '<div>'+label+'</div>',
                    styles: {
                        width: this.yearWidth,
                    },
                }).inject(scaleElement);
            }

            // Create last year label
            // honored end date
            label = Math.abs(this.options.end);
            if(this.startDateCalculated < 0)
                if(this.endDateCalculated < 0)
                    label += " BCE";
                else if (this.endDateCalculated > 0)
                    label += " CE";

            new Element('div', {
                'class': 'year-scale-item',
                html: '<div>'+label+'</div>',
                styles: {
                    width: this.yearWidth,
                },
            }).inject(scaleElement);
        }
    },

    /*
     *  createTimeline - Creates the timeline
     */
    createTimeline: function(container, force_reload) {
        var that = this;

        // If timelineStep steps change, refactor the timeline(s)
        // Otherwise just update the widths
        if(false && this.previousTimelineStep == this.timelineStep && !force_reload) {
            // Update yearContainer width
            $$('.year-container').setStyle('width', this.timelineWidth);
            //console.log(this.timelineWidth, this.yearWidth, this.options.border);

            // Update scaleContainer width
            $$('.year-division-item').setStyle('width', this.yearWidth - this.options.border);
            $$('.year-division-item.first-division').setStyle('width', this.yearWidth/2 - this.options.border);

        } else {
            container.empty();
            //console.log("erase");
            //console.log(this.timelineWidth, this.yearWidth, this.options.border);

            var yearContainer = new Element('div', {
                'class': 'year-container',
                'events': {
                    mousedown: function(e) {
                        e.preventDefault();
                        that.scrolling = true;
                        that.scroll_x = e.page.x;
                        that.scroll_left = this.getCoordinates().left;
                    },
                    touchstart: function(e) {
                        e.preventDefault();
                        that.scrolling = true;
                        that.scroll_x = e.page.x;
                        that.scroll_left = this.getCoordinates().left;
                    }
                }
            }).inject(container);

            // Create first division (start of the timeline)
            new Element('div', {
                'class': 'year-division-item first-division',
                styles: {
                    width: this.yearWidth/2 - this.options.border,
                },
            }).inject(yearContainer);

            // Create the elements
            for(var i=this.startDateCalculated; i<this.endDateCalculated; i+=this.timelineStep) {
                var bce_separator = "";
                if(i+this.timelineStep == 0)
                    bce_separator = " bce_separator";

                var yearGroup = new Element('div', {
                    'class': 'year-division-item'+bce_separator,
                    'data-year': i,
                    styles: {
                        width: this.yearWidth - this.options.border,
                    },
                }).inject(yearContainer);
            }

            // Create last element
            var yearGroup = new Element('div', {
                'class': 'year-division-item no-border',
                // honored end date
                'data-year': this.options.end,
                styles: {
                    width: 1,
                },
            }).inject(yearContainer);

            // Update yearContainer width
            yearContainer.setStyle('width', this.timelineWidth);
        }
    },

    /*
     *  renderEvents - Creates the events and place them into the timeline
     */
     renderEvents: function() {
        var that = this;

        // Remove previous events
        $$('.event-point').destroy();
        $$('.event-line').destroy();
        $$('.event-info').destroy();

        // Render the events for the first timeline
        if(typeof this.options.data[0] != 'undefined' && this.options.data[0] != null) {
            var height = 5;
            this.options.data[0].each(function(item, i) {
                //console.log(item);
                var event_height = that.renderSingleEvent(that.timeline1, item, i, height);
                if(event_height) height += event_height + 20;
            });
            // Resize Year divisions to cover all the events
            this.timeline1.getElements('.year-division-item').setStyle('height', height + 41);
            this.timeline1.getElements('.year-container').setStyle('height', height + 41);
        }

        // Render the events for the second timeline
        if(! this.options.singleMap && typeof this.options.data[1] != 'undefined') {
            var height = 5;
            this.options.data[1].each(function(item, i) {
                var event_height = that.renderSingleEvent(that.timeline2, item, i, height);
                if(event_height) height += event_height + 20;
            });
            // Resize Year divisions to cover all the events
            this.timeline2.getElements('.year-division-item').setStyle('height', height + 41);
            this.timeline2.getElements('.year-container').setStyle('height', height + 41);
        }
     },

     /*
      *  renderSingleEvent - Renders an Event element
      */
     renderSingleEvent: function(timeline, event, index, top_position) {
        var that = this;
        that.lastItem= $$(".year-container")[0].getLast(".year-division-item:not(.no-border)");

        // Calculate the division and position of the event
        //var top_position = (index * 40) + 5;

        //var start_division = Math.floor(event['Start Year'] / this.timelineStep) * this.timelineStep;

        var start_division = this.getDivision(event['Start Year']);
        //console.log(event, start_division);
        if(start_division == that.lastItem.get("data-year")) {
            var lastTimelineStep = $$(".no-border")[0].get("data-year") - that.lastItem.get("data-year");
            var start_position = (event['Start Year'] - start_division) * this.yearWidth / lastTimelineStep -6;
        }
        else {
            var start_position = (event['Start Year'] - start_division) * this.yearWidth / this.timelineStep -6;
        }
        //console.log(start_position, timeline.getElements('[data-year="'+start_division+'"]'));


        if(typeof timeline.getElements('[data-year="'+start_division+'"]')[0] == 'undefined')
            return;

        // Place start date
        new Element('div', {
            'class': 'event-point',
            styles: {
                'background-color': event['Color']?"#"+event['Color']:"#53585f",
                'top': top_position,
                'left': start_position
            },
        }).inject(timeline.getElements('[data-year="'+start_division+'"]')[0]);

        var personName = event['Event'].replace(/(<p>|<\/p>)/g, "").trim();
        var personId = encodeURIComponent(personName) + event['Start Year']+ event['End Year'];
        // Place the info
        var event_info = new Element('div', {
            'class': 'event-info',
            tabindex: event['Popup'] ? '-1' : '0',
            role: 'group',
            styles: {
                'top': top_position - 4,
                'left': start_position + 15
            },
        }).inject(timeline.getElements('[data-year="'+start_division+'"]')[0]);

        var event_info_label = new Element('div', {
            'html': this.convertToHTML(event['Event'])
        }).inject(event_info);

        var title = Math.abs(event['Start Year']);

        if(event['Start Year'] < 0)
            title += '<sub>BCE</sub>';

        var event_info_title = new Element('div.event-info__year', {
            'html': title,
        }).inject(event_info, 'top');

        // Place end date(s)
        if(this.options.date_ranges) {
            if (event['End Year']) {
                var end_dates = event['End Year'].split('|').filter(Boolean);

                end_dates.each(function(year, i) {
                    var end_division = that.getDivision(year);


                    if(end_division == that.lastItem.get("data-year")) {
                        var lastTimelineStep = $$(".no-border")[0].get("data-year") - that.lastItem.get("data-year");
                        var end_position = (year - end_division) * that.yearWidth / lastTimelineStep - 6;
                    }
                    else {
                        var end_position = (year - end_division) * that.yearWidth / that.timelineStep - 6;
                    }


                    if(i == 0) {
                        event_info.setStyle('top', top_position + 10);
                        title = " - "+Math.abs(year);
                        if(year < 0)
                            title += '<sub>BCE</sub>';
                        event_info_title.set('html',event_info_title.get('html')+title);
                    } else {
                        title = "/"+Math.abs(year);
                        if(year < 0)
                            title += '<sub>BCE</sub>';
                        event_info_title.set('html',event_info_title.get('html')+title);
                    }

                    if(i == end_dates.length -1 && typeof timeline.getElements('[data-year="'+end_division+'"]')[0] != 'undefined') {
                        new Element('div', {
                            'class': 'event-point',
                            styles: {
                                'background-color': event['Color']?"#"+event['Color']:"#53585f",
                                'top': top_position,
                                'left': end_position
                            },
                        }).inject(timeline.getElements('[data-year="'+end_division+'"]')[0]);
                    }

                    // Calculate the width of the line
                    var start_point = (start_division - that.options.start)/that.timelineStep*that.yearWidth + start_position;
                    var end_point = (end_division - that.options.start)/that.timelineStep*that.yearWidth + end_position;
                    var line_width = end_point - start_point;

                    if(typeof timeline.getElements('[data-year="'+start_division+'"]')[0] != 'undefined') {
                        new Element('div', {
                            'class': 'event-line',
                            styles: {
                                'border-color': event['Color']?"#"+event['Color']:"#53585f",
                                'border-style': (i==0)?"solid":"dashed",
                                'top': top_position + 5,
                                'left': start_position,
                                'width': line_width
                            },
                        }).inject(timeline.getElements('[data-year="'+start_division+'"]')[0]);
                    }

                    start_division = end_division;
                    start_position = end_position;
                });
            }
        }

        if(event['Popup']) {
            var pEl = event_info_label.getChildren('p')[0];

            if (!pEl) {
                event_info_label.innerHTML = '<p>' + event_info_label.innerHTML + '</p>';
            }

            var handlePopUp = function (e){
                document.lastTimeLineItemPressed = e.target;

              // var wasTabPresssed = e.code == 9 || e.which == 9 || e.keyCode == 9;
              // var wasEscapePressed = e.code == 27 || e.which == 27 || e.keyCode == 27;
              var wasEnterPressed = e.code == 13 || e.which == 13 || e.keyCode == 13;
              var wasSpacePressed = e.code == 32 || e.which == 32 || e.keyCode == 32;

              if ((e.type == "keydown" && (wasEnterPressed || wasSpacePressed)) || e.type == "click" || e.type == "touchstart") {

                  if($$(".timeline")[0].getHeight() > 450) {
                      var _max_height = $$(".timeline")[0].getHeight() - $$(".year-scale-container")[0].getHeight() - 30 - 10 - 40;
                  }
                  else {
                      var _max_height = 450 - $$(".year-scale-container")[0].getHeight() - 30 - 10 - 40;
                  }

                  var popupId = personId + 'popup';
                  e.stopPropagation();
                  that.windowDiv.setStyle("height", "");
                  that.windowDiv.setStyle("max-height", _max_height);
                  that.windowDiv.set('html','<div id=' + popupId + ' class="popup-inner">'+that.convertToHTML(that.convertToHTML(event['Popup']))+'</div>');

                  var closeButton = new Element('button', {
                      text : "×",
                      class: "close-popup",
                      'aria-label':"Close",
                      events : {
                          keypress: function (e) {
                              var wasTabPresssed = e.code == 9 || e.which == 9 || e.keyCode == 9;
                              if (wasTabPresssed) return;
                              that.hidePopup();
                              document.lastTimeLineItemPressed.focus()
                          },

                          click: function (e) {
                              that.hidePopup();
                              document.lastTimeLineItemPressed.focus()
                          }
                      }
                  });



                  that.windowDiv.set('aria-describedby', popupId);
                  that.windowDiv.getElements('.popup-inner').setStyle("max-height", _max_height);
                  that.windowDiv.setStyle("visibility", "hidden");
                  that.windowDiv.show();



                  // Calculate popup position
                  var left = e.page.x;
                  var top = e.page.y;

                  if(that.windowDiv.getElement("img")){
                      var _images_array = that.windowDiv.getElements("img").map(function(img){
                          if(typeof accessibility_data !== 'undefined'){
                              Array.each(accessibility_data.images, function (item) {
                                  var src = img.get('src');
                                  var n = src.lastIndexOf('/');
                                  var final_src = src.substring(n + 1);
                                  if(item.src == final_src) {
                                      img.set("alt",item.alt);
                                  }
                              });
                          }
                          return img.get("src");
                      });

                      Asset.images(_images_array,{
                          onProgress:function(counter, index, source){
                              var _img = $$("img[src='"+source+"']")[0];
                              if(_img.getWidth() > that.windowDiv.getWidth() || _img.getHeight() > that.windowDiv.getHeight()) {
                                  if(_img.getWidth()>_img.getHeight()){
                                      _img.addClass("portrait");
                                  }
                                  else{
                                      _img.addClass("landscape");
                                  }
                              }
                          },
                          onComplete: displayPopup
                      });
                  }


                  if (!that.windowDiv.getElement("img")) {
                      displayPopup();
                  }

                  function displayPopup () {
                      that.hidePopup();
                      that.windowDiv.setStyle('display', '');

                      setTimeout(function () {
                          closeButton.inject(that.windowDiv);

                          that.setPopupPosition(left, top);
                          that.windowDiv.setStyle("visibility", "visible");

                          setTimeout(function(){
                              $$('.popup-inner')[0].set('tabindex',-1).focus();
                          }, 0);

                          try{
                              document.dispatchEvent(document.resizePopUp);
                          } catch(e){
                              console.log('no mobile');
                          }
                      }, 0);
                  }
              }
            };

            new Element('p.visually-hidden', {
                id: personId,
                html: event_info_title.textContent + ', ' + event_info_label.getChildren('p')[0].textContent
            }).inject(event_info_label);

            new Element('span.icon', {
                tabindex: 0,
                role: 'button',
                'aria-describedby': personId,
                events: {
                    click: handlePopUp,
                    touchstart: handlePopUp,
                    // keypress: handlePopUp,
                    keydown: handlePopUp
                }
            })
              .adopt(new Element('span.visually-hidden',{
              html: 'event icon image'
            }))
              .inject(event_info_label);
        }

        return event_info.clientHeight;
     },

    hidePopup: function () {
        this.windowDiv.setStyle('width', '');
        this.windowDiv.setStyle('max-width', '');
        this.windowDiv.setStyle('visibility', 'hidden');
        this.windowDiv.setStyle('left', '');
        this.windowDiv.setStyle('top', '');
        this.windowDiv.hide();
    },

    /**
     * update popup position
     * @param  {Number} left - button page position
     * @param  {Number} top - button page position
     */
    setPopupPosition: function (left, top) {
        var popupSize = this.windowDiv.getSize();
        var timelineContainerSize = this.timelineContainer.getSize();

        if (popupSize.x + left > timelineContainerSize.x) {
            left = timelineContainerSize.x - popupSize.x - 10;
        }

        if (popupSize.y + top > timelineContainerSize.y) {
            top = timelineContainerSize.y - popupSize.y - 60;
        }

        if (!left) left = 20;
        if (!top) top = 20;

        this.windowDiv.setStyle('left', left);
        this.windowDiv.setStyle('max-width', timelineContainerSize.x - left - 10);
        this.windowDiv.setStyle('top', top);
    },

     /**
      * getDivision - Gets the division a date is in
      */
     getDivision: function(year) {
        for(var i=this.startDateCalculated; i<=this.endDateCalculated; i+=this.timelineStep) {
            if(year >= i && year < i+this.timelineStep) {
                return i;
            }
        }
        return false;
     },

    /*
     *  renderYearSlider - Creates the slider at the bottom of the widget to
     *  select the visible range of years
     */
    renderYearSlider: function(force_reload) {
        var that = this;
        this.sliderContainer.empty();

        // Create year Scale
        var scale = new Element('ul', {
            'class': 'year-slider-scale',
        }).inject(this.sliderContainer);

        // Get the sacle item width
        var scaleItemWidth = Math.floor(this.sliderContainer.getSize().x/Math.round(this.yearCount/this.sliderStep+1));
        var count = 0;
        for(var i=0; i<=this.yearCount; i+=this.sliderStep) {
            count++;
            var label = Math.abs(this.startDateCalculated+i);

            if(count==parseInt(($$(".year-slider-container")[0].getSize().x)/scaleItemWidth) || count==(parseInt(($$(".year-slider-container")[0].getSize().x)/scaleItemWidth)-1)) {
                if(Math.abs(this.startDateCalculated+i) > this.endDateCalculated) {
                    label = this.endDateCalculated;
                }
                else if(Math.abs(this.startDateCalculated+i)+this.sliderStep > this.endDateCalculated) {
                    if(count==parseInt(($$(".year-slider-container")[0].getSize().x)/scaleItemWidth)){
                        label = this.endDateCalculated;
                    }
                }
                else {
                    label = label;
                }
            }

            if (i + this.sliderStep > this.yearCount) {
                // honored end date
                label = this.options.end
            }

            if(this.startDateCalculated < 0) {
                if(i == 0) label += " BCE";
                else if(this.startDateCalculated+i==this.endDateCalculated) {
                    if(this.startDateCalculated+i < 0)
                        label += " BCE";
                    else if(this.startDateCalculated+i > 0)
                        label += " CE";
                }
                if(this.startDateCalculated+i == 0)
                    label = "BCE <> CE";
            }
            new Element('li', {
                'class': 'year-slider-item',
                html: '<span>'+label+'</span>',
                styles: {
                    width: scaleItemWidth,
                },
            }).inject(scale);
        }

        // Create Year Slider
        new Element('div', {
            id: 'year-slider',
            html: '<div></div><span></span><div></div>',
            styles: {
                'width': this.sliderContainer.getSize().x - scaleItemWidth + 15,
                'margin-left': scaleItemWidth/2,
            },
        }).inject(this.sliderContainer);

        var steps = (this.sliderStep < 1)?null:Math.round(this.yearCount/this.sliderStep)*10;

        this.slider = new DoubleSlider('year-slider', {
            onChange: function(firstValue, secondValue){
                if(!that.scrolling) {
                    that.rangeStart = firstValue;
                    that.rangeEnd = secondValue;
                    that.renderTimelines(force_reload);
                }
            },
            // honored end date
            range: [this.startDateCalculated, this.rangeEnd],
            start: [this.rangeStart, this.rangeEnd],
            steps: steps + 1
        });
    },

    /*
     *  renderTimelines - Renders the thimelines
     */
    renderTimelines: function(force_reload) {
        // Create the scale
        var that = this
        this.createScale(force_reload);
        setTimeout(function(){
            var latestScrollPosition = that.timeline1Scroll.element.scrollTop;
            // Create the timelines
            that.createTimeline(that.timeline1, force_reload);

            //Calculate the scroll point
            var diff = that.rangeStart - that.startDateCalculated;
            var scrollTo = Math.floor(that.yearWidth * diff/that.timelineStep);

            // Scroll first timeline to start year
            that.timeline1Scroll.set(scrollTo, 0);
            if(! that.options.singleMap) {
                that.createTimeline(that.timeline2, force_reload);

                // Scroll second timeline to start year
                that.timeline2Scroll.set(scrollTo, latestScrollPosition);
            }

            // Render the events
            that.renderEvents();

            // Scroll first timeline to start year
            that.timeline1Scroll.set(scrollTo, latestScrollPosition);
            // Scroll scale to start year
            that.ScaleScroll.set(scrollTo, 0);
        },0)
    },

    convertToHTML: function(content) {
        var pattern, re;
        //replace html to safe text for input
        pattern = '&quot;';
        re = new RegExp(pattern, "g");
        content = content.replace(re, '"');

        pattern = '&amp;';
        re = new RegExp(pattern, "g");
        content = content.replace(re, '&');

        pattern = "&#039;";
        re = new RegExp(pattern, "g");
        content = content.replace(re, "'");

        pattern = '&lt;';
        re = new RegExp(pattern, "g");
        content = content.replace(re, '<');

        pattern = '&gt;';
        re = new RegExp(pattern, "g");
        content = content.replace(re, '>');

        return content;
    }
});

function isTouchDevice(){
    try{
        document.createEvent("TouchEvent");
        return true;
    }catch(e){
        return false;
    }
}

function touchScroll(id){
    if(isTouchDevice()){ //if touch events exist...
        var el=document.getElementById(id);
        var scrollStartPos=0;

        document.getElementById(id).addEventListener("touchstart", function(event) {
            scrollStartPos=this.scrollTop+event.touches[0].pageY;
            event.preventDefault();
        },false);

        document.getElementById(id).addEventListener("touchmove", function(event) {
            this.scrollTop=scrollStartPos-event.touches[0].pageY;
            event.preventDefault();
        },false);
    }
}
