/**
 * Created by alexissaransig on 12/4/14.
 */
ToggleMap = new Class({
    Implements: [Options, Events],
    Extends: RouteMap,

    options: {
        duration: 1800
    },

    paths: [],
    position_map: [],

    ready: false,
    map_type: 'main',

    maps: {
        main: null,
        zoom: null
    },

    initialize: function (options) {
        var _this = this;
        this.parent(options);

        this.initializePaths();
        this.initializePanZoom();
        this.addMaps();
        this.container.getElements(".map-key li input.map-layer-trigger")
            .addEvent("change", function () {
                var map_layer = _this.container.getElement("#" + this.get("data-layer"));
                var map_svg=  this.get("data-svg");
                if (this.get("checked")) {
                    map_layer.show();
                    if(map_svg != null && map_svg != undefined)
                        _this.showSVG(map_svg);
                }
                else {
                    map_layer.hide();
                    _this.hideGroupElements(map_svg);
                }
            });
        console.log(this.container.getElements(".map-key li input.map-layer-trigger[initial-checked]").length);
        if(this.container.getElements(".map-key li input.map-layer-trigger[initial-checked]").length>0){
            this.container.getElements(".map-key li input.map-layer-trigger[initial-checked]").each(function(el){
                el.fireEvent("change");
            });
        }
        var checks = this.container.getElements(".map-key li input.map-layer-trigger");
        setTimeout(function () {
            Array.each(checks, function (el) {
            })
        }, 10);
        this.hideGroupElements('all');
    },
    addMaps: function () {
        var _this = this;
        var maps = this.options.data;

        var maps_wrapper = $$('.map-main .maps')[0];
        var check_wrapper = $$('.map-key')[0];
        Array.each(maps.static.back, function (img) {
            el = new Element('div.map-layer.visible').inject(maps_wrapper);
            $$(el).setStyle('background-image', 'url("images/' + img + '")');
        });


        Array.each(maps.dynamic, function (inf, ind) {
            el = new Element('div.map-layer', {
                id: '_' + ind
            }).inject(maps_wrapper);

            if(inf.img && inf.img != '' && inf.img != undefined && inf.img != null){
                $$(el).setStyle('background-image', 'url("images/' + inf.img + '")');
            }else{
                $$(el).setStyle('background-image', 'transparent');
            }


            li = new Element('li').inject(check_wrapper);

            is_disabled = false;
            if(inf.static){
                is_disabled = true;
            }
            
            var inputtrigger = new Element('input.map-layer-trigger', {
                type: 'checkbox',
                'data-layer': '_' + ind,
                'data-svg': inf.svg,
                id: 'c_' + ind,
                disabled: is_disabled,
                //checked:checked?"checked":""
            });
            if(inf.checked){
                inputtrigger.set("checked","checked");
                inputtrigger.set("initial-checked","true");
                
            }
            inputtrigger.inject(li);
            lab = new Element('label', {
                for: 'c_' + ind
            }).inject(li);
            new Element('div', {
                'tab-index': 0,
                html: inf.title
            }).inject(lab);
            sp = new Element('span.color', {id: 'color_' + ind}).inject(lab);
            $$(sp).setStyle('background', inf.color);
        });


        Array.each(maps.static.front, function (img) {
            el = new Element('div.map-layer.visible').inject(maps_wrapper);
            $$(el).setStyle('background-image', 'url("images/' + img + '")');
        });

        wid = $$(check_wrapper)[0].getSize().x;
        $$(check_wrapper).setStyle('width', (wid + 20) + 'px');
    },
    showSVG: function (group) {
        var path_element, totalLength,
            _this = this,
            groups = [];
        var path = d3.selectAll('#' + group + ' path:not(.tip):not(.dashed), #' + group + ' line');

        path_element = $$('#' + group + ' path:not(.tip), #' + group + ' line');
        path_element.show();

        totalLength = 2.75 * 2000 * .2;
        path
            .attr("stroke-dasharray", totalLength + " " + totalLength)
            .attr("stroke-dashoffset", totalLength)
            .transition()
            .duration(3500)
            .ease("linear")
            .attr("stroke-dashoffset", 0);
        setTimeout(function(){
            _this.showGroupElements(group);
        }, 1400);
    },
    showGroupElements: function (group) {
        $$('#' + group + ' polygon, #' + group + ' text, #' + group + ' line, #' + group + ' circle, #' + group + ' polyline').show();
    },
    hideGroupElements: function (group) {
        if(group == 'all'){
            $$('polygon,  text,  line, path, circle, polyline' ).hide();
        }else{
            $$('#' + group + ' polygon, #' + group + ' text, #' + group + ' line, #' + group + ' path' ).hide();
        }
    }
});