/**
 * 3rd Party Integration Inline
 * @author: Marcelo Aguilera
 */

TPInline = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    options: {
    },
    saveURL: function (e) {
        var _this = this;
        var editorFrame = window.parent.$("iframe#widget-edit-container")
        
        editorFrame.attr('data-url', _this.container.getElement("#TPI_url").get("value"))
        _this.options.data = { url: _this.container.getElement("#TPI_url").get("value")};
        this.saveRequest({method: 'mdData', options: {'json': this.options.data}});

        //save url to DB widget code field
        if (parent && parent != window) {
            parent.postMessage({
                method: 'save-3PI-url',
                url: _this.container.getElement("#TPI_url").get("value")
            }, '*');
        }
    },
    generateDom: function () {
        _this = this;
        var editorFrame = window.parent.$("iframe#widget-edit-container")

        $("widget-preview-container").hide();
        _this.container.getElement(".feedback-message").hide();
        if(_this.options.data.url && _this.options.data.url !=""){
            _this.container.getElement("#TPI_url").set("value",_this.options.data.url)
        }
        if (!this.isEditMode) {
            $("widget-edit-container").hide();
            $("widget-preview-container").show();
            if(_this.options.data.url && _this.options.data.url !=""){
                _this.container.getElement("#TPI_frame").set("src",_this.options.data.url)
            }
        } else {
            editorFrame.attr('data-url', _this.options.data.url)
        }
    },
    updateContainerHeight: function(){
        $$('.widget-body')[0].setStyle('height', 'calc( 100vh');
    },
    initialize: function (options) {
        var _this = this;
        this.parent(options);
        this.generateDom();
        if (this.isEditMode) {
            this.updateContainerHeight();
            _this.container.addClass("edit-mode")
        }
        this.container.getElement(".submitbutton").addEvent('click', function (item) {
             if(_this.container.getElement("#TPI_url").get("value")!=""){
                _this.saveURL();
                _this.showFeedbakMessage("URL loaded successfully.","correct");
             }else{
                _this.showFeedbakMessage("Please enter a URL.","incorrect");
                if(_this.options.data.url && _this.options.data.url !=""){
                    _this.container.getElement("#TPI_url").set("value",_this.options.data.url)
                }
             }
        });
    },
    showFeedbakMessage:function(message,type) {
        var _this = this;
        _this.container.getElement(".feedback-message").set("html",message);
        _this.container.getElement(".feedback-message").addClass(type);
        _this.container.getElement(".feedback-message").show();
        setTimeout(function(){
            _this.container.getElement(".feedback-message").set("html","");
            _this.container.getElement(".feedback-message").removeClass(type);
            _this.container.getElement(".feedback-message").hide();
        }, 3000);
    },
    customPostMessages:function(message,path) {
        var _this = this;

        switch(message.data.method){
            case "view-mode-switch":
                break;
        }

    }
});