TruthTable = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,

    // Set initial options here
    options: {

    },

    // initialize - widget initialization
    initialize: function(options) {
        this.tableHeaders = options.data.headers;
        this.tableWidths = options.data.widths;
        this.tableData = options.data.table;

        // widget init
        this.parent(options);

        // DOM elements
        this.btnReset = this.options.container.getElement('.btn-reset');
        this.btnCheckAnswers = this.options.container.getElement('.btn-checkanswers');
        this.btnCheckAgain = this.options.container.getElement('.btn-checkagain');
        this.feedbackText = this.options.container.getElement('.feedback');

        // events
        this.btnReset.addEvent(this.clickEvent, this.btnResetHandler.bind(this));
        this.btnCheckAnswers.addEvent(this.clickEvent, this.btnCheckAnswersHandler.bind(this));
        this.btnCheckAgain.addEvent(this.clickEvent, this.btnCheckAgainHandler.bind(this));
        this.options.container.getElements('.circle-answer').addEvent(this.clickEvent, this.radioBtnsHandler.bind(this));
        
        // init
        this.btnReset.hide();
        this.btnCheckAgain.hide();
        this.btnCheckAnswers.setAttribute('disabled', 'disabled');
        this.totalQuestions = this.container.getElements('.question').length;

        this.enableAccessibility();
    },
    enableAccessibility: function() {
        var cont = 1;
        var row = 1;
        var headers = this.tableHeaders;

        $$('.truth-table td:not(.question)').each(function(e){
            e.set("aria-label","Row "+row+", column "+cont+" with "+headers[cont-1].headerLabel+" header");
            if(cont==headers.length){
                cont=0;
                row++;
            }
            cont++;
        });
    },
    radioBtnsHandler: function(e){
        e.target.parentNode.getElements(".circle-answer").removeClass("answered");
        e.target.addClass("answered");
        var i;

        for (i = 0; i < e.target.parentNode.getElements(".circle-answer").length; i += 1){
           e.target.parentNode.getElements(".circle-answer")[i].setAttribute("aria-checked", false);
        }
        e.target.setAttribute("aria-checked", true);

        e.preventDefault();

        if (e.target.parentNode.hasClass("incorrect")) {
            this.options.container.getElements(".question").removeClass("correct").removeClass("incorrect");
            this.options.container.getElements(".circle-answer").show();
            this.options.container.getElements(".check-answer").set("html", "");
            this.options.container.getElements(".feedback").set("html", "");
        }
        if (this.options.container.getElements('.answered').length == this.totalQuestions){
            this.btnCheckAnswers.removeProperty('disabled');   
            this.btnCheckAgain.removeProperty('disabled');
            this.btnCheckAnswers.focus();     
        }
    },

    btnResetHandler: function(e) {
        $$(".feedback")[0].set("html","");
        $$(".reset-msg")[0].hide();
        $$(".reset-msg-perfect")[0].hide();
        this.options.container.getElements(".question").removeClass("correct").removeClass("incorrect");
        this.options.container.getElements(".circle-answer").removeClass("answered").show();
        this.options.container.getElements(".circle-answer").set("aria-label", "");
        this.options.container.getElements(".check-answer").set("html", "");
        this.options.container.getElements(".feedback").set("html", "");
        this.options.container.getElements(".reset-msg").hide();
        this.options.container.getElements(".reset-msg-perfect").hide();
        this.btnCheckAnswers.setAttribute('disabled', 'disabled');
        this.btnCheckAnswers.show();
        this.btnReset.hide();
        this.btnCheckAgain.hide(); 
    },

    btnCheckAnswersHandler: function(e) {
        this.checkAnswers();
    },

    btnCheckAgainHandler: function(e) {
        this.checkAnswers();
    },

    checkAnswers: function () {
        var correctAnswer = 0;
        this.options.container.getElements(".question").each(function(q) {
            if (q.getAttribute("data-answer") == q.getElement(".answered").get('html')) {
                q.getElements(".circle-answer").each(function(item) {
                    if (!item.hasClass("answered")) {
                        item.hide();
                    }
                });
                q.addClass("correct");
                q.setAttribute("aria-label", "Correct answer");
                q.getElement(".check-answer").set("html", "<div class='img-quiz-check-mark'></div>");
                correctAnswer++;
            }
            else {
                q.addClass("incorrect");
                q.setAttribute("aria-label", "Incorrect answer");
                q.getElement(".check-answer").set("html", "<div class='img-quiz-x-mark'></div>");
            }
        });
        var feedback = "You completed the challenge. You got " + correctAnswer + " out of " + this.totalQuestions + " correct.";

        this.options.container.getElements(".feedback").set("html", feedback);
        if (correctAnswer == this.totalQuestions) { 
            this.options.container.getElements(".reset-msg-perfect").show();
            this.options.container.getElements(".reset-msg").hide();
        } else {
            this.options.container.getElements(".reset-msg").show();
            this.options.container.getElements(".reset-msg-perfect").hide();
        }
        this.btnCheckAnswers.hide();
        this.btnReset.show();
        this.btnCheckAgain.show();
        this.btnCheckAgain.setAttribute('disabled', 'disabled');
    },

    createDOM: function() {
        var row, rowData;
        this.thead = new Element('thead').inject(this.options.container.getElement('.widget-body table.truth-table'));
        this.tbody = new Element('tbody').inject(this.options.container.getElement('.widget-body table.truth-table'));

        row = new Element('tr').inject(this.thead);
        for (var i = 0; i < this.tableHeaders.length; i++) {
            new Element('th', {
                class: i > 1 ? 'lighter '+this.tableWidths[i] : this.tableWidths[i],
                html: this.tableHeaders[i].headerText,
                'aria-label': this.tableHeaders[i].headerLabel,
                'aria-hidden' : true
            }).inject(row);
        }
        for (var i = 0; i < this.tableData.length; i++) {
            row = new Element('tr', {
                'data-id': i,
            }).inject(this.tbody);
            for (var j = 0; j < this.tableData[i].length; j++) {
                if (this.options.data.answer_columns.indexOf(j) >= 0) {
                    new Element('td', {
                        'data-answer': this.tableData[i][j],
                        class: 'question',
                        html: this.getAnswerButtons(j)
                    }).inject(row);
                }
                else {
                    new Element('td', {
                        html: '<span>' + this.tableData[i][j] + '</span>'
                    }).inject(row);
                }
            };
        };
    },

    getAnswerButtons: function(index) {
        var buttonT = new Element('button', {
            tabindex: 0, 
            'aria-label': "indicate " + this.tableHeaders[index].headerLabel + " is true",
            role: 'radio',
            class: 'circle-answer circle-answer-0',
            html: 'T'
        });
        var buttonF = new Element('button', {
            tabindex: 0,
            'aria-label': "indicate " + this.tableHeaders[index].headerLabel + " is false",
            role: 'radio',
            class: 'circle-answer circle-answer-1',
            html: 'F'
        });
        return '<div role="radiogroup"></div>' + buttonT.outerHTML + buttonF.outerHTML + '<div class="check-answer"></div>';

    }
    
});