CustomWidget = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    options: {
    },
    initialize: function(options) {
        this.parent(options);
        this.video_url = options.video_url;
        this.render();

    },
    render: function() {
        var _this = this;
        this.parent();

        var c_l = this.options.container.getElement('.column-left');
        var p_w = this.options.container.getElement('.panel-wrapper');

        this.options.data.each(function(e, i) {

            var step = new Element('div.step.step-' + i).inject(c_l);
            if (e.title != '') {
                new Element('strong.purple', {html: '' + e.title}).inject(step);

                new Element('div.clickable.option.step.step-' + i, {
                    html: '<strong class="purple">' + e.title + '</strong><p>' + e.description.substring(0, 27) + '...</p>',
                    'tabindex': 0,
                    'data-id': i
                }).inject(p_w);
            }
            new Element('p.m-left-' + e.level, {html: '' + e.description}).inject(step);
        });

        this.options.container.getElement('.start').addEvent('click', function() {
            _this.options.container.getElement('.section-1').hide();
            _this.options.container.getElement('.section-2').show();
            $$('.column-left')[0].focus();
        });

        //----------------SCROLLING
        this.scroll = new Fx.Scroll($$('.column-left')[0], {
            wait: false,
            duration: 800,
            offset: {'x': -200, 'y': -20},
            transition: Fx.Transitions.Quad.easeInOut
        });

        //----------------PANEL
        this.options.container.getElements('.option.clickable').addEvents({
            'click': function() {
                _this.currentOpt = this.getAttribute('data-id').toInt() - 1;
                _this.nextVideo();
            },
            'keypress': function(e) {
                if (e.code === 13 || e.code === 32)
                    this.fireEvent("click");
            }
        });
        //----------------VIDEO PLAYER   
        this.currentOpt = 0;

        this.video = this.options.container.getElement('video');

        this.options.container.getElement('.play').addEvent('click', function() {
            if (_this.video.get('src') == '' || _this.video.get('src') == null)
                _this.nextVideo();
            else
                _this.video.play();
        });
        this.options.container.getElement('.pause').addEvent('click', function() {
            _this.video.pause();
        });
        this.options.container.getElement('.stop').addEvent('click', function() {
            _this.video.load();
        });
        this.options.container.getElement('.next').addEvent('click', function() {
            _this.nextVideo();
        });
        this.options.container.getElement('.previous').addEvent('click', function() {
            _this.previousVideo();
        });
        this.playAll = false;
        this.options.container.getElement('input[type="radio"]').addEvents({
            'click': function() {
                if (_this.playAll) {
                    this.set('checked', false);
                    _this.playAll = false;
                } else {
                    this.set('checked', true);
                    _this.playAll = true;
                }
            },
            'keypress': function(e) {
                if (e.code === 13 || e.code === 32)
                    this.fireEvent("click");
            }
        });

        this.video.set('src', this.video_url + '' + this.options.data[0].video);
        this.video.load();
        this.options.container.getElements('.highlighted').removeClass('highlighted');
        this.options.container.getElements('.step-' + this.currentOpt).addClass('highlighted');

        this.video.onended = function(e) {
            setTimeout(function() {
                if (_this.playAll) {
                    _this.nextVideo();
                }
            }, 1000);
        };
    },
    nextVideo: function() {
        var _this = this;

        this.currentOpt++;

        while (this.currentOpt <= this.options.data.length) {
            if (this.currentOpt >= this.options.data.length) {
                this.currentOpt = 0;
            }
            this.options.container.getElements('.highlighted').removeClass('highlighted');
            this.options.container.getElements('.step-' + this.currentOpt).addClass('highlighted');
            if (this.options.data[this.currentOpt].video !== '' && this.options.data[this.currentOpt].video !== undefined) {
                this.video.set('src', _this.video_url + '' + _this.options.data[_this.currentOpt].video);
                this.scroll.toElement($$('.step-' + this.currentOpt)[0]);
                break;
            }
            this.currentOpt++;
        }

        this.video.load();
        this.video.play();
    },
    previousVideo: function() {
        var _this = this;

        this.currentOpt--;

        while (this.currentOpt >= -1) {
            if (this.currentOpt < 0) {
                this.currentOpt = this.options.data.length - 1;
            }
            this.options.container.getElements('.highlighted').removeClass('highlighted');
            this.options.container.getElements('.step-' + this.currentOpt).addClass('highlighted');
            if (this.options.data[this.currentOpt].video !== '' && this.options.data[this.currentOpt].video !== undefined) {
                this.video.set('src', _this.video_url + '' + _this.options.data[_this.currentOpt].video);
                this.scroll.toElement($$('.step-' + this.currentOpt)[0]);
                break;
            }
            this.currentOpt--;
        }

        this.video.load();
        this.video.play();
    }
});