var Touch = new Class({

	Implements: Events,

	initialize: function(element){
		window.addEvent("mousemove",function(){
          document.getElement("body").addClass("remove-outline");
        })
        .addEvent("keyup",function(e){
            if(e.key=="tab"){
                document.getElement("body").removeClass("remove-outline");
            }
        });
        
        
		this.element = document.id(element);

		this.bound = {
			start: this.start.bind(this),
			move: this.move.bind(this),
			end: this.end.bind(this)
		};

		if (Browser.Platform.ipod){
			this.context = this.element;
			this.startEvent = 'touchstart';
			this.endEvent = 'touchend';
			this.moveEvent = 'touchmove';
		} else {
			this.context = document;
			this.startEvent = 'mousedown';
			this.endEvent = 'mouseup';
			this.moveEvent = 'mousemove';
		}

		this.attach();
	},

	// public methods

	attach: function(){
		this.element.addListener(this.startEvent, this.bound.start);
	},

	detach: function(){
		this.element.removeListener(this.startEvent, this.bound.start);
	},

	// protected methods

	start: function(event){
		this.preventDefault(event);
		// this prevents the copy-paste dialog to show up when dragging. it only affects mobile safari.
		document.body.style.WebkitUserSelect = 'none';

		this.hasDragged = false;

		this.context.addListener(this.moveEvent, this.bound.move);
		this.context.addListener(this.endEvent, this.bound.end);

		var page = this.getPage(event);

		this.startX = page.pageX;
		this.startY = page.pageY;

		this.fireEvent('start');
	},

	move: function(event){
		this.preventDefault(event);

		var page = this.getPage(event);

		this.deltaX = page.pageX - this.startX;
		this.deltaY = page.pageY - this.startY;

		this.hasDragged = !(this.deltaX === 0 && this.deltaY === 0);

		if (this.hasDragged) this.fireEvent('move', [this.deltaX, this.deltaY]);
	},

	end: function(event){
		this.preventDefault(event);
		// we re-enable the copy-paste dialog on drag end
		document.body.style.WebkitUserSelect = '';

		this.context.removeListener(this.moveEvent, this.bound.move);
		this.context.removeListener(this.endEvent, this.bound.end);

		this.fireEvent((this.hasDragged) ? 'end' : 'cancel');
	},

	preventDefault: function(event){
		if (event.preventDefault) event.preventDefault();
		else event.returnValue = false;
	},

	getPage: function(event){
		//when on mobile safari, the coordinates information is inside the targetTouches object
		if (event.targetTouches) event = event.targetTouches[0];
		if (event.pageX != null && event.pageY != null) return {pageX: event.pageX, pageY: event.pageY};
		var element = (!document.compatMode || document.compatMode == 'CSS1Compat') ? document.documentElement : document.body;
		return {pageX: event.clientX + element.scrollLeft, pageY: event.clientY + element.scrollTop};
	}

});

Touch.build = "%build%";








/*
---

script: SideBar.js

description: Provides the TOC UI.

requires:
 - Touch
 - Core/Fx
 - More/Assets
 - Behavior/Behavior
 - More/Object.Extras

provides: [TOC, TOC.Nav]

...
*/

var ThreeSixty = new Class({
	Implements: [Options, Events],
	Extends: MetrodigiWidget,
	options: {
		/*
			onProgress: function(percent, index, source){
				console.log('loaded ' + percent + '% index: ' + index);
			},
			ready: function(){
				//all images loaded
			},
			//if no image is defined as already in the DOM, one will be injected in the container
			image: elmentIdOrReference,
		*/
		images: {
			//how many images
			count: 72,
			//path to images with ## for number values; note that this is padded with a zero, so 01-09, 10, 11, etc
			path: 'images/Seq_v04_640x378_##.jpg'
		},
		//labels image
		labelImgSrc: 'images/labels.jpg',
		//when the user flicks, how many rotations can the thing go (maximum) before it stops
		maxFlickMultiplier: 1,
		//how far the flick has to be for there to be a transition at all on flick
		minFlick: 5,
		//the distance in pixels it takes to rotate the view; controls how "fast" it feels
		rotateDistance: 1000,
		//play the animation on startup?
		playIntro: true,
		//multiply the flick distance directly
		distanceMultiplier: 1,
		//invert drag
		invert: false,
		//Determine whether image is full 360 or not
		full360: true,
		//label image index
		labelImgIndex: 0
	},
	/*
		state variables
	*/
	//the current frame
	current: 0,
	//a history of positions, updated periodically; used to compute the "flick" velocity
	history: [0],
	//the position when a drag event starts
	dragStartPos: 0,
	//array of image sources for our animation (computed by computeSources method)
	sources: [],
	sourcesY: [],

	currentAxis: 'x',

	labelsShown: false,

	initialize: function(container, options){
		this.element = document.id(container);
		this.setOptions(options);
		this.attach();
		this.attachKeyboard();
		this.computeSources();
		this.makeImg();
		this.makeFx();
		this.preload();
		if (this.options.current) {
			this.show(this.options.current);
			if (this.options.current == this.options.labelImgIndex) {
				this.img.src = this.options.labelImgSrc;
				this.labelsShown = true;
				$$('.show-labels')[0].innerHTML = "Hide Labels";
			}
		}
	},
	//get a reference to or create an image for our animation
	makeImg: function(){
		if (this.options.image) this.img = document.id(this.options.image);
		if (!this.img){
			//create a new image and inject it in our target if there isn't one
			this.img = new Element('img', {
				src: this.sources[0]
			}).inject(this.element);
		}
	},
	makeFx: function(){
		//create an fx object for spinning
		this.fx = new Fx({
			transition: Fx.Transitions.Quad.easeOut,
			fps: 120
		});
		//define the set method for our Fx instance as rotating the image
		this.fx.set = function(i){
			this.show(i.round());
		}.bind(this);
	},
	//define the sources for all the images in the set; put them in this.sources array
	computeSources: function(){
		var path = this.options.images.path.split('##');
		this.options.images.count.times(function(i){
			this.sources.push(path[0] + this.pad(i + 1, 3) + path[1]);
		}, this);
		this.options.images.count.times(function(i){
			this.sourcesY.push(path[0] + this.pad(i + this.options.images.count + 1, 3) + path[1]);
		}, this);
	},
	//preload all the images before we run the animation
	preload: function(){
		Asset.images(this.sources, {
			onProgress: function(counter, index, source){
				this.fireEvent('progress', [((counter / this.options.images.count) * 100).round(), index, source])
			}.bind(this),
			onComplete: function(){
				this.fireEvent('ready');
				if (this.options.playIntro) this.intro();
			}.bind(this)
		})
	},
	//play the intro animation
	intro: function(){
		//play a little slower for the intro
		this.fx.options.duration = 1000;
		//start the animation
		this.fx.start(this.current, this.options.images.count).chain(function(){
			//when it finishes, put the duration back
			this.fx.options.duration = 500;
			//set the current frame
			this.current = this.options.images.count;
		}.bind(this));
	},
	//method to pad a number a given digits
	pad: function(n, digits){
	    var s = n+"";
	    while (s.length < digits) s = "0" + s;
	    return s;
	},
	//attach the drag event logic; uses Touch.js for this
	attach: function(){
		var _this = this;
		this.touch = new Touch(this.element).addEvents({
			start: this.startDrag.bind(this),
			end: this.endDrag.bind(this),
			move: this.drag.bind(this)
		});
		this.element.getNext().addEvent('click', function(e) {
			_this.toggleLabels();
			return false;
		})
	},
	//attach the keyboard events
	attachKeyboard: function() {
		$$('.view360')[0].addEvent('keydown', function(e) {
			var key = e.key ? e.key : e.code;
			switch (key) {
				case "left":
				case 37:
					this.keyboardDrag(-7, 0);
					return false;
					break;
				case "up":
				case 38:
					this.keyboardDrag(0, -7);
					return false;
					break;
				case "right":
				case 39:
					this.keyboardDrag(7, 0);
					return false;
					break;
				case "down":
				case 40:
					this.keyboardDrag(0, 7);
					return false;
					break;
			}
		}.bind(this));
		$$('.view360, .show-labels').set('tabindex', 0);
	},
	//fired when dragging starts
	startDrag: function(){
		this.axisLocked = false;

		//cancel any running effect (a flick or the intro)
		this.fx.cancel();
		//set the start position
		this.dragStartPos = this.current;
		//reset the history
		this.history.empty();
		this.dragOffset = 0;
		//push the location into the history every 15 ms; used to compute flick
		this.dragInterval = this.updateDragHistory.periodical(10, this);
		this.updateDragHistory();

		// labels are hidden automatically
		$$('.show-labels')[0].innerHTML = "Show Labels";
		this.labelsShown = false;
	},
	//updates the drag position in the history
	updateDragHistory: function(){
		//put the current position at the beginning
		this.history.unshift(this.dragOffset);
		//keep the array at 3 long for teh memories
		if (this.history.length > 3) this.history.pop();
	},
	//on drag end, clear the interval and fire the flick
	endDrag: function(){
		clearInterval(this.dragInterval);
		//get the distance moved from the history (30 ms ago)
		var flick = (this.history.getLast() - this.dragOffset);
		//get the size of the container
		var size = this.element.getSize().x;
		//rotate based on the relative size of the container,
		//i.e. if you moved 1x the size of the container in 30ms
		//rotate 1 full time. if you moved only .5x, rotate a half turn, etc.
		var rotation = (flick / size) * this.options.images.count;
		this.flick(rotation.round());
	},
	//drag handler; figures out rotation position based on drag offset
	//x = integer of drag offset
	drag: function(x, y){
		if (!this.axisLocked) {
			var page = this.touch.getPage(event);
			var deltaX = page.pageX - this.touch.startX;
			var deltaY = page.pageY - this.touch.startY;
			if (Math.abs(deltaX) > Math.abs(deltaY)) {
				this.currentAxis = 'x';
				this.axisLocked = true;
			}
			else {
				this.currentAxis = 'y';
				this.axisLocked = true;
			}
		}

		this.dragOffset = this.currentAxis == 'x' ? x : y;
		//compute the frame distance as the drag distance devided by the distance one must drag for a full rotation
		var percentDiffX = (this.currentAxis == 'x' ? x : y) / this.options.rotateDistance,
				//and the frame we're on is the image count times that percent offset
				frameDiffX = (this.options.images.count * percentDiffX).round();
		//now rotate the negative of that number, because in iOS we follow the finger, not the "scroll bar" as on the web
		this.rotate((this.options.invert ? -1 : 1) * frameDiffX);
	},
	//keyboard dragging
	keyboardDrag: function(x, y) {
		this.startDrag();
		this.currentAxis = x == 0 ? 'y' : 'x';
		this.dragOffset = this.currentAxis == 'x' ? x : y;
		var percentDiffX = (this.currentAxis == 'x' ? x : y) / this.options.rotateDistance,
			frameDiffX = (this.options.images.count * percentDiffX).round();
		this.rotate((this.options.invert ? -1 : 1) * frameDiffX);
	},
	//rotate the image by x frames
	rotate: function(offset){
		if(this.options.full360) {
			//compute the image index to display
			//get the offset from the start position and wrap it at the image count size
			var index = (offset + this.dragStartPos) % this.options.images.count;
			if (index < 0) index = this.options.images.count + index;
			this.show(index);
		} else {
			//Do not allow rotation
			var index = offset + this.dragStartPos;
			if(index >= 0 && index < this.options.images.count) {
				this.show(index);
			}
		}
		
	},
	show: function(index){
		//handle the possibility that something has gone wrong and we're trying to set an image source that isn't valid
		var sources = this.currentAxis == 'x' ? this.sources : this.sourcesY;
		if (sources[index]) {
			//set the image source
			this.img.src = sources[index];
			//update the current position
			this.current = index;
			this.fireEvent('changed', {'index': this.current});
		}
	},
	//animate the rotation a given distance (number of frames) by a factor of 2
	flick: function(distance){
		distance *= this.options.distanceMultiplier;
		//if it's not at least the minFlick value, exit
		if (distance.abs() < this.options.minFlick) return;
		//if it's greater than the maxFlickMultiplier * the image count, use that max value
		if (distance.abs() > this.options.maxFlickMultiplier * this.options.images.count) {
			distance = this.options.maxFlickMultiplier * this.options.images.count * (distance > 0 ? 1 : -1);
		}
		//if the distance value was postive, make the dist value negative to get the spin direction correct
		distance *= (this.options.invert ? 1 : -1);
		this.fx.start(this.current, this.current + distance);
	},
	//show labels
	toggleLabels: function() {
		this.labelsShown = !this.labelsShown;

		if (!this.labelsShown) {
			this.img.src = this.sources[this.current];
			$$('.show-labels')[0].innerHTML = "Show Labels";
			return false;
		}

		//start the animation
		if (this.currentAxis != 'x') {
			this.fx.options.duration = 500;
			this.fx.start(this.current, this.options.images.count).chain(function(){
				//when it finishes, put the duration back
				this.fx.options.duration = 500;
				//set the current frame
				this.current = this.options.labelImgIndex;
			}.bind(this));

			setTimeout(function() {
				this.currentAxis = 'x';
				this.show(0);
				this.fx.start(this.current, this.options.labelImgIndex).chain(function(){
					//when it finishes, put the duration back
					this.fx.options.duration = 500;
					//set the current frame
					this.current = this.options.labelImgIndex;
				}.bind(this));

				setTimeout(function() {
					this.img.src = this.options.labelImgSrc;
				}.bind(this), 1050);
			}.bind(this), 550);
		}
		else {
			//play a little slower for the intro
			this.fx.options.duration = 1000;
			this.fx.start(this.current, this.options.labelImgIndex).chain(function(){
				//when it finishes, put the duration back
				this.fx.options.duration = 500;
				//set the current frame
				this.current = this.options.labelImgIndex;
			}.bind(this));

			setTimeout(function() {
				this.img.src = this.options.labelImgSrc;
			}.bind(this), 1050);
		}

		setTimeout(function() {
			$$('.show-labels')[0].innerHTML = "Hide Labels";
		}.bind(this), 1050);
		return false;
	}
});

//some cross-lib compatibility; Touch.js and MooTools 1.3 aren't quite in sync
if (Browser.Platform.ios) Browser.Platform.ipod = true;
