var Touch = new Class({

	Implements: Events,

	initialize: function(element){
		window.addEvent("mousemove",function(){
          document.getElement("body").addClass("remove-outline");
        })
        .addEvent("keyup",function(e){
            if(e.key=="tab"){
                document.getElement("body").removeClass("remove-outline");
            }
        });
        
		this.element = document.id(element);

		this.bound = {
			start: this.start.bind(this),
			move: this.move.bind(this),
			end: this.end.bind(this)
		};

		if (Browser.Platform.ipod){
			this.context = this.element;
			this.startEvent = 'touchstart';
			this.endEvent = 'touchend';
			this.moveEvent = 'touchmove';
		} else {
			this.context = document;
			this.startEvent = 'mousedown';
			this.endEvent = 'mouseup';
			this.moveEvent = 'mousemove';
		}

		this.attach();
	},

	// public methods

	attach: function(){
		this.element.addListener(this.startEvent, this.bound.start);
	},

	detach: function(){
		this.element.removeListener(this.startEvent, this.bound.start);
	},

	// protected methods

	start: function(event){
		this.preventDefault(event);
		// this prevents the copy-paste dialog to show up when dragging. it only affects mobile safari.
		document.body.style.WebkitUserSelect = 'none';

		this.hasDragged = false;

		this.context.addListener(this.moveEvent, this.bound.move);
		this.context.addListener(this.endEvent, this.bound.end);

		var page = this.getPage(event);

		this.startX = page.pageX;
		this.startY = page.pageY;

		this.fireEvent('start');
	},

	move: function(event){
		this.preventDefault(event);

		var page = this.getPage(event);

		this.deltaX = page.pageX - this.startX;
		this.deltaY = page.pageY - this.startY;

		this.hasDragged = !(this.deltaX === 0 && this.deltaY === 0);

		if (this.hasDragged) this.fireEvent('move', [this.deltaX, this.deltaY]);
	},

	end: function(event){
		this.preventDefault(event);
		// we re-enable the copy-paste dialog on drag end
		document.body.style.WebkitUserSelect = '';

		this.context.removeListener(this.moveEvent, this.bound.move);
		this.context.removeListener(this.endEvent, this.bound.end);

		this.fireEvent((this.hasDragged) ? 'end' : 'cancel');
	},

	preventDefault: function(event){
		if (event.preventDefault) event.preventDefault();
		else event.returnValue = false;
	},

	getPage: function(event){
		//when on mobile safari, the coordinates information is inside the targetTouches object
		if (event.targetTouches) event = event.targetTouches[0];
		if (event.pageX != null && event.pageY != null) return {pageX: event.pageX, pageY: event.pageY};
		var element = (!document.compatMode || document.compatMode == 'CSS1Compat') ? document.documentElement : document.body;
		return {pageX: event.clientX + element.scrollLeft, pageY: event.clientY + element.scrollTop};
	}

});

Touch.build = "%build%";








/*
---

script: SideBar.js

description: Provides the TOC UI.

requires:
 - Touch
 - Core/Fx
 - More/Assets
 - Behavior/Behavior
 - More/Object.Extras

provides: [TOC, TOC.Nav]

...
*/

var ThreeSixty = new Class({
	Implements: [Options, Events],
	Extends: MetrodigiWidget,
	options: {
		/*
			onProgress: function(percent, index, source){
				console.log('loaded ' + percent + '% index: ' + index);
			},
			ready: function(){
				//all images loaded
			},
			//if no image is defined as already in the DOM, one will be injected in the container
			image: elmentIdOrReference,
		*/
		images: {
			//how many images
			count: 72,
			//path to images with ## for number values; note that this is padded with a zero, so 01-09, 10, 11, etc
			path: 'images/Seq_v04_640x378_##.jpg'
		},
		//labels image
		labelImgSrc: 'images/labels.jpg',
		//when the user flicks, how many rotations can the thing go (maximum) before it stops
		maxFlickMultiplier: 1,
		//how far the flick has to be for there to be a transition at all on flick
		minFlick: 5,
		//the distance in pixels it takes to rotate the view; controls how "fast" it feels
		rotateDistance: 1000,
		//play the animation on startup?
		playIntro: true,
		//multiply the flick distance directly
		distanceMultiplier: 1,
		//invert drag
		invert: false,
		//Determine whether image is full 360 or not
		full360: true,
		//label image index
		labelImgIndex: 0,
        /*
        labels: receive an object with objects: text, position[x,y], index
        ex:
        labels:[
            {
               text:"the text".
               position:[0,10],
               index:0
            }
        ]
        */
        labels:[
            {
                text: "the text",
                position: [0,10],
                index: 1
            }
        ],
        //move velocity: px/deg
        dxVelocity:2.72,//3.97,//5.5,
        //frames keys
        keyFrames:[
        	15,//90º [dregge]
            37,//180º [dregge]
            57,//270º [dregge]
            72 //360º [dregge]
        ]
	},
	/*
		state variables
	*/
	//the current frame
	current: 0,
	//a history of positions, updated periodically; used to compute the "flick" velocity
	history: [0],
	//the position when a drag event starts
	dragStartPos: 0,
	//array of image sources for our animation (computed by computeSources method)
	sources: [],
	sourcesY: [],

	currentAxis: 'x',

    //velocities, dregge/frame
    veolicities:[],
    currentDreegre:0,
    tempXposition:null,
    tempDreggree:null,
    //1: left, -1 right
    orientation:1,
    dreggrees_moved:0,
    hide_labels:false,

	initialize: function(container, options){
		this.element = document.id(container);
		this.setOptions(options);
		this.attach();
        this.attachKeyboard();

        // initial compute images: {path: 'images/Seq_v04_640x378_##.jpg', count: 72 } path: path pattern to replace, use # as a wildcard, count: number of images to use in the sequence.
		if(this.options.images && this.options.images.path && this.options.images.count)
            this.computeSources();
        /*
        if the images option is an array, the source if filled with this array in the x axis by default
        ex:
        images:["path/to/image1.ext","path/to/image2.ext","path/to/image3.ext"]
         */
        if(this.options.images && typeOf(this.options.images) == "array")
            this.setSource("x",this.options.images);
        /*
         if the images option is an object and the object have an "x" property, the source if filled with this images array
         ex:
         images:{
            x:["path/to/image1.ext","path/to/image2.ext","path/to/image3.ext"],
         }
         */
        if(this.options.images && this.options.images.x && typeOf(this.options.images.x)=="array")
            this.setSource("x",this.options.images.x);
        /*
         if the images option is an object and the object have an "y" property, the source if filled with this images array
         ex:
         images:{
         y:["path/to/image1.ext","path/to/image2.ext","path/to/image3.ext"],
         }
         */
        if(this.options.images && this.options.images.y && typeOf(this.options.images.y)=="array")
            this.setSource("y",this.options.images.y);
        /*
         if the images option is an object and the object have an "axis" property, the source if filled with this images array inside "images" object and placed in the "axis" axis source

         ex:
         images:{
         axis:"x",
         images:["path/to/image1.ext","path/to/image2.ext","path/to/image3.ext"],
         }
         */
        if(this.options.images && this.options.images.axis && typeOf(this.options.images.images)=="array")
            this.setSource(this.options.images.axis,this.options.images);

        this.calculateVelocities();
        this.makeImg();
        this.buildLabels();
		this.makeFx();
		this.preload();
	},
    calculateVelocities:function(){

        var that  = this;

        if(!that.sources || that.sources.length==0) return;

        var last_key_frame = 0;
        this.options.keyFrames.each(function(val,ind){
            that.veolicities[ind]  =  90/(val - last_key_frame);
            last_key_frame = val;
        });
       	//console.log(that.veolicities);

    },
    //create labesl based on option "labels"
    buildLabels:function(){
        var that = this;
        if(this.options.labels){
            var bubbles_wrapper = new Element("ul.bubbles-wrapper");
            bubbles_wrapper.inject(that.element)
            Object.each(this.options.labels,function(e){
            	var bubble_quarter = that.getQuarterFromIndex(e.index);
            	var bubble_dreggee = that.getDreegreeFromIndex(e.index);
            	
                var bubble_label = new Element("li.bubble-label.bubble-label-"+ e.index,{
                    html: e.text,
                    style: "left: "+ e.position[0] + "px; " + "top: " + e.position[1] + "px;"+(bubble_quarter==0 || bubble_quarter==3?"":"display:none;"),
                    "data-frame": e.index,
                    "data-quarter": bubble_quarter,
                    "data-dreggee": bubble_dreggee,
                    "data-position": JSON.encode(e.position)
                });
                bubbles_wrapper.adopt(bubble_label);
            });
            this.checkAndShowLabel(0);
        }
    },
	//get a reference to or create an image for our animation
	makeImg: function(){
		if (this.options.image) this.img = document.id(this.options.image);
		if (!this.img){
			//create a new image and inject it in our target if there isn't one
			this.img = new Element('img', {
				src: this.sources[0]
			}).inject(this.element);
		}
	},
	makeFx: function(){
		//create an fx object for spinning
		this.fx = new Fx({
			transition: Fx.Transitions.Quad.easeOut,
			fps: 120
		});
		//define the set method for our Fx instance as rotating the image
		this.fx.set = function(i){
			this.show(i.round());
		}.bind(this);
	},
	//define the sources for all the images in the set; put them in this.sources array
	computeSources: function(){
		var path = this.options.images.path.split('##');
		this.options.images.count.times(function(i){
			this.sources.push(path[0] + this.pad(i + 1, 3) + path[1]);
		}, this);
		this.options.images.count.times(function(i){
			this.sourcesY.push(path[0] + this.pad(i + this.options.images.count + 1, 3) + path[1]);
		}, this);
	},
    setSource:function(axis,images){
        if(axis=="x"){
          this.sources = images;
        }
        if(axis=="y"){
            this.sourcesY = images;
        }
    },
	//preload all the images before we run the animation
	preload: function(){
		Asset.images(this.sources, {
			onProgress: function(counter, index, source){
				this.fireEvent('progress', [((counter / this.options.images.count) * 100).round(), index, source])
			}.bind(this),
			onComplete: function(){
				this.fireEvent('ready');
				if (this.options.playIntro) this.intro();
			}.bind(this)
		})
	},
	//play the intro animation
	intro: function(){
		//play a little slower for the intro
		this.fx.options.duration = 1000;
		//start the animation
		this.fx.start(this.current, this.options.images.count).chain(function(){
			//when it finishes, put the duration back
			this.fx.options.duration = 500;
			//set the current frame
			this.current = this.options.images.count;
		}.bind(this));
	},
	//method to pad a number a given digits
	pad: function(n, digits){
	    var s = n+"";
	    while (s.length < digits) s = "0" + s;
	    return s;
	},
	//attach the drag event logic; uses Touch.js for this
	attach: function(){
		var _this = this;
		this.touch = new Touch(this.element).addEvents({
			start: this.startDrag.bind(this),
			end: this.endDrag.bind(this),
			move: this.drag.bind(this)
		});
		this.element.getNext().addEvent('click', function(e) {
			_this.showLabels();
			return false;
		})
	},
    //attach the keyboard events
    attachKeyboard: function() {
        $$('.view360')[0].addEvent('keydown', function(e) {
            var key = e.key ? e.key : e.code;
            switch (key) {
                case "left":
                case 37:
                    this.keyboardDrag(-7, 0);
                    return false;
                    break;
                case "up":
                case 38:
                    this.keyboardDrag(0, -7);
                    return false;
                    break;
                case "right":
                case 39:
                    this.keyboardDrag(7, 0);
                    return false;
                    break;
                case "down":
                case 40:
                    this.keyboardDrag(0, 7);
                    return false;
                    break;
            }
        }.bind(this));
        $$('.view360, .show-labels').set('tabindex', 0);
    },
	//fired when dragging starts
	startDrag: function(){
		this.axisLocked = false;
		
		//cancel any running effect (a flick or the intro)
		this.fx.cancel();
		//set the start position
		this.dragStartPos = this.current;
		//reset the history
		this.history.empty();
		this.dragOffset = 0;
		//push the location into the history every 15 ms; used to compute flick
		this.dragInterval = this.updateDragHistory.periodical(10, this);
		this.updateDragHistory();
	},
	//updates the drag position in the history
	updateDragHistory: function(){
		//put the current position at the beginning
		this.history.unshift(this.dragOffset);
		//keep the array at 3 long for teh memories
		if (this.history.length > 3) this.history.pop();
	},
	//on drag end, clear the interval and fire the flick
	endDrag: function(){
		clearInterval(this.dragInterval);
		//get the distance moved from the history (30 ms ago)
		var flick = (this.history.getLast() - this.dragOffset);
		//get the size of the container
		var size = this.element.getSize().x;
		//rotate based on the relative size of the container,
		//i.e. if you moved 1x the size of the container in 30ms
		//rotate 1 full time. if you moved only .5x, rotate a half turn, etc.
		var rotation = (flick / size) * this.options.images.count;
		this.flick(rotation.round());
	},
	//drag handler; figures out rotation position based on drag offset
	//x = integer of drag offset
	drag: function(x, y){
		if (!this.axisLocked) {
			var page = this.touch.getPage(event);
			var deltaX = page.pageX - this.touch.startX;
			var deltaY = page.pageY - this.touch.startY;
			if (Math.abs(deltaX) > Math.abs(deltaY) || true) {
				this.currentAxis = 'x';
				this.axisLocked = true;
			}
			else {
				this.currentAxis = 'y';
				this.axisLocked = true;
			}
		}

		// console.log(this.dragOffset, x,y);
		this.dragOffset = this.currentAxis == 'x' ? x : y;
		//compute the frame distance as the drag distance devided by the distance one must drag for a full rotation
		var percentDiffX = (this.currentAxis == 'x' ? x : y) / this.options.rotateDistance,
				//and the frame we're on is the image count times that percent offset
				frameDiffX = (this.options.images.count * percentDiffX).round();

		//determinate oritentation based on cursor point
		if(this.tempXposition==null)
			this.tempXposition = event.clientX;
		
		if(this.tempXposition<=event.clientX){
			this.orientation=1;
		}
		else{
			this.orientation=-1;
		}

		this.tempXposition = event.clientX;
		//now rotate the negative of that number, because in iOS we follow the finger, not the "scroll bar" as on the web
		this.rotate((this.options.invert ? -1 : 1) * frameDiffX);
	},
    //keyboard dragging
    keyboardDrag: function(x, y) {
        this.startDrag();
        this.currentAxis = x == 0 ? 'y' : 'x';
        this.dragOffset = this.currentAxis == 'x' ? x : y;
        var percentDiffX = (this.currentAxis == 'x' ? x : y) / this.options.rotateDistance,
            frameDiffX = (this.options.images.count * percentDiffX).round();
        this.rotate((this.options.invert ? -1 : 1) * frameDiffX);
    },
	//rotate the image by x frames
	rotate: function(offset){
		if(this.options.full360) {
			//compute the image index to display
			//get the offset from the start position and wrap it at the image count size
			var index = (offset + this.dragStartPos) % this.options.images.count;
			if (index < 0) index = this.options.images.count + index;
			this.show(index);
		} else {
			//Do not allow rotation
			var index = offset + this.dragStartPos;
			if(index >= 0 && index < this.options.images.count) {
				this.show(index);
			}
		}
		
	},
	show: function(index){
		//handle the possibility that something has gone wrong and we're trying to set an image source that isn't valid
		var sources = this.currentAxis == 'x' ? this.sources : this.sourcesY;
		if (sources[index]) {
			//set the image source
			this.img.src = sources[index];
			//update the current position
			this.current = index;
			var dreggree = new Number(this.getDreegreeFromIndex(index));
			if(this.tempDreggree==null){
				this.tempDreggree=dreggree;
			}
			this.currentDreegre = dreggree;

			if(this.orientation<0 && this.tempDreggree<this.currentDreegre){
				//console.log(this.tempDreggree + 360 - this.currentDreegre);
			}
			this.dreggrees_moved = this.currentDreegre-this.tempDreggree;
			if(Math.abs(this.dreggrees_moved)>180){
				
				if(this.dreggree_moved>0){
					this.dreggrees_moved = 360-this.dreggrees_moved;
				}
				else{
					this.dreggrees_moved = this.dreggrees_moved+360;
				}
			}
			this.tempDreggree = dreggree;

            this.checkAndShowLabel(index);
			this.fireEvent('changed', {'index': this.current});
		}
	},
	//animate the rotation a given distance (number of frames) by a factor of 2
	flick: function(distance){
		distance *= this.options.distanceMultiplier;
		//if it's not at least the minFlick value, exit
		if (distance.abs() < this.options.minFlick) return;
		//if it's greater than the maxFlickMultiplier * the image count, use that max value
		if (distance.abs() > this.options.maxFlickMultiplier * this.options.images.count) {
			distance = this.options.maxFlickMultiplier * this.options.images.count * (distance > 0 ? 1 : -1);
		}
		//if the distance value was postive, make the dist value negative to get the spin direction correct
		distance *= (this.options.invert ? 1 : -1);
		this.fx.start(this.current, this.current + distance);
	},
    //show labels from object
    checkAndShowLabel:function(index){ 
        if(this.options.labels){

        	var that = this;
        	var current_quarter = Math.floor(this.currentDreegre/90);//that.getQuarterFromIndex(index);

        	var last_quarter=null,next_quarter=null,last_dreggree=null,next_dreggree=null;

        	//this.currentDreegre=350;
        	var middle_dreggee = 0*360-this.currentDreegre*-1;

        	last_dreggree=(middle_dreggee-90<0?360-Math.abs(middle_dreggee-90):middle_dreggee-90);
        	next_dreggree=(middle_dreggee+90>360?90-(360-middle_dreggee):middle_dreggee+90);
        	last_quarter=Math.floor(last_dreggree/90);
        	next_quarter=Math.floor(next_dreggree/90);

        	if(current_quarter==0){
        		last_quarter=3;
        	}

        	if(current_quarter==3){
        		next_quarter=0;
        	}

        	var current_width = this.element.getWidth();
        	var min_x = 80;
        	var max_x = 570;

        	//console.log(that.orientation);

        	
        	//console.log( this.current+" | ["+last_dreggree+"<("+this.currentDreegre+","+middle_dreggee+")<"+next_dreggree+"]" );


        	//console.log("quarters: "+last_quarter+","+current_quarter+","+next_quarter+"");

        	//this.element.getElements(".bubble-label").hide();
        	this.element.getElements('.bubble-label').each(function(label_e){
        		//console.log(label_e);
        		var dreggee = new Number(label_e.get("data-dreggee"));
        		var label_quarter = new Number(label_e.get("data-quarter"));
        		if(dreggee <= next_dreggree || true){

        			if(!that.hide_labels){
        				label_e.show();
        			}
        			else{
        				label_e.hide();	
        			}
        			label_e.set("data-out-of-range",0);

        			var dreggree_to_current = 0;
        			var dreggree_to_last = 0;
        			var leftpos = 0;
        			

        			/*
        			if(dreggee==middle_dreggee || that.dreggeeGreaterThan(dreggee,middle_dreggee)){
        				//console.log("tro");
        				dreggree_to_current = Math.abs( that.currentDreegre +  (dreggee - 90*current_quarter));
        				leftpos = (current_width/2 + (that.options.dxVelocity/2)*dreggree_to_current);
					}
        			else{
        				dreggree_to_current = Math.abs(dreggee-90*last_quarter) + that.currentDreegre;
        				leftpos = ((that.options.dxVelocity/2)*dreggree_to_current);
        			}
        			*/

        			var delta_teta = Math.abs(middle_dreggee)*2;
        			if(delta_teta>360){
        				delta_teta-=360;
        			}


					dreggree_to_last = dreggee - last_dreggree + delta_teta;
        			//dreggree_to_last = dreggree_to_last - last_dreggree;

        			
        			
        			if(dreggree_to_last<0){
        				dreggree_to_last = dreggree_to_last+360;
        			}

        			if(dreggree_to_last>360){
        				dreggree_to_last-=360;
        			}

        			

        			//dreggree_to_last+= Math.abs(that.dreggrees_moved) ;


        			//console.log(that.dreggrees_moved+"");
        			//console.log(that.orientation);
        			//console.log("["+dreggree_to_last+","+dreggee+","+last_dreggree+","+middle_dreggee+","+that.dreggrees_moved+","+delta_teta+"]");
        			leftpos = that.options.dxVelocity*dreggree_to_last + min_x;

        			if(leftpos<min_x){
        				leftpos = min_x;
        			}



        			if(leftpos>max_x){
        				leftpos = max_x;
        				label_e.hide();
        				label_e.set("data-out-of-range",1);
        			}

        			dreggree_to_current = dreggee - middle_dreggee + delta_teta;
					
					label_e.setStyles({
        				"left": leftpos+"px",
        				"transform": 'perspective( 600px ) rotateY( '+dreggree_to_current+'deg )',
        			});
        			//label_e.show();
        		}
        	});
        	

        	this.element.getElements(".bubble-label").each(function(el){
        		var label_frame = el.get("data-frame");
        		var label_quarter = that.getQuarterFromIndex(label_frame);
        		//console.log(el);
        		//console.log(that.getIndexFromDreegree(that.getDreegreeFromIndex(label_frame)));



        		
        	});

            
        }
    },
    distenceBetweenDreggree:function(teta1,teta2){
    	if(teta1>teta2){
    		return 360+teta2-teta1;
    	}
    	else
    		return teta1-teta2;
    },
    dreggeeGreaterThan:function(teta1,teta2){
    	if(teta1>360){
    		teta1 = teta1-360;
    	}

    	if(teta2>360){
    		teta2 = teta2-360;
    	}

    	return teta1>teta2;
    },
    getQuarterFromIndex:function(index){
    	var that = this;
        var key_frames = that.options.keyFrames;
    	if(index<=key_frames[0]){
    		return 0;
		}
		else if(index>key_frames[0] && index<=key_frames[1]){
			return 1;
		}
		else if(index>key_frames[1] && index<=key_frames[2]){
			return 2;
		}
		else if(index>key_frames[2] && index<=key_frames[3]){
			return 3;
		}

		return 0;
    },
    getDreegreeFromIndex:function(index,quarter){
    	var that = this;
    	var key_frames = that.options.keyFrames;
    	var current_quarter = quarter;
    	if(quarter==null)
    		current_quarter = that.getQuarterFromIndex(index);

    	var velocity = that.veolicities[current_quarter];
    	var initial_quarter_frame = 0;
    	if(current_quarter>0){
    		initial_quarter_frame = key_frames[current_quarter-1];
    	}

    	//console.log((index)+"------");

    	dregge =  90*current_quarter + velocity*(index-initial_quarter_frame);
    	//console.log(index+"||||")
    	return dregge;
    },
    getIndexFromDreegree:function(deegree){
    	var that = this;
    	var key_frames = that.options.keyFrames;
    	var current_quarter = Math.floor(deegree/90);
    	
    	var velocity = that.veolicities[current_quarter];
    	var initial_quarter_frame = 0;
    	if(current_quarter>0){
    		initial_quarter_frame = key_frames[current_quarter-1];
    	}

    	var sample_dreegee = deegree - 90*current_quarter;

    	//console.log(sample_dreegee+"------");

    	return Math.floor(sample_dreegee/velocity) + initial_quarter_frame;
    },
	//show labels
	showLabels: function() {

		this.hide_labels=!this.hide_labels;

		if(this.hide_labels){
			this.element.getElements('.bubble-label').hide();
		}
		else{
			this.element.getElements('.bubble-label[data-out-of-range="0"]').show();
		}


		/*
		//start the animation
		if (this.currentAxis != 'x') {
			this.fx.options.duration = 500;
			this.fx.start(this.current, this.options.images.count).chain(function(){
				//when it finishes, put the duration back
				this.fx.options.duration = 500;
				//set the current frame
				this.current = this.options.labelImgIndex;
			}.bind(this));

			setTimeout(function() {
				console.warn('startx', this.current, this.options.labelImgIndex);
				this.currentAxis = 'x';
				this.show(0);
				this.fx.start(this.current, this.options.labelImgIndex).chain(function(){
					//when it finishes, put the duration back
					this.fx.options.duration = 500;
					//set the current frame
					this.current = this.options.labelImgIndex;
				}.bind(this));

				setTimeout(function() {
					console.warn('labels');
					this.img.src = this.options.labelImgSrc;
				}.bind(this), 1050);
			}.bind(this), 550);
		}
		else {
			//play a little slower for the intro
			this.fx.options.duration = 1000;
			this.fx.start(this.current, this.options.labelImgIndex).chain(function(){
				//when it finishes, put the duration back
				this.fx.options.duration = 500;
				//set the current frame
				this.current = this.options.labelImgIndex;
			}.bind(this));

			setTimeout(function() {
				this.img.src = this.options.labelImgSrc;
			}.bind(this), 1050);
		}
		*/
	}
});

//some cross-lib compatibility; Touch.js and MooTools 1.3 aren't quite in sync
if (Browser.Platform.ios) Browser.Platform.ipod = true;