/**
 * Created by germanmontes on 2/09/14.
 */
var View360 =  new Class({

    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    options: {
        container: null,
    },
    ThreeSixtyEl: null,
    assets: [
        "../_framework/_base_external/form-upload/file-upload.css",
        "../_framework/_base_external/form-upload/Source/Form.Upload.js",
        "../_framework/_base_external/form-upload/Source/Form.MultipleFileInput.js",
        "../_framework/_base_external/form-upload/Source/Request.File.js"
    ],

    initialize: function(options) {
        var that = this;
        //call parent before to go into the widget
        this.parent({
            container: options.container,
            itemTemplate: options.itemTemplate
        });

        if (!this.isEditMode){
            this.add360Widget(this.container);
        }

        this.render();
    },
    //
    add360Widget:function(container){
        var that = this;
        var labels = [];
        if(container.getElements(".option-entry").length>0){
            var labels_entrys = container.getElements(".option-entry").clone(true,true);
            container.getElements(".option-entry").dispose();

            labels_entrys.each(function(lentry){
                //var labelInfo = lentry.getElement(".label-entry");
                var labelInfo = lentry;
                var labelposition = JSON.decode(labelInfo.get("data-label-position"));
                labels.push({
                    //text:labelInfo.getElement('[data-md-editable="md-textfield"]').get("html"),
                    text:labelInfo.get("html"),
                    position:[labelposition.x,labelposition.y],
                    index:labelInfo.get("data-image-index")
                });
            });
        }

        var imagesAxisX = container.getElements(".view-360-entry[data-axis='x']").map(function (e, i) {
            if (e.get("data-file-path-relative") === null) {
                return e.get("data-file-path");
            } else {
                return e.get("data-file-path-relative");
            }
        });

        var imagesAxisY = container.getElements(".view-360-entry[data-axis='y']").map(function (e, i) {
            if (e.get("data-file-path-relative") === null) {
                return e.get("data-file-path");
            } else {
                return e.get("data-file-path-relative");
            }
        });

        //delete old entrys
        container.getElements(".view-360-entry").dispose();

        //get label source path
        var label_source_path = container.get("data-label-file-path");

        //create a element for label button
        var labelElement = Elements.from('<a href="" class="show-labels">Show Labels</a>')[0];
        labelElement.inject(container,"after");

        // add 'view360' class to the body
        $$(".widget-body").addClass("view360");

        this.ThreeSixtyEl = new ThreeSixty(container, {
            images: {
                //'count': 72,
                //'path': 'Limbic_System/##.jpg'
                x: imagesAxisX,
                y: imagesAxisY
            },
            labelImgSrc: label_source_path,
            distanceMultiplier: 9,
            labelImgIndex: 12,
            playIntro: false,
            labels:labels
        });
    },
    //if edit mode is on add fileupload event and rotation select form
    bindEditMode: function () {

        var that = this;

        //retrieve labels before the widget is initializated
        var labels_sidebar = this.container.getElements(".option-entry").clone(true,true);

        //this.container.getElements(".option-entry").dispose();


        var WidgetPrevie = new Element("div.widget-preview.view360");
        WidgetPrevie.inject($$(".widget-body")[0],"before");

        var container_clone = this.container.clone(true);
        container_clone.inject(WidgetPrevie);

        this.add360Widget(container_clone);

        $$(".widget-body").removeClass("view360");

        //image was deleted
        this.addEvent("md-file-delete", function (data) {
            data.el.dispose();
            that.saveProcedure(that.onImageUpload);
        });

        //image was added or edited
        this.addEvent("md-file-added-edited", function (data) {

            var file = data.files[0];
            data.el.set("data-file-name", file.filename);
            data.el.set("data-file-path", file.path);
            data.el.set("data-file-path-relative", file.relativePath);
            that.saveProcedure(that.onImageUpload);
        });

        //upload complete listener
        this.addEvent("md-fileupload-multiple-complete", function (data) {

            if (data.files) {
                data.files.each(function (file) {
                    that.addImageEntry(file);
                });

                that.saveProcedure(that.onImageUpload);


                that.parseElements360(that.container);
            }
        });

        //create elements for global options
        var globalOptionsWrapper = new Element("div.global-options", {
            html: "" +
                "<div class='global-option' >" +
                "<div class='global-option-label' >" +
                    "<div>Axis to be inserted:</div>" +
                "</div>" +
                "<div class='global-option-textfield-wrapper'><input type='radio' name='axis' value='0' checked='checked' id='axis-x'/> <label for='axis-x'>'X' axis</label> | <input type='radio' name='axis' value='1' id='axis-y'/> <label for='axis-y'>'Y' axis</div>" +
                "</div>" +
                ""
        });
        //inject global options before the multi uploader
        globalOptionsWrapper.inject($$('[data-md-editable="md-fileupload-multiple"]')[0], "before");
        new Element("hr").inject(globalOptionsWrapper, "after");
        new Element("hr").inject(globalOptionsWrapper, "before");

        //view 360 entry's wrapper
        var imagesWrapper = new Element("div.images-wrapper");
        imagesWrapper.inject(this.options.container);

        //view 360 entry's axis wrapper
        var axis_elements_wrapper = Elements.from("<fieldset class='images-x-axis'><legend>'X' Axis</legend></fieldset><fieldset class='images-y-axis'><legend>'Y' Axis</legend></fieldset>");
        axis_elements_wrapper.inject(imagesWrapper);

        //inject entry's into the wrapper based on axis.
        this.options.container.getElements(".view-360-entry[data-axis='x']").inject(this.container.getElement(".images-x-axis"));
        this.options.container.getElements(".view-360-entry[data-axis='y']").inject(this.container.getElement(".images-y-axis"));

        //create sidebar
        var sidebar = new Element("div.sidebar", {
            html:   '<button class="save-labels">Save</button>'+
                    '<ul data-md-editable="md-multiple-options" class="labels-wrapper" data-md-multiple-options-config="{addfirstitem:true,addButtonLabel:\'Add Label\',entryTag:\'li\'}">'+
                        '<div data-md-multiple-options-sample="1" class="label-entry">'+
                            '<div class="processed" data-md-editable="md-textfield" data-md-textfield-label="Label Text: "></div>'+
                            '<div class="label-index-position-wrapper">'+
                                '<div class="add-edit-index-position"><span>Drag to choose a<br/>point </span><div class="button"></div></div>'+
                            '</div>'+
                        '</div>'+
                    '</ul>'+
                    ''
        });

        sidebar.inject($$(".widget-body")[0],"after");

        //generate an array of label to send to the portal via postMessage
        var labels_to_portal = [];

        labels_sidebar.each(function(labele){
            var label_position = labele.get("data-label-position");
            label_position = JSON.decode(label_position);
            var labelHTML = '<div class="label-entry">'+
                '<div  data-md-editable="md-textfield" data-md-textfield-label="Label Text: ">'+labele.get("html")+'</div>'+
                '<div class="label-index-position-wrapper setted">'+
                '<div class="add-edit-index-position "><span>Current point: <br/> x: '+label_position.x+' <br/>y: '+label_position.y+'<br/> At frame: '+ (new Number(labele.get("data-image-index"))+1) +'</span><div class="button"></div></div>'+
                '</div>'+
                '</div>';

            labels_to_portal.push({
                position:{
                    x: label_position.x,
                    y: label_position.y
                },
                at: (new Number(labele.get("data-image-index"))),
                text: labele.get("html"),
                id: labele.get("id")
            });

            labele.set("html",labelHTML);


         });

        if(parent!=window){
            parent.postMessage(labels_to_portal,"*");
        }

        sidebar.getElement(".labels-wrapper").adopt(labels_sidebar);

        labels_sidebar.each(function(e){
            that.bindEventsLabels(e);
        });

        //save labels
        sidebar.getElements(".save-labels").addEvent("click",function(){
            that.saveProcedure();
        });

        new Element("div.preview-lightbox").inject(sidebar,"after");
        new Element("div.preview-lightbox-overlay")
        .addEvent("click",function(){
            $$(".preview-lightbox,.preview-lightbox-overlay").hide();
        })
        .inject(sidebar,"after");



        //label option added
        that.addEvent("md-multiple-options-option-added",function(data){

            that.bindEventsLabels(data.el);

        });

        this.parseElements360();


    },
    onImageUpload:function(){
        document.location.reload();
    },
    //binds show label button and make labels draggeable
    bindEventsLabels:function(el){
        var that = this;

        el.getElement(".add-edit-index-position .button").addEvent("click",function(){

            $$(".widget-preview.view360 > div .bubble-label").dispose();

            var parent = this.getParent(".option-entry");

            var pointSelected = JSON.decode(parent.get("data-label-position"));

            var labelToInsert = new Element("div.bubble-label.bubble-label-"+parent.get("data-image-index"),{
                    html:parent.getElement("input").get("value")
                });

            labelToInsert.setStyles({
                left:pointSelected.x+"px",
                top:pointSelected.y+"px",
                "z-index":10000
            });
            labelToInsert.inject($$(".widget-preview.view360 > div")[0],"top");

            that.ThreeSixtyEl.show(parent.get("data-image-index"));
        });

        el.getElement(".label-entry").makeDraggable( {
            droppables: ".widget-preview",
            onBeforeStart:function(draggeable, event) {

                var pos = {x:draggeable.getStyle("left"), y:draggeable.getStyle("top")};
                draggeable.set("data-original-position", JSON.encode(pos) );

            },
            onDrop: function(draggeable, droppable, event) {


                if(droppable){

                    var dragPosition = draggeable.getPosition();
                    var previewPosition = $$(".widget-preview.view360 > div")[0].getPosition();

                    var pointSelected = {x: dragPosition.x - previewPosition.x, y: dragPosition.y - previewPosition.y };

                    if(pointSelected.x<0)pointSelected.x=0;
                    if(pointSelected.y<0)pointSelected.y=0;


                    var frame_index = that.ThreeSixtyEl.sources.length-that.ThreeSixtyEl.current;



                    draggeable.set("data-label-position",JSON.encode(pointSelected));
                    draggeable.set("data-image-index",frame_index);
                    draggeable.getElement(".label-index-position-wrapper").addClass("setted");
                    draggeable.getElement(".add-edit-index-position span").set("html","Current point: <br/>x: "+pointSelected.x+" <br/>y: "+pointSelected.y+"<br/>At frame: "+(that.ThreeSixtyEl.current+1));




                    var origianlPosition = JSON.decode(draggeable.get("data-original-position"));
                    draggeable.morph({
                        left:origianlPosition.x,
                        top:origianlPosition.y
                    })


                }
                else{
                    var origianlPosition = JSON.decode(draggeable.get("data-original-position"));
                    draggeable.morph({
                        left:origianlPosition.x,
                        top:origianlPosition.y
                    })
                }


            }
        });
    },
    //show label in the preview mode
    showPreviewLabel:function(el){
        var that = this;
        $$(".widget-preview.view360 > div .bubble-label").dispose();

        var parent = el;

        var pointSelected = JSON.decode(parent.get("data-label-position"));

        var labelToInsert = new Element("div.bubble-label.bubble-label-"+parent.get("data-image-index"),{
            html:parent.getElement("input").get("value")
        });

        labelToInsert.setStyles({
            left:pointSelected.x+"px",
            top:pointSelected.y+"px",
            "z-index":10000
        });
        labelToInsert.inject($$(".widget-preview.view360 > div")[0],"top");

        that.ThreeSixtyEl.show(parent.get("data-image-index"));
    },
    //receive postmessage event
    customPostMessages:function(mss,path){
        var that = this,
            message=mss;
        switch (message.data.method) {
            case "toggleHTML":
                that.saveRequestProcedure({
                    method: "toggleHTML",
                    selector: message.data.wrapper,
                    elementID: message.data.elementID,
                    toggle: "" + message.data.value
                }, function() {
                    document.location.reload();
                });
                break;

            case "setBubble":
                if(mss.data.position) {
                    this.labelDroppedAt(mss.data.position.x,mss.data.position.y,mss.data.text,mss.data.id);
                }

                if(mss.data.show_label) {
                    this.showPreviewLabel($(mss.data.id));
                }
        }
    },
    //this function generate a label entry and send back to the portal via postMessage
    labelDroppedAt:function(x,y,text,iddropped){
        var that = this;
        //var dragPosition = draggeable.getPosition();
        var previewPosition = $$(".widget-preview.view360 > div")[0].getPosition();

        var pointSelected = {x: x - previewPosition.x, y: y - previewPosition.y };

        if(pointSelected.x<0)pointSelected.x=0;
        if(pointSelected.y<0)pointSelected.y=0;



        var id = "label"+(new Date().getTime());
        if(iddropped!=null)
            id = iddropped


        var draggeable = null;
        if(iddropped==null){
            console.log($$(".md-button-multiple"));
            $$(".md-button-multiple")[0].click();
            draggeable = $$(".option-entry:last-child")[0];
        }
        else
            draggeable = $(iddropped);


        var frame_index = that.ThreeSixtyEl.sources.length-that.ThreeSixtyEl.current;

        draggeable.set("data-label-position",JSON.encode(pointSelected));
        draggeable.set("data-image-index",frame_index);
        draggeable.getElement(".label-index-position-wrapper").addClass("setted");
        draggeable.getElement(".add-edit-index-position span").set("html","Current point: <br/>x: "+pointSelected.x+" <br/>y: "+pointSelected.y+"<br/>At frame: "+(that.ThreeSixtyEl.current+1));
        draggeable.getElement("input").set("value",text);
        draggeable.set("id",id);




        if(parent!=window){
            parent.postMessage([{
                position:pointSelected,
                at:that.ThreeSixtyEl.current,
                text:text,
                id:id
            }],"*");
        }


        this.saveProcedure(function(){
            document.location.reload();
        });


    },
    //this method is executed after the tags are parsed
    bindEditModeAfterTagParse: function () {
        this.bindTargetButton();
    },
    bindTargetButton:function(){
        //code goes here
    },
    //add an image entry into the container
    addImageEntry: function (file) {
        //get current axis to insert
        var currentAxis = $$("input[name='axis']:checked")[0].get("value");

        //if the axis is different than 2 then insert the entry
        if(currentAxis!=="2"){

            var newEntry  = Elements.from(this.options.itemTemplate);
            newEntry = newEntry[0];
            newEntry.set("data-file-name", file.filename);
            //newEntry.set("data-file-path", file.path);
            newEntry.set("data-file-path", file.relativePath);
            newEntry.set("data-file-path-relative", file.relativePath);
            newEntry.set("data-axis", currentAxis === "0" ? "x" : "y");



            var imageLink = new Element("a", {
                href: file.path,
                html: file.filename,
                target: "_blank"
            });
            imageLink.inject(newEntry);

            // insert into the wrapper based on the axis
            this.container.getElement(".images-wrapper .images-" + newEntry.get("data-axis") + "-axis").adopt(newEntry);
        }
        else{ // in other case set the label source data
            this.container.set("data-label-file-name", file.filename);
            this.container.set("data-label-file-path", file.relativePath);
            //this.container.set("data-label-file-path", file.path);
            this.container.set("data-label-file-path-relative", file.relativePath);
        }



    },
    bindEvents: function () {

    },
    //save entry's and labels to the dom
    saveProcedure: function (callback) {
        var that = this;

        //temporal wrapper to get the entry's and order
        var entry_elements = new Element("div");

        that.container.getElements(".view-360-entry").each( function (e) {
            //clone the entry to avoid element miss inject
            var et = e.clone(false,true);
            et.removeClass("processed");
            et.removeClass("target-button-bind");
            entry_elements.adopt(et);
        });

        var bubbles_wrapper = new Element("ul.bubbles-wrapper");
        entry_elements.adopt(bubbles_wrapper);


        $$(".sidebar .option-entry").each(function(e){

            if(e.getElement("input").get("value")=="" && (e.getElement(".label-entry").get("data-label-position")=="" || e.getElement(".label-entry").get("data-label-position")==null) && (e.getElement(".label-entry").get("data-image-index")=="" || e.getElement(".label-entry").get("data-image-index")==null)) return;

            var label_position = JSON.decode(e.get("data-label-position"));

            var et = new Element("li.option-entry",{
                html: '<div class="label-entry">'+
                        '<div  data-md-editable="md-textfield" data-md-textfield-label="Label Text: "></div>'+
                        '<div class="label-index-position-wrapper setted">'+
                            '<div class="add-edit-index-position "><span>Current point: <br/> x: '+label_position.x+' <br/>y: '+label_position.y+'<br/> At frame: '+ (e.get("data-image-index")+1) +'</span><div class="button"></div></div>'+
                        '</div>'+
                     '</div>'

            })

            et.removeClass("processed");

            et.set("html", e.getElement("input").get("value"));
            et.set("data-label-position", e.get("data-label-position"));
            et.set("data-image-index", e.get("data-image-index"));
            et.set("id", e.get("id"));
            bubbles_wrapper.adopt(et);
        });

        // get label source data
        var label_fname = that.container.get("data-label-file-name");
        var label_fpath = that.container.get("data-label-file-path");
        var label_fpathRelative = that.container.get("data-label-file-path-relative");
        // save the dom in the same order and the source properties
        that.saveRequest({
            method: "setHTML",
            html: entry_elements.get("html"),
            selector: "#view-306-wrapper",
            attributes:{
                "data-label-file-name": label_fname,
                "data-label-file-path": label_fpath,
                "data-label-file-path-relative": label_fpathRelative
            }
        },callback);
    },
    render: function () {
    },
    parseElements360: function(context) {
        var that = this;
        var cont = 0;

        $$('body')[0].addClass('md-edit-mode');
        var elements = null;


        /*
         STANDARD CONTROL TEXTFIELD
         */
        cont = 0;
        elements = null;
        if(context!=null){
            elements = context.getElements('[data-md-editable="md-textfield"]:not(.processed)');
        }
        else{
            elements = $$('[data-md-editable="md-textfield"]:not(.processed)');
        }



        elements.each(function(e, i) {

            var html = e.get("html");
            e.set("html", "");

            if (e.get("data-md-id") == null || e.get("data-md-id") == "") {
                e.set("data-md-id", "textfield-" + cont + (new Date().getTime()))
                e.set("id", e.get("data-md-id"));

            }


            if(e.get("data-md-textfield-label")!=null){
                var label = new Element("label.textfield-label",{
                    html:e.get("data-md-textfield-label"),
                    for:e.get("data-md-id")+"-textfield-id"
                });
                label.inject(e)
            }

            var textFieldButton = new Element("input", {
                class: "textfield md-button-popup md-button-textfield",
                "data-control-type": "textfield",
                "data-target-id": e.get("data-md-id"),
                value: html,
                type: "text",
                placeholder: "Enter the text",
                id:e.get("data-md-id")+"-textfield-id"
            });

            textFieldButton.inject(e);

            //textFieldButton.addEvent("click",that.PostMessageControl.bind(that));



            e.addClass("processed");
            cont++;
        });
        /*
         STANDARD CONTROL HTML EDITOR
         */
        cont = 0;

        elements = null;
        if(context!=null){
            elements = context.getElements('[data-md-editable="md-html-editor"]:not(.processed)');
        }
        else{
            elements = $$('[data-md-editable="md-html-editor"]:not(.processed)');
        }

        elements.each(function(e, i) {

            var html = e.get("html");

            if (e.get("data-md-id") == null || e.get("data-md-id") == "") {
                e.set("data-md-id", "textarea-" + cont + (new Date().getTime()));
                e.set("id", e.get("data-md-id"));
            }

            var textareaButton = new Element("textarea", {
                html: html,
                class: "html-editor-textarea  md-button-popup md-button-textarea",
                "data-control-type": "textarea",
                "data-target-id": e.get("data-md-id"),
                placeholder: "Enter the content"
            });
            e.set("html", "");
            textareaButton.inject(e);
            //textareaButton.addEvent("click",that.PostMessageControl.bind(that));


            e.addClass("processed");
            cont++;
        });

        /*
         TITLE BODDY CONTROL
         */

        cont = 0;

        elements = null;
        if(context!=null){
            elements = context.getElements('[data-md-editable="md-title-body"]:not(.processed)');
        }
        else{
            elements = $$('[data-md-editable="md-title-body"]:not(.processed)');
        }

        elements.each(function(e, i) {

            var html = e.get("html");

            if (e.get("data-md-id") == null || e.get("data-md-id") == "") {
                e.set("data-md-id", "textarea-" + cont + (new Date().getTime()));
                e.set("id", e.get("data-md-id"));
            }

            var textareaButton = new Element("button", {
                html: "Add/Edit Content",
                class: "md-button-popup md-button-title-body",
                "data-control-type": "title-body",
                "data-target-id": e.get("data-md-id")
            });
            textareaButton.inject(e, "before");
            textareaButton.addEvent("click", that.PostMessageControl.bind(that));


            e.addClass("processed");
            cont++;
        });

        /*
         MULTI OPTIONS CONTROL
         */

        cont = 0;

        elements = null;
        if(context!=null){
            elements = context.getElements('[data-md-editable="md-multiple-options"]:not(.processed)');
        }
        else{
            elements = $$('[data-md-editable="md-multiple-options"]:not(.processed)');
        }

        elements.each(function(e, i) {

            var html = e.getElement("[data-md-multiple-options-sample]").clone(true,true);
            html.removeAttribute("data-md-multiple-options-sample");
            html.removeClass("processed");
            html.getElements(".processed").removeClass("processed");
            html = new Element("div").adopt(html);
            //e.getElement("[data-md-multiple-options-sample]").dispose();


            var config  = e.get("data-md-multiple-options-config");
            if(config!=null && config!=""){
                config = JSON.decode(config);
            }
            else{
                config=null;
            }

            var entryTag = "div";

            if(config!=null && config.entryTag && config.entryTag!=""){
                entryTag = config.entryTag;
            }

            if (e.get("data-md-id") == null || e.get("data-md-id") == "") {
                e.set("data-md-id", "textarea-" + cont + (new Date().getTime()));
                e.set("id", e.get("data-md-id"));
            }

            if(e.get("data-md-multiple-options-label")!=null){
                var label = new Element("label.textfield-label",{
                    html:e.get("data-md-multiple-options-label"),
                    for:e.get("data-md-id")+"-multiple-options-id"
                });
                label.inject(e,"before")
            }

            var textareaButton = new Element("button", {
                html: config && config.addButtonLabel ? config.addButtonLabel : "Add Option",
                class: "md-button md-button-multiple",
                "data-target-id": e.get("data-md-id")
            });
            textareaButton.inject(e,"after");
            textareaButton.addEvent("click", function(){
                var newel = new Element(entryTag+".option-entry",{
                    html:html.get("html")
                });
                newel.inject(e);
                that.parseElements360(newel);
                that.fireEvent("md-multiple-options-option-added",{container:e,el:newel,button:this});
            });

            if(config!=null && config.addfirstitem!=null && config.addfirstitem==true){

                var newel = new Element(entryTag+".option-entry",{
                    html:html.get("html")
                });
                newel.inject(e);
                that.parseElements360(newel);
                that.fireEvent("md-multiple-options-option-added",{container:e,el:newel,button:this});

            }


            e.addClass("processed");
            cont++;
        });

        /*
         FILE UPLOAD MULTIPLE CONTROL
         */

        cont = 0;

        elements = null;
        if(context!=null){
            elements = context.getElements('[data-md-editable="md-fileupload-multiple"]:not(.processed)');
        }
        else{
            elements = $$('[data-md-editable="md-fileupload-multiple"]:not(.processed)');
        }

        var strVar="";
        strVar += "<fieldset>";
        strVar += "		<legend>Upload Files<\/legend>";
        strVar += "";
        strVar += "		<div class=\"formRow\">";
        strVar += "			<label for=\"url\" class=\"floated\">File: <\/label>";
        strVar += "			<input type=\"file\" class=\"files\" name=\"files[]\" multiple><br>";
        strVar += "		<\/div>";
        strVar += "";
        strVar += "		<div class=\"formRow\">";
        strVar += "			<input type=\"submit\" id=\"_submit\" name=\"_submit\" value=\"Upload\">";
        strVar += "		<\/div>";
        strVar += "<input type='hidden' value='' name='method'/>";
        strVar += "	<\/fieldset>";


        elements.each(function(e, i) {

            var html = e.get("html");

            if (e.get("data-md-id") == null || e.get("data-md-id") == "") {
                e.set("data-md-id", "fileupload-multiple-" + cont + (new Date().getTime()));
                e.set("id", e.get("data-md-id"));
            }

            var textareaButton = new Element("form", {
                html: strVar,
                class: "md-editable md-multiple-fileupload-multiple",
                enctype: "multipart/form-data",
                method: "POST",
                action: that.root+  'api/index.php/upload/?widget_id='+that.widget_id
            });

            textareaButton.getElement(".files").set("id",e.get("id")+"file-field");

            textareaButton.inject(e, "bottom");
            //textareaButton.addEvent("click", that.PostMessageControl.bind(that));


            var upload = new Form.Upload(e.get("id")+"file-field", {
                fields:{
                    path:that.root,
                    directory: e.get("data-target-directory") != null && e.get("data-target-directory") != "" ? e.get("data-target-directory") : "images"
                },
                onComplete: function(filesU){
                    that.fireEvent("md-fileupload-multiple-complete",{
                        files:JSON.decode(filesU),
                        upload:upload
                    });
                }
            });


            e.addClass("processed");
            cont++;
        });


        /*
         FILE UPLOAD
         */

        cont = 0;

        elements = null;
        if(context!=null){
            elements = context.getElements('[data-md-editable="md-file"]:not(.processed)');
        }
        else{
            elements = $$('[data-md-editable="md-file"]:not(.processed)');
        }

        var strVar="";
        strVar += "<fieldset>";
        strVar += "		<div class=\"formRow\">";
        strVar += "			<label for=\"url\" class=\"floated\">File: <\/label>";
        strVar += "			<input type=\"file\" class=\"files\" name=\"files[]\" multiple><br>";
        strVar += "		<\/div>";
        strVar += "";
        strVar += "		<div class=\"formRow\">";
        strVar += "			<input type=\"submit\" id=\"_submit\" name=\"_submit\"  value=\"Upload\">";
        strVar += "		<\/div>";
        //strVar += "     <input type='hidden' value='1' name='test' />";
        strVar += "	<\/fieldset>";

        elements.each(function(e, i) {
            var html = e.get("html");
            e.set("html","");

            if (e.get("data-md-id") == null || e.get("data-md-id") == "") {
                e.set("data-md-id", "file-" + cont + (new Date().getTime()));
                e.set("id", e.get("data-md-id"));
            }

            var config  = e.get("data-md-file-config");
            if(config!=null && config!=""){
                config = JSON.decode(config);
            }
            else{
                config=null;
            }

            var link = new Element("a.file-link",{
                href: e.get("data-file-path"),
                html: e.get("data-file-name"),
                target:"_blank"
            });
            link.inject(e);

            var textareaButton = new Element("div", {
                html: "Edit <div class='edit-toggle'></div><div class='uploader-control'></div>",
                class: "md-button md-button-file md-button-file-edit",
                id: e.get("id")+"-button-edit"
            });
            textareaButton.inject(e);
            textareaButton.addEvent("click", function(e){
                this.getParent('[data-md-editable="md-file"]').getElement(".uploader-control").toggleClass("active");
            });


            var formUploader = new Element("form", {
                html: strVar,
                class: "md-editable md-multiple-fileupload-multiple",
                enctype: "multipart/form-data",
                method: "POST",
                action: that.root+  'api/index.php/upload/?widget_id='+that.widget_id
            });


            formUploader.getElement(".files").set("id",e.get("id")+"file-field");
            textareaButton.getElement(".uploader-control").adopt(formUploader);


            var targetDirectory = e.get("data-target-directory") != null && e.get("data-target-directory") != "" ? e.get("data-target-directory") : "images";
            if(config && config.targetDirectory && config.targetDirectory!=""){
                targetDirectory = config.targetDirectory;
            }


            var upload = new Form.Upload(e.get("id")+"file-field", {
                fields:{
                    path:that.root,
                    widget_id: that.widget_id,
                    directory:targetDirectory
                },
                onComplete: function(filesU){

                    filesU=JSON.decode(filesU);

                    if(config !=null && config.deleteLastImage!=null && config.deleteLastImage){
                        that.saveRequest(
                            {
                                method:"deleteImage",
                                imageName: e.get("data-file-name"),
                                imagePath: e.get("data-file-path"),
                                directory: e.get("data-target-directory") != null && e.get("data-target-directory") != "" ? e.get("data-target-directory") : "images"
                            },
                            function (rs) {

                                e.getElement(".file-link").set("html",filesU[0].filename);
                                e.getElement(".file-link").set("href",filesU[0].path);
                                that.fireEvent("md-file-added-edited",{
                                    files:filesU,
                                    upload:upload,
                                    el:e
                                });
                            }
                        );
                    }
                    else{
                        e.getElement(".file-link").set("html",filesU[0].filename);
                        e.getElement(".file-link").set("href",filesU[0].path);
                        that.fireEvent("md-file-added-edited",{
                            files:filesU,
                            upload:upload,
                            el:e
                        });
                    }


                }
            });

            var deleteButton = new Element("div", {
                html: "Delete <div class='delete-button'></div>",
                class: "md-button md-button-file md-button-file-delete",
                id: e.get("id")+"-button-edit"
            });
            deleteButton.inject(e);
            deleteButton.addEvent("click", function(ev){

                if(!confirm("are you sure to want to delete this image?")) return;

                //this.getParent('[data-md-editable="md-file"]').getElement(".uploader-control").toggleClass("active");
                that.saveRequestProcedure(e,
                    {
                        method:"deleteImage",
                        imageName: e.get("data-file-name"),
                        imagePath: e.get("data-file-path"),
                        directory: targetDirectory
                    },
                    null,
                    function (rs) {

                        that.fireEvent("md-file-delete",{
                            el:e,
                            event:ev
                        });
                    }
                );


            });


            e.addClass("processed");
            cont++;
        });

        if ($$('[data-md-editable="md-html-editor"].processed:not(.initialized)').length > 0) {
            $$('[data-md-editable="md-html-editor"].processed:not(.initialized)').each(function(e) {

                tinymce.init({
                    selector: "#" + e.get("id") + " textarea",
                    plugins: [
                        "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",
                        "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
                        "save table contextmenu directionality emoticons template paste textcolor"
                    ],
                    setup: function(editor) {
                        editor.on('change', function(editorEvent) {
                            var theEditor = this;
                            if (this.timerId != null) {
                                clearTimeout(this.timerId);
                                this.timerId = null;
                            }
                            this.timerId = setTimeout(function() {
                                that.editorOnChangeEventListener(theEditor, editorEvent);
                            }, 500)

                        });
                    }
                });

                e.addClass("initialized");
            });


            //$$('[data-md-editable="md-html-editor"].processed').addClass("initialized");
        }
    }
});