PhotoEssay = new Class({
    Implements: [Options, Events],
    
    current: 0,

    // Set initial options here
    options: {
        
    },

    // initialize - widget initialization
    initialize: function(options) {
        var _this = this;

        window.addEvent("mousemove",function(){
          document.getElement("body").addClass("remove-outline");
        })
        .addEvent("keyup",function(e){
            if(e.key=="tab"){
                document.getElement("body").removeClass("remove-outline");
            }
        });
        
        this.setOptions(options);
        
        this.container = options.container;
        
        this.next = this.container.getElement(".widget-footer .next");
        this.previous = this.container.getElement(".widget-footer .previous");
        this.status = this.container.getElement(".widget-footer .status");
        this.max = this.container.getElements(".widget-body .panel").length;
        
        this.next.addEvent('click', function(e) {
            if(!this.hasClass("disabled")){
                if(_this.current < _this.max){
                    _this.current++;
                    _this.render();
                }
            }
            _this.container.getElement("[tabindex='0']:visible").focus();
            e.preventDefault();
            return false;
        });
        this.previous.addEvent('click', function(e) {
            if(!this.hasClass("disabled")){
                _this.current--;
                _this.render();
            }
            _this.container.getElement("[tabindex='0']:visible").focus();
            e.preventDefault();
            return false;
        });
        
        this.render(0);
				this.addTabIndex();
    },

    // render - updates the widget display
    render: function() {
        this.container.set("data-state", this.current);
        this.status.getElement(".current").set("html", this.current + 1);
        this.status.getElement(".total").set("html", this.max);
        
        if(this.current === this.max - 1){
            this.next.hide();
        }else{
            this.next.show();
        }
        if(this.current === 0){
            this.previous.addClass("disabled");
        }
        else{
            this.previous.removeClass("disabled");
        }
    },
    addTabIndex : function(){
        this.container.getElements('.caption').set('tabindex', 0);
        this.container.getElements('.text-body').set('tabindex', 0);
        //this.container.getElements('.caption')[0].focus();
    }
});

$extend(Selectors.Pseudo, {
    visible: function() {
        if (this.getStyle('visibility') != 'hidden' && this.isVisible() && this.isDisplayed()) {
            return this;
        }
    }
});