/*
 Poe eBook Framework
 Copyright 2011-2014 Metrodigi, Inc. All rights reserved.
 */
'use strict';
/*global $: true, $$: true*/
/*
 var state = function (e, i) { $$('.container')[0].dataset.show = i.get('data-id') };

 window.onload = (function() {
 document.body.addEvent('click:relay(.tabButton)', state);
 });
 */
//fa fa-pencil
//fa fa-times
//fa fa-plus
//fa fa-save
//fa fa-check
var WalkThrough = new Class({
  Implements: [Options, Events],
  Extends: MetrodigiWidget,
  options: {
    container: null,
  },
  widgetMode: "0",
  initialize: function (options) {
    var that = this;
    this.parent({
      container: options.container,
      itemTemplate: options.itemTemplate
    });
    this.next_button = this.container.getElement(".widget-footer .next");
    this.previous_button = this.container.getElement(".widget-footer .previous");
    this.status_area = this.container.getElement(".widget-footer .status");

    this.max = this.container.getElements(".widget-body .panel").length;
    this.current = 0;

    var state = function (e, i) {
      $$('.container')[0].dataset.show = i.get('data-id');
    };
    document.body.addEvent('click:relay(.tabButton)', state);

    if(!this.isEditMode){
      this.container.getElements("[contenteditable]").removeProperty("contenteditable");
    }

    if ( $$('[data-md-editable="md-content-editable-element"]').length > 0 && !this.isEditMode) {
      $$('[data-md-editable="md-content-editable-element"]').forEach( function(theEditable) {
        if ( theEditable.getElement(' > div') ) {
          var theHtml = theEditable.get('html');
          theHtml = theHtml.replace(/<div/g,'<p').replace(/<\/div>/g,'</p>');
          theEditable.set('html', theHtml);
        }
      });
    }
    this.bindWalkthrough();
    this.bindEvents();

    this.render();

    this.temContent = [];

    window.addEvent('resize', function(){
      that.fixDisplay();
    });
    window.addEvent('keydown', function(event){
      that.fixDisplay();
    });
    if(!this.isEditMode){
      setTimeout(function(){
          $$('.mdwysiwyg.wrapper-mdwysiwyg').addClass('visually-hidden');

      },0)
    }
  },
  afterInitialize: function () {


  },
  bindEditMode: function () {
    $$("body").addClass("editmode");

    var addAnotherButton = new Element("button.add-another-entry-button", {
      html: "<span class='fa fa-plus'></span>&nbsp; NEW PANEL"
    });
    addAnotherButton
      .addEvent("click", this.addAnotherItemClickEventListener.bind(this))
      .inject(this.container.getElement(".widget-footer"));

    if(this.container.getElements(".widget-body .panel").length>0){
      var removeButton = new Element("button.remove-entry-button", {
        html: "<span class='fa fa-times'></span>&nbsp; REMOVE THIS PANEL"
      });
      removeButton
        .addEvent("click", this.removeClickEventListener.bind(this))
        .inject(this.container.getElement(".widget-footer"));
    }

    this.prePopulateTabs();
  },
  bindWalkthrough: function () {
    var that = this;
    $$(".header .tab-title").each(function (e) {
      e.addEvent("click", that.changeTabClickEventListener.bind(that));
    });

    this.next_button.addEvent('click', function (e) {
      if (!this.hasClass("disabled")) {
        if (that.current < that.max) {
          that.current++;
          that.render();
        }
      }
      setTimeout(function(){
          that.container.getElement("[tabindex='0']:visible").focus();
      },0)
      e.preventDefault();
      return false;
    });
    this.previous_button.addEvent('click', function (e) {
      if (!this.hasClass("disabled")) {
        that.current--;
        that.render();
      }
      setTimeout(function(){
          that.container.getElement("[tabindex='0']:visible").focus();
      },0)
      e.preventDefault();
      return false;
    });
  },
  prePopulateTabs: function () {
    var that = this;

    $$('#walkthrough-content > div').each(function (el, i) {
      var intTimerID = null;
      el.getElement('*[contenteditable="true"]').addEvent("change", that.editorTabTitleChange.bind(that));
      el.getElement('*[contenteditable="true"]').addEvent("paste", that.editorTabTitleChange.bind(that));
      el.getElement('*[contenteditable="true"]').addEvent("keyup", function (ev) {
        if (intTimerID != null) {
          clearTimeout(intTimerID);
        }
        intTimerID = setTimeout(function () {
          that.editorTabTitleChange(ev);
        }, 500);

        setInterval(function(){
            that.editorTabTitleChange.bind(that)
        }, 1000);

      });
      el.getElement('*[contenteditable="true"]').addEvent("mouseleave", function(ev){
        that.editorTabTitleChange(that)
      });
    });

  },
  editorTabTitleChange: function (e) {
    this.saveEntry($$(".panel.active")[0]);
  },
  addAnotherItemClickEventListener: function () {
    //md-data-set-item
    var that = this;

    // navigation tab and content
    var placeholders = '<div class="md-placeholder" data-md-editable="md-placeholder-image"><span class="md-placeholder-caption">Click to add Media</span></div>';
    that.saveRequestProcedure(null, {
      method: 'appendHtml',
      content_set: [
        {
          target: '#walkthrough-content',
          html: '<div class="panel" tabindex="0"><div class="data-md-editable md-data-set-item">' + placeholders + '<div contenteditable="true" data-md-editable="md-content-editable-element" class="data-md-editable">The Content</div></div></div>'
        }
      ]
    }, null, function (data) {
      window.location.reload();
    });

  },
  removeClickEventListener: function () {
    var that = this;
    if (confirm("Do you want to delete this panel?")) {
      that.saveRequestProcedure(null, {
        method: 'removeBySelector',
        content_set: [
          "#walkthrough-content .panel:eq(" + that.current + ")"
        ]
      }, null, function (data) {
        window.location.reload();
      });
    }
  },
  bindEvents: function () {
    if (!this.isEditMode)
      return;
    var that = this;
    $$("[data-md-editable='md-textfield']:not(.event-processed) input").each(function (e) {
      e.addEvent("change", that.changeTitleEventListener.bind(that));
      e.getParent().addClass("event-processed");
    });
    $$('[data-md-editable="md-placeholder-image"]').addEvent('click', function (e) {
      this.attachImage(e);
    }.bind(this));
  },
  attachImage: function (e) {
    var iframe_parent = window.parent;
    var that = this,
            el = e.target,
            parent = el.getParent('.panel'),
            index = parent.getParent().getChildren('.panel').indexOf(parent),
            have_content = el.get('data-md-placeholder-has-content');

    if (iframe_parent && iframe_parent != window) {
      iframe_parent.postMessage({
        method: "show-media-popup",
        media_type: "image",
        parent_index: index,
        have_content: have_content && have_content == "true" ? true : false
      }, "*");
    }
  },
  postMessageReceived: function (message) {
    var that = this;

    switch (message.data.method) {
      case "show-media-popup":
        switch (message.data.media_type) {
          case "image":
            if (message.data.data.source_type == "pearson"){
              that.saveIframeMedia(message.data.data.source_value, message.data.parent_index, message.data.data.source_type)
              return;
            }
            if (message.data.data.source_type != "computer")
              that.saveImageFile(message.data.data.source_value, message.data.parent_index, message.data.data.source_type)
            else
              that.saveImageFile(message.data.data.source_relative, message.data.parent_index, message.data.data.source_type)
            break;

        }
        break;
    }
  },
  saveImageFile: function (src, index, action) {
    var that = this;
    var iframe = '<img src="' + src + '"/>';
    var have_content = $$('.panel:nth-child(' + (index + 1) + ') [data-md-editable="md-placeholder-image"]').get('data-md-placeholder-has-content');

    if (action == "delete") {
      that.saveRequestProcedure(null, {
        method: 'rm',
        target: '.panel:nth-child(' + (index + 1) + ') [data-md-editable="md-placeholder-image"] img, .panel:nth-child(' + (index + 1) + ') [data-md-editable="md-placeholder-image"] iframe',
      }, null, function (data) {
        that.saveRequestProcedure(null, {
          method: 'attr',
          selector: '.panel:nth-child(' + (index + 1) + ') [data-md-editable="md-placeholder-image"]',
          attributes: {
            'data-md-placeholder-has-content': 'false'
          }
        }, null, function (data) {
          window.location.reload();
        });
      });
      return;
    }

    that.saveRequestProcedure(null, {
      method: have_content && have_content == "true" ? "attr" : 'appendHtml',
      target: '.panel:nth-child(' + (index + 1) + ') [data-md-editable="md-placeholder-image"]',
      html: iframe,
      attributes: {
        src: src
      },
      selector: '.panel:nth-child(' + (index + 1) + ') [data-md-editable="md-placeholder-image"] img',
    }, null, function (data) {
      that.saveRequestProcedure(null, {
        method: 'setAttributeBySelector',
        target: '.panel:nth-child(' + (index + 1) + ') [data-md-editable="md-placeholder-image"]',
        attr: 'data-md-placeholder-has-content',
        val: 'true'
      }, null, function (data) {
        window.location.reload();
      });
    });
  },
  saveIframeMedia: function (src, index, action) {
    var that = this;
    var iframe = '<iframe allowfullscreen="true" webkitallowfullscreen="true" mozallowfullscreen="true" src="' + src + '"></iframe>';
    var have_content = $$('.panel:nth-child(' + (index + 1) + ') [data-md-editable="md-placeholder-image"]').get('data-md-placeholder-has-content');

    if (action == "delete") {
      that.saveRequestProcedure(null, {
        method: 'rm',
        target: '.panel:nth-child(' + (index + 1) + ') [data-md-editable="md-placeholder-image"] img, .panel:nth-child(' + (index + 1) + ') [data-md-editable="md-placeholder-image"] iframe',
      }, null, function (data) {
        that.saveRequestProcedure(null, {
          method: 'attr',
          selector: '.panel:nth-child(' + (index + 1) + ') [data-md-editable="md-placeholder-image"]',
          attributes: {
            'data-md-placeholder-has-content': 'false'
          }
        }, null, function (data) {
          window.location.reload();
        });
      });
      return;
    }
    that.saveRequestProcedure(null, {
      method: have_content && have_content == "true" ? "attr" : 'appendHtml',
      target: '.panel:nth-child(' + (index + 1) + ') [data-md-editable="md-placeholder-image"]',
      html: iframe,
      attributes: {
        src: src
      },
      selector: '.panel:nth-child(' + (index + 1) + ') [data-md-editable="md-placeholder-image"] img, .panel:nth-child(' + (index + 1) + ') [data-md-editable="md-placeholder-image"] iframe',
    }, null, function (data) {
      that.saveRequestProcedure(null, {
        method: 'setAttributeBySelector',
        target: '.panel:nth-child(' + (index + 1) + ') [data-md-editable="md-placeholder-image"]',
        attr: 'data-md-placeholder-has-content',
        val: 'true'
      }, null, function (data) {
        window.location.reload();
      });
    });
  },
  saveEntry: function (entry) {
    var ind = $$(".panel").indexOf(entry);

    var body = entry.getElement('.data-md-editable [data-md-editable="md-content-editable-element"]').get("html");

    this.saveRequestProcedure(this.options.container, {
      method: "setHTML",
      content_set: [
        {
          selector: "#walkthrough-content .panel:eq(" + ind + ") .data-md-editable [data-md-editable='md-content-editable-element']",
          html: body
        }
      ]
    });
  },
  fixDisplay: function(activePanel){
    var windowHeight = window.getSize().y;
    var margin = 80;
    var activePanel = activePanel || $$(".panel.active");
    var imageContainer = $$(activePanel.getElements('.md-placeholder[data-md-editable="md-placeholder-image"][data-md-placeholder-has-content="true"]'));
    var textContainer = $$(activePanel.getElements('.data-md-editable[data-md-editable="md-content-editable-element"]'))[0];

    // remove previous height
    imageContainer.setStyle('height', null);
    textContainer.setStyle('max-height', null);
    if(imageContainer.getElement('iframe') && imageContainer.getElement('iframe')[0] != null && imageContainer.getElement('iframe')[0] != undefined){
      imageContainer.getElement('iframe')[0].setStyle('height', null);
    }

    if(imageContainer[0]){
      activePanel.set('data-has-image', true);
    }else{
      activePanel.set('data-has-image', false);
    }

    if(textContainer && textContainer.get('text').trim().length > 0){
      activePanel.set('data-has-text', true);
    }else{
      activePanel.set('data-has-text', false);
    }
    var textContainerHeight = 0
    if (textContainer) {
        textContainerHeight = textContainer.getHeight()
    }

    var newImageHeight = windowHeight - textContainerHeight - margin


    imageContainer.setStyle('height', newImageHeight + 'px')

    var maxTextSize = windowHeight - (imageContainer.length > 0 ? imageContainer.getHeight() : 5) -  60;

    if(textContainer)
      textContainer.setStyle('max-height', maxTextSize + 'px');

    if(imageContainer.getElement('iframe') && imageContainer.getElement('iframe')[0] != null && imageContainer.getElement('iframe')[0] != undefined){
      imageContainer.getElement('iframe')[0].setStyle('height', newImageHeight + 'px');
    }

  },
  render: function () {
    var _that = this;
    var currentPanel = this.container.getElements(".panel")[this.current];
    this.container.set("data-state", this.current);

    this.status_area.getElement(".current").set("html", this.current + 1);
    this.status_area.getElement(".total").set("html", this.max);

    if (this.current === this.max - 1) {
      this.next_button.addClass("disabled");
      this.next_button.set("disabled",true);
      this.next_button.set("aria-disabled",true);
    } else {
      this.next_button.removeClass("disabled");
      this.next_button.set("disabled",false);
      this.next_button.removeProperty("aria-disabled");
    }
    if (this.current === 0) {
      this.previous_button.addClass("disabled");
      this.previous_button.set("disabled",true);
      this.previous_button.set("aria-disabled",true);
    }
    else {
      this.previous_button.removeClass("disabled");
      this.previous_button.set("disabled",false);
      this.previous_button.removeProperty("aria-disabled");
    }

    if (this.max === 0) {
      this.next_button.addClass("disabled");
      this.next_button.set("disabled",true);
      this.next_button.set("aria-disabled",true);
      this.previous_button.addClass("disabled");
      this.previous_button.set("disabled",true);
      this.previous_button.set("aria-disabled",true);
      this.status_area.hide();
    }
    else {
      this.status_area.show();
      this.container.getElements(".panel").set("aria-hidden", "true");
      currentPanel
        .set("aria-hidden", "false")
        .addClass("active")
        .setStyle("visibility", "hidden");
    }

    if(!this.isEditMode){
        setTimeout(function(){
            if ($$(".wrapper-mdwysiwyg").length) {
                $$(".wrapper-mdwysiwyg")[0].remove(); //due screenreaders still reading its content
            }
        },0);
        $$('.panel').getElement('div').map(function(elem, id){
            var id = 'panel-desc-'+ id
            elem.set('id', id)
            elem.getParent().set('aria-describedby',id )
        })
    }
    setTimeout(function(){
      _that.fixDisplay(currentPanel);
      _that.container.getElements(".panel").removeClass("active");
      currentPanel
        .addClass("active")
        .setStyle("visibility", null);
    }, 0);
  }
});
