Weditor = new Class({
    Implements: [Options, Events],
    options: {
        wrapperSelector: 'div[contenteditable="true"]',
        diffLeft: 0,
        diffTop: -10,
        activeButtonClass: 'medium-editor-button-active',
        firstButtonClass: 'medium-editor-button-first',
        lastButtonClass: 'medium-editor-button-last'
    },
    initialize: function (elementId, options) {
        var _this = this;
        this.t = 0;
        this.l = 0;
        if (options && options.wrapperSelector) {
            this.options.wrapperSelector = options.wrapperSelector;
        }
        this.initElements();
        this.startDetection();
        this.pasteFilter();
        this.cleanHTML();
    },
    initElements: function () {
        var _this = this;
        this.toolbar = new Element('div.mdwysiwyg.wrapper-mdwysiwyg', {
            'aria-hidden': true
        }).inject($$('body')[0]);

        new Element('button', {id: 'md_b', html: '<b>B</b>',
            events: {click: function (evt) {
                    _this.doExec('bold', '');
                }}
        }).inject(this.toolbar);

        new Element('button', {id: 'md_i', html: '<i>I</i>',
            events: {click: function (evt) {
                    _this.doExec('italic', '');
                }}
        }).inject(this.toolbar);

        new Element('button', {id: 'md_u', html: '<u>U</u>',
            events: {click: function (evt) {
                    _this.doExec('underline', '');
                }}
        }).inject(this.toolbar);

        new Element('button', {id: 'md_indent', html: '<b>→</b>',
            events: {click: function (evt) {
                    _this.doExec('indent', '');
                }}
        }).inject(this.toolbar);

        new Element('button', {id: 'md_outdent', html: '<b>←</b>',
            events: {click: function (evt) {
                    _this.doExec('outdent', '');
                }}
        }).inject(this.toolbar);

        new Element('button', {id: 'md_ul', html: '<b>•</b>',
            events: {click: function (evt) {
                    _this.doExec('insertunorderedlist', '');
                }}
        }).inject(this.toolbar);

        new Element('button', {id: 'md_ol', html: '<b>1.</b>',
            events: {click: function (evt) {
                    _this.doExec('insertorderedlist', '');
                }}
        }).inject(this.toolbar);

    },
    doExec: function (fx, extra) {
        document.execCommand(fx, false, extra);         
        if(($$('#contents').length > 0) && $$('#contents')[0].hasClass('epubWidget-gallery') == true){
            console.log('entrando solo en gallery');
            this.dispatchEventElement();    
        }        
    },
    dispatchEventElement: function() {
        var selection = window.getSelection();
        var max = 0, contenteditable = false;        
        var elemento = selection.baseNode.parentElement;        
        while(contenteditable == false){            
            if(elemento.contentEditable && elemento.contentEditable != 'inherit'){
                contenteditable = true;                
            }else{
                elemento = elemento.parentElement;
                if(max == 10){
                    contenteditable = true;
                }else{
                    max++;
                }
            }
        }        
        elemento.fireEvent('keyup');        
    },
    startDetection: function () {
        var _this = this;

        setInterval(function () {
            var selection = window.getSelection(),
                    range = new Object();
            range.collapsed = true;

            try {
                
                var sel_wrapper = $$(selection.baseNode.parentNode).getParent(_this.options.wrapperSelector)[0];
                
                if(sel_wrapper == null){
                    var attrib = $$(selection.baseNode.parentNode).get('contenteditable')[0];
                    if(attrib == null || attrib == false || attrib == 'false')
                        return;
                }
                range = selection.getRangeAt(0);
            } catch (e) {
            }

            if (selection != null && selection.type != undefined && selection.type == 'Range') {
                _this.showToolbar(selection);
            } else if (range.collapsed == false) {
                _this.showToolbar(selection);
            } else if (_this.toolbar.style.visibility == 'visible') {
                _this.toolbar.style.opacity = 0;
                _this.toolbar.style.left = '0px';
                _this.toolbar.style.top = '-100px';

            }
        }, 50);

    },
    showToolbar: function (selection) {
        var _this = this;

        var range = selection.getRangeAt(0),
                boundary = range.getBoundingClientRect(),
                defaultLeft = (_this.options.diffLeft) - (_this.toolbar.offsetWidth / 2),
                middleBoundary = (boundary.left + boundary.right) / 2,
                tem_top = boundary.top + _this.options.diffTop + window.pageYOffset - _this.toolbar.offsetHeight;

        if (boundary.left != this.l || boundary.top != this.t) {

            this.t = boundary.top;
            this.l = boundary.left;

            if (+tem_top <= 0 && boundary.width > 0) {

                _this.toolbar.style.top = '100px';
                _this.toolbar.removeClass('medium-toolbar-arrow-under');
                _this.toolbar.addClass('medium-toolbar-arrow-over');
                $$(_this.toolbar)[0].fade('in');

            } else if (+tem_top <= 0) {

                $$(_this.toolbar)[0].fade('out');

            } else {

                _this.toolbar.addClass('medium-toolbar-arrow-under');
                _this.toolbar.removeClass('medium-toolbar-arrow-over');
                _this.toolbar.style.top = tem_top + 'px';
                $$(_this.toolbar)[0].fade('in');

            }
        }

        if ((defaultLeft + middleBoundary) < 0)
            _this.toolbar.style.left = '0px';
        else
            _this.toolbar.style.left = (defaultLeft + middleBoundary).round() + 'px';
    },
    pasteFilter: function () {

        var _this = this;

        $extend(Element.NativeEvents, {
            'paste': 2, 'input': 2
        });        
        Element.Events.paste = {
            base: (Browser.Engine.presto || (Browser.Engine.gecko && Browser.Engine.version < 19)) ? 'input' : 'paste',            
            condition: function (e) {                                                       
                this.fireEvent('paste', e, 1);
                return false;
            }
        };

        setTimeout(function () {
            $$('div[contenteditable="true"]', 'span[contenteditable="true"]').each(function (elem) {                                
                elem.addEvent('paste', function () {                                         
                    elem.set('html', (_this.stripTags(elem.get('html'), '<b><b/><i></i><u></u><blockquote></blockquote><ul></ul><ol></ol><li></li><div></div><input></input>')));
                    elem.fireEvent('keyup');
                });
            });
        }, 200);
    },
    cleanHTML: function(){
        var _this = this;
        setInterval(function () {
            $$('div[contenteditable="true"]', 'span[contenteditable="true"]').each(function (elem) {                
                elem.addEvent('paste', function () {
                    elem.set('html', (_this.stripTags(elem.get('html'), '<b><b/><i></i><u></u><blockquote></blockquote><ul></ul><ol></ol><li></li><div></div><input></input>')));
                });
            });
        }, 10000);
    },
    stripTags: function (input, allowed) { 

        if (input == undefined) {
            return '';
        }

        allowed = (((allowed || "") + "").toLowerCase().match(/<[a-z][a-z0-9]*>/g) || []).join('');
        var tags = /<\/?([a-z][a-z0-9]*)\b[^>]*>/gi,
                commentsAndPhpTags = /<!--[\s\S]*?-->|<\?(?:php)?[\s\S]*?\?>/gi;
        return input.replace(commentsAndPhpTags, '').replace(tags, function ($0, $1) {
            return allowed.indexOf('<' + $1.toLowerCase() + '>') > -1 ? $0 : '';
        });
    }
});