WeightAdaptiveScenario = new Class({
    Implements: [Options, Events],
    Extends: MetrodigiWidget,
    // Set initial options here
    options: {
    },
    current: null,
    breadcrumbs: [],
    current_edit: null,
    last_weight: 0,
    initialize: function (options) {
        _this = this;
        document.widgetType = "weightedAdaptiveScenarios";
        this.options = options;
        this.parent(options);
    },
    generateDOM: function () {
        if (typeof this.options.data.scenarios !== 'undefined') {
            this.options.data.scenarios.each(function (item) {
                var scenario = new Element('div.scenario', {id: item.id});
                if (item.media.url !== '' && item.media.type !== '') {
                    element = null;
                    switch (item.media.type) {
                        case 'image':
                            var element = new Element('img', {
                                src: 'images/' + item.media.url,
                                alt:'Graph showing the steady increase of aggressive behavior in relation to time spent playing video games.'
                            });

                            break;
                        case 'audio':
                            var element = new Element('iframe.embed', {src: item.media.url, width: '400', height: '65'});
                            break;
                        case 'video':
                            var element = new Element('iframe.embed', {src: item.media.url, width: '400', height: '400'});
                            break;
                    }
                }
                scenario.adopt(element);

                // var paragraphs = item.text.split('. ').map(function(paragraph){
                //     return '<p style ="display: inline">' + paragraph + '. ' + '</p>';
                // }).join('');

                scenario.appendHTML('<p>'+ item.text + '</p>');
                $$('.widget-content').adopt(scenario);
                if (typeof item.choices !== 'undefined' && item.choices.length > 0) {

                    var choices = new Element('fieldset.choices');


                    var question = item.text.split('. ').map(function(elem) {
                      return elem.trim();
                    }).slice(-1);
                     question = '<span class="visually-hidden">'+ question +'</span>'

                    new Element('legend.title', {
                        html: 'Pick from one of the selections below' + question
                    })
                      .inject(choices);

                    typeof item.choices.each(function (choice, index) {

                        var row = new Element('div.row').inject(choices);
                        var inputId =  item.id + '-' + index;
                        new Element('input', {
                            type: 'radio',
                            value: choice.weight,
                            name: item.id,
                            id: inputId
                        })
                          .inject(row);

                        new Element('label', {
                            html: choice.text,
                            for: inputId
                        })
                          .inject(row);
                    });
                    scenario.adopt(choices);
                }
                if (item.weight_start == 0 && item.weight_end == 0) {
                    scenario.show();
                    _this.current = item.id;
                }
            });
        }
    },
    navEvents: function () {

        $('next').addEvent('click', function (e) {
            e.preventDefault();
            var ok = false;
            var value = parseInt(this.getAttribute('data-weight'));
            _this.options.data.scenarios.some(function (item) {
                if (ok && value >= parseInt(item.weight_start) && value <= parseInt(item.weight_end)) {
                    $$('.scenario').hide();
                    $$('.scenario').each(function(scenario){
                      scenario.removeAttribute('tabindex');
                    });
                    $(item.id).show();
                    $(item.id).set('tabindex', -1).focus();
                    $('next').setAttribute('disabled', 'disabled');
                    $('back').removeAttribute('disabled');
                    _this.breadcrumbs.push(_this.current);
                    _this.current = item.id;
                    return true;
                }
                if (_this.current == item.id) {
                    ok = true;
                }
            });
        });

        $('back').addEvent('click', function (e) {
            e.preventDefault();

            var index = _this.breadcrumbs.length - 1;
            var id = _this.breadcrumbs[index];
            _this.breadcrumbs.splice(index, 1);
            if (_this.breadcrumbs.length === 0) {
                this.setAttribute('disabled', 'disabled');
            }
            $$('.scenario').hide();
            $$('.scenario').each(function(scenario){
              scenario.removeAttribute('tabindex');
            });

           $(id).show();
           $(id).set('tabindex', -1).focus();
           var inputs = $(id).getElements('input[type="radio"]');
           inputs.each(function (item) {
               item.removeAttribute('checked');
           });
           _this.current = id;
           $('next').setAttribute('disabled', 'disabled');



        });

        $('reset').addEvent('click', function () {
            $$('.widget-content').set('html', '');
            $('back').setAttribute('disabled', 'disabled');
            _this.current= null;
            _this.breadcrumbs= [];
            _this.current_edit= null
            _this.last_weight= 0;
            _this.render(true)

            setTimeout(function(){
                try{
                    document.dispatchEvent(document.resizeWidget)
                }
                catch(e){
                    console.log('no iphone')
                }
            }, 0)
        });
    },

    choicesEvents: function () {
        $$('.scenario .choices input[type="radio"]').addEvent('change', function () {
            $('next').removeAttribute('disabled');
            $('next').setAttribute('data-weight', this.get('value'));
        });

        $$('.scenario .choices label').addEvent('click', function () {
            var input = this.getParent().getElement('input');
            input.setAttribute('checked', 'checked');
            input.fireEvent('change');
        });
    },
    editNav: function () {
        $$('.edit .nav_edit .pager').set('html', '');
        if (typeof this.options.data.scenarios !== 'undefined') {
            this.options.data.scenarios.each(function (item, index) {
                var number = index + 1;
                var a = new Element('a', {html: number, href: '#'});
                a.setAttribute('data-id', item.id);
                a.addEvent('click', function (e) {
                    e.preventDefault();
                    _this.generateEditDOM(this.get('data-id'));
                });
                if (_this.current_edit == item.id) {
                    a.addClass('active');
                }
                $$('.edit .nav_edit .pager').adopt(a);
            });
        } else {
            var a = new Element('a', {html: 1, href: '#'});
            a.addClass('active');
            $$('.edit .nav_edit .pager').adopt(a);
        }
    },
    generateDecision: function (number, value, weight) {
        var decision = new Element('div.decision');
        decision.setAttribute('data-id', number);
        var _number = number + 1;
        new Element('p.title', {html: 'Point ' + _number}).inject(decision);
        var decision_text = new Element('textarea.decision_text', {value: value}).inject(decision);
        decision_text.addEvent('input', function () {
            _this.delay();
        });
        var div = new Element('div').inject(decision);
        new Element('span', {html: '<strong>Weight </strong>'}).inject(div);
        var weight_text = new Element('input.weight_text', {value: weight, type: 'number'}).inject(div);
        weight_text.addEvent('input', function () {
            _this.delay();
        });
        $$('.edit .decisions').adopt(decision);
    },
    postMessageReceived: function(message,path) {
        this.parent(message, path);
        var that = this;
        switch (message.data.method) {
            case "toggleHTML":
                that.saveRequestProcedure(null, {
                    method: "toggleHTML",
                    selector: message.data.wrapper,
                    elementID: message.data.elementID,
                    toggle: "" + message.data.value
                }, null, function() {
                    document.location.reload();
                });
                break;
            default:
                console.warn('weight-adaptive-scenario Unknown message', message);
        }
    },
    customPostMessages: function (message) {
        switch (message.data.method) {
            case 'show-media-popup':
                switch (message.data.media_type) {
                    case 'image':
                        var formData = new FormData();
                        formData.append('file', message.data.data.file);
                        var pathUpload = location.href;
                        if (pathUpload.indexOf("?") > 0) {
                            pathUpload = pathUpload.split("?")[0];
                        }
                        formData.append('path', pathUpload);
                        formData.append('directory', 'images');
                        var xhr = new XMLHttpRequest();
                        xhr.open('POST', this.root + 'api/index.php/upload/');
                        xhr.onload = function () {
                            if (xhr.status === 200) {
                                var response = JSON.parse(xhr.responseText);
                                _this.options.data.scenarios.some(function (item, index) {
                                    if (_this.current_edit == item.id) {
                                        _this.options.data.scenarios[index].media.url = response.filename;
                                        _this.options.data.scenarios[index].media.type = 'image';
                                        _this.saveRequest({method: 'mdData', options: {'json': _this.options.data}});
                                        _this.generatePreviewMedia(_this.options.data.scenarios[index].media.url, 'image');
                                        $$('.edit .main_edit .media').hide();
                                        $$('.edit .main_edit .preview_media').show();
                                        return true;
                                    }
                                });
                            }
                        };
                        xhr.send(formData);
                        break;
                    default:
                        _this.options.data.scenarios.some(function (item, index) {
                            if (_this.current_edit == item.id) {
                                _this.options.data.scenarios[index].media.url = message.data.data.source_value;
                                _this.options.data.scenarios[index].media.type = message.data.media_type;
                                _this.saveRequest({method: 'mdData', options: {'json': _this.options.data}});
                                _this.generatePreviewMedia(item.media.url, message.data.media_type);
                                return true;
                            }
                        });
                        break;
                }
                break;
        }
    },
    validate_weight: function (weight) {
        var ok = true;
        if (isNaN(weight) || weight < 0) {
            return false;
        }
        this.options.data.scenarios.some(function (item) {
            if (_this.current_edit != item.id && item.id != '1234') {
                var start_value = parseInt(item.weight_start);
                var end_value = parseInt(item.weight_end);
                if (weight >= start_value && weight <= end_value) {
                    ok = false;
                    return true;
                }
            }
        });
        if (ok) {
            return true;
        } else {
            return false;
        }
    },
    tempAlert: function (msg, duration) {
        var el = document.createElement("div");
        el.className = 'alert';
        el.innerHTML = msg;
        setTimeout(function () {
            el.parentNode.removeChild(el);
        }, duration);
        document.body.appendChild(el);
    },
    editEvents: function () {
        $$('.edit .text_edit').addEvent('input', function () {
            $$('.add_scenario')[0].removeAttribute('disabled');
            _this.delay();
        });
        $$('.edit .decision_points').addEvent('change', function () {
            $$('.edit .decisions').set('html', '');
            if (this.get('value') != 0) {
                $$('.edit .reset_points').setStyle('visibility', 'visible');
            } else {
                $$('.edit .reset_points').setStyle('visibility', 'hidden');
            }
            for (var i = 0; i < this.get('value'); i++) {
                _this.generateDecision(i, '', 0);
            }
        });
        $$('.edit .add_scenario').addEvent('click', function (e) {
            e.preventDefault();
            var id = _this.newScenario();
            _this.generateEditDOM(id);
            _this.saveRequest({method: 'mdData', options: {'json': _this.options.data}});
        });
        $$('.edit .main_edit .scenario_weight input').addEvent('change', function () {
            var _input = this;
            var this_value = parseInt(this.get('value'));
            var oposite_value = null;
            var ok = true;
            if (this.get('id') === 'weight_end') {
                oposite_value = parseInt($('weight_start').get('value'));
                if (this_value < 1) {
                    ok = false;
                    _this.tempAlert('This score is already being used.', 3000);
                } else if (this_value < oposite_value) {
                    ok = false;
                    _this.tempAlert('The last weight delimiter cannot be lesser than the first one.', 3000);
                }
            } else {
                oposite_value = $('weight_end').get('value');
                if (this_value > oposite_value) {
                    ok = false;
                    _this.tempAlert('The first weight delimiter cannot be greater than the last one.', 3000);
                }
            }

            if (_this.validate_weight(this_value) && ok) {
                this.removeClass('error');
                _this.delay();
            } else {
                if (oposite_value > 0) {
                    this.set('value', oposite_value);
                } else {
                    this.set('value', 1);
                }
                this.addClass('error');
                setTimeout(function () {
                    _input.removeClass('error');
                }, 3000);
                if (ok) {
                    _this.tempAlert('This score is already being used.', 3000);
                }
            }
        });
        $$('.edit .remove_scenario').addEvent('click', function (e) {
            e.preventDefault();
            if (typeof _this.options.data.scenarios === 'undefined' || _this.options.data.scenarios.length < 2) {
                alert("You cannot have 0 scenarios.");
                return false;
            }
            var ok = confirm('Are you sure you want to remove?');
            if (ok) {
                if (typeof _this.options.data.scenarios !== 'undefined' && _this.options.data.scenarios.length > 0) {
                    _this.options.data.scenarios.some(function (item, index) {
                        if (_this.current_edit == item.id) {
                            if (item.weight_start == 0 && item.weight_end == 0) {
                                alert('You cannot delete the very first scenario.');
                                return true;
                            }
                            _this.options.data.scenarios.splice(index, 1);
                            _this.saveRequest({method: 'mdData', options: {'json': _this.options.data}});
                            setTimeout(function () {
                                location.reload();
                            }, 300);
                            return true;
                        }
                    });
                }
            }
        });
        $$('.edit .main_edit .tool_bar a').addEvent('click', function (e) {
            e.preventDefault();
            if (this.hasClass('clicked')) {
                this.removeClass('clicked');
                $$('.edit .main_edit .media').hide();
                $$('.edit .main_edit .preview_media').show();
                return false;
            }
            var text = '';
            var type = this.get('data-type');
            switch (type) {
                case 'image':
                    text = 'Drop image or click for more media options';
                    break;
                case 'audio':
                    text = 'Click for embed audio options';
                    break;
                case 'video':
                    text = 'Click for embed video options';
                    break;
            }
            this.addClass('clicked');
            $$('.edit .main_edit .preview_media').hide();
            $$('.edit .main_edit .media').show();
            $$('.edit .main_edit .media').set('html', text);
            $$('.edit .main_edit .media').removeEvents(['click']);
            $$('.edit .main_edit .media').addEvent('click', function () {
                parent.postMessage({method: 'show-media-popup', media_type: type}, "*");
            });
        });

        $$('.edit .reset_points').addEvent('click', function (e) {
            e.preventDefault();
            var ok = confirm('Are you sure you want to reset the points?');
            if (ok) {
                if (typeof _this.options.data.scenarios !== 'undefined' && _this.options.data.scenarios.length > 0) {
                    _this.options.data.scenarios.some(function (item, index) {
                        if (_this.current_edit == item.id) {
                            $$('.decisions').set('html', '');
                            $$('.edit .decision_points option').some(function (_item) {
                                if (_item.get('value') == 0) {
                                    _item.setAttribute('selected', 'selected');
                                } else {
                                    _item.removeAttribute('selected');
                                }
                            });
                            _this.options.data.scenarios[index].choices = [];
                            _this.saveRequest({method: 'mdData', options: {'json': _this.options.data}});
                            return true;
                        }
                    });
                }
            }
        });

        /* Drag and Drop Files */
        $$('.edit .media')[0].ondragover = function () {
            this.addClass('dragover');
            return false;
        };
        $$('.edit .media')[0].ondragend = function () {
            this.removeClass('dragover');
            return false;
        };
        $$('.edit .media')[0].ondragleave = function () {
            this.removeClass('dragover');
            return false;
        };
        $$('.edit .media')[0].ondrop = function (e) {
            var file = e.dataTransfer.files[0];
            if (file.type === 'image/jpeg' || file.type === 'image/png' || file.type === 'image/gif') {

            } else {
                alert('You can only upload .jpg, .png, .gif types of images.');
                return false;
            }
            this.removeClass('dragover');
            var formData = new FormData();
            formData.append('file', file);
            var pathUpload = location.href;
            if (pathUpload.indexOf("?") > 0) {
                pathUpload = pathUpload.split("?")[0];
            }
            formData.append('path', pathUpload);
            formData.append('directory', 'images');
            var xhr = new XMLHttpRequest();
            xhr.open('POST', _this.root + 'api/index.php/upload/');
            xhr.onload = function () {
                if (xhr.status === 200) {
                    var response = JSON.parse(xhr.responseText);
                    _this.options.data.scenarios.some(function (item, index) {
                        if (_this.current_edit == item.id) {
                            _this.options.data.scenarios[index].media.url = response.filename;
                            _this.options.data.scenarios[index].media.type = 'image';
                            _this.saveRequest({method: 'mdData', options: {'json': _this.options.data}});
                            _this.generatePreviewMedia(_this.options.data.scenarios[index].media.url, 'image');
                            $$('.edit .main_edit .media').hide();
                            $$('.edit .main_edit .preview_media').show();
                            return true;
                        }
                    });
                }
            };
            xhr.send(formData);
            return false;
        };
    },
    newScenario: function () {
        var scenario = {};
        scenario.text = '';
        scenario.choices = [];
        scenario.media = {url: '', type: ''};
        scenario.weight_start = this.last_weight + 1;
        scenario.weight_end = this.last_weight + 1;
        var d = new Date();
        var id = d.getTime();
        scenario.id = String(id);
        this.current_edit = id;
        this.options.data.scenarios.push(scenario);
        return id;
    },
    save: function () {
        console.log('saved!');
        var text = $$('.edit .text_edit')[0].get('value');
        var choices = [];
        var decisions = $$('.edit .decisions .decision');
        if (decisions.length > 0) {
            decisions.each(function (item) {
                var textarea = item.getElement('textarea');
                var weight = item.getElement('input[type="number"]');
                choices.push({text: textarea.get('value'), weight: weight.get('value')});
            });
        }

        var weight_start = $('weight_start').get('value');
        var weight_end = $('weight_end').get('value');
        this.last_weight = parseInt(weight_end);

        this.options.data.scenarios.some(function (item, index) {
            if (_this.current_edit == item.id) {
                _this.options.data.scenarios[index].text = text;
                _this.options.data.scenarios[index].weight_start = weight_start;
                _this.options.data.scenarios[index].weight_end = weight_end;
                if (choices.length > 0) {
                    _this.options.data.scenarios[index].choices = choices;
                }
                _this.saveRequest({method: 'mdData', options: {'json': _this.options.data}});
                return true;
            }
        });
    },
    generatePreviewMedia: function (url, type) {
        var text_1 = '';
        var text_2 = '';
        var a = '';
        switch (type) {
            case 'image':
                text_1 = 'Preview Image';
                text_2 = 'Edit Image';
                a = '<image src="images/' + url +'" style="display:none" />';
                a += '<a href="images/' + url + '" target="_blank">' + text_1 + '</a> | ';
                break;
            case 'audio':
                text_1 = 'Preview Audio';
                text_2 = 'Edit Audio';
                a = '<a href="' + url + '" target="_blank">' + text_1 + '</a> | ';
                break;
            case 'video':
                text_1 = 'Preview Video';
                text_2 = 'Edit Video';
                a = '<a href="' + url + '" target="_blank">' + text_1 + '</a> | ';
                break;
        }
        var edit = new Element('a', {html: text_2, href: '#'});
        edit.addEvent('click', function (e) {
            e.preventDefault();
            parent.postMessage({method: 'show-media-popup', media_type: type}, "*");
        });
        var remove = new Element('a', {html: ' | Remove', href: '#'});
        remove.addEvent('click', function (e) {
            e.preventDefault();
            var ok = confirm('Are you sure you want to delete the current media?');
            if (ok) {
                _this.options.data.scenarios.some(function (item, index) {
                    if (_this.current_edit == item.id) {
                        _this.options.data.scenarios[index].media.url = '';
                        _this.options.data.scenarios[index].media.type = '';
                        _this.saveRequest({method: 'mdData', options: {'json': _this.options.data}});
                        $$('.preview_media').hide();
                        return true;
                    }
                });
            }
        });
        $$('.preview_media').appendHTML(a);
        $$('.preview_media').adopt(edit);
        $$('.preview_media').adopt(remove);
    },
    generateEditDOM: function (id) {
        $$('.add_scenario')[0].removeAttribute('disabled');
        var scenario = null;
        var number = 0;
        this.options.data.scenarios.each(function (item, index) {
            var weight_end = parseInt(item.weight_end);
            if (weight_end > _this.last_weight) {
                _this.last_weight = weight_end;
            }
            if (typeof id === 'undefined') {
                if (item.weight_start == 0 && item.weight_end == 0) {
                    number = index + 1;
                    _this.current_edit = item.id;
                    scenario = item;
                    $$('.edit .main_edit .scenario_weight').hide();
                }
            } else {
                if (id == item.id) {
                    number = index + 1;
                    _this.current_edit = id;
                    scenario = item;
                    $$('.edit .main_edit .scenario_weight').show();
                    if (item.weight_start == 0 && item.weight_end == 0) {
                        $$('.edit .main_edit .scenario_weight').hide();
                    }
                }
            }
        });
        $$('.edit .main_edit .title').set('html', 'Scenario ' + number);
        $$('.edit .text_edit').set('value', scenario.text);
        $('weight_start').set('value', scenario.weight_start);
        $('weight_end').set('value', scenario.weight_end);
        $$('.preview_media').set('html', '');
        if (scenario.media.url !== '' && scenario.media.type !== '') {
            switch (scenario.media.type) {
                case 'image':
                    _this.generatePreviewMedia(scenario.media.url, 'image');
                    break;
                default:
                    _this.generatePreviewMedia(scenario.media.url, scenario.media.type);
                    break;
            }
        }

        $$('.edit .decisions').set('html', '');
        $$('.edit .decision_points option').some(function (item) {
            if (parseInt(item.get('value')) === scenario.choices.length) {
                item.setAttribute('selected', 'selected');
                return true;
            } else {
                item.removeAttribute('selected');
            }
        });
        if (scenario.choices.length > 0) {
            $$('.edit .reset_points').setStyle('visibility', 'visible');
            scenario.choices.each(function (item, index) {
                _this.generateDecision(index, item.text, item.weight);
            });
        }

        this.editNav();
    },
    delay: function () {
        clearTimeout(this.timer);
        this.timer = setTimeout(function () {
            _this.save();
        }, 500);
    },
    render: function (rerender) {
        if (this.isEditMode) {
            $$('.preview').hide();
            this.generateEditDOM();
            this.editEvents();
        } else {
            $$('.edit').hide();
            this.generateDOM();
            this.choicesEvents();
            if(!rerender) this.navEvents();
        }
    }
});
